/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.routing.util.parsers.CarAverageSpeedParser;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CarTagParserTest {
    private final EncodingManager em = this.createEncodingManager("car");
    final CarAccessParser parser = this.createParser((EncodedValueLookup)this.em, new PMap("block_fords=true"));
    final CarAverageSpeedParser speedParser = new CarAverageSpeedParser((EncodedValueLookup)this.em);
    private final BooleanEncodedValue roundaboutEnc = this.em.getBooleanEncodedValue("roundabout");
    private final BooleanEncodedValue accessEnc = this.parser.getAccessEnc();
    private final DecimalEncodedValue avSpeedEnc = this.speedParser.getAverageSpeedEnc();

    private EncodingManager createEncodingManager(String carName) {
        return new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)carName)).add((EncodedValue)VehicleSpeed.create((String)carName, (int)7, (double)2.0, (boolean)true)).addTurnCostEncodedValue((EncodedValue)TurnCost.create((String)carName, (int)1)).add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"bike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)Smoothness.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)FerrySpeed.create()).build();
    }

    CarAccessParser createParser(EncodedValueLookup lookup, PMap properties) {
        return new CarAccessParser(lookup, properties);
    }

    @Test
    public void testAccess() {
        ReaderWay way = new ReaderWay(1L);
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"service");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.setTag("motorcar", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade2");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.setTag("tracktype", (Object)"grade4");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"delivery");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"unclassified");
        way.setTag("ford", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("motorcar", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("access", (Object)"yes");
        way.setTag("motor_vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"yes");
        way.setTag("motor_vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("motor_vehicle", (Object)"agricultural");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("motor_vehicle", (Object)"agricultural;forestry");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("motor_vehicle", (Object)"forestry;agricultural");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("motor_vehicle", (Object)"forestry;agricultural;unknown");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("motor_vehicle", (Object)"yes;forestry;agricultural");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"no");
        way.setTag("motorcar", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"emergency");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("motor_vehicle", (Object)"emergency");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("service", (Object)"emergency_access");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"unclassified");
        way.setTag("motor_vehicle", (Object)"agricultural;destination;forestry");
        Assertions.assertFalse((boolean)this.parser.getAccess(way).canSkip());
    }

    @Test
    public void testMilitaryAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("access", (Object)"military");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
    }

    @Test
    public void testFordAccess() {
        ReaderNode node = new ReaderNode(0L, 0.0, 0.0);
        node.setTag("ford", (Object)"yes");
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"unclassified");
        way.setTag("ford", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.isBlockFords());
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        Assertions.assertTrue((boolean)this.parser.isBarrier(node));
        CarAccessParser tmpParser = new CarAccessParser((EncodedValueLookup)this.em, new PMap("block_fords=false"));
        Assertions.assertTrue((boolean)tmpParser.getAccess(way).isWay());
        Assertions.assertFalse((boolean)tmpParser.isBarrier(node));
    }

    @Test
    public void testOneway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("oneway", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:forward", (Object)"no");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:backward", (Object)"no");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:backward", (Object)"designated");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
    }

    @Test
    public void shouldBlockPrivate() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"private");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        CarAccessParser parser = this.createParser((EncodedValueLookup)this.em, new PMap("block_private=false"));
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)parser.getAccessEnc().getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("highway", (Object)"primary");
        way.setTag("motor_vehicle", (Object)"permit");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)parser.getAccessEnc().getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSetAccess() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testMaxSpeed() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"trunk");
        way.setTag("maxspeed", (Object)"500");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)136.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:backward", (Object)"10");
        way.setTag("maxspeed:forward", (Object)"20");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)18.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:forward", (Object)"20");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)18.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:backward", (Object)"20");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)66.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)18.0, (double)this.avSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway");
        way.setTag("maxspeed", (Object)"none");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)136.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway_link");
        way.setTag("maxspeed", (Object)"70 mph");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)102.0, (double)this.avSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testSpeed() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"trunk");
        way.setTag("maxspeed", (Object)"110");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)100.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("surface", (Object)"cobblestone");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)30.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)16.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade1");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)20.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("surface", (Object)"compacted");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)30.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("motorroad", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)60.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"motorway");
        way.setTag("motorroad", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)100.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"motorway_link");
        way.setTag("motorroad", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)70.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        try {
            this.avSpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, -1.0);
            Assertions.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetSpeed() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.avSpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 10.0);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testSetSpeed0_issue367_issue1234() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.speedParser.setSpeed(false, edgeId, (EdgeIntAccess)edgeIntAccess, 30.0);
        this.speedParser.setSpeed(true, edgeId, (EdgeIntAccess)edgeIntAccess, 40.0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$testSetSpeed0_issue367_issue1234$0(edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)40.0, (double)this.avSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        this.speedParser.setSpeed(false, edgeId, (EdgeIntAccess)edgeIntAccess, 1.0);
        Assertions.assertEquals((double)this.avSpeedEnc.getSmallestNonZeroValue(), (double)this.avSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testRoundabout() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.accessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.accessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.roundaboutEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertTrue((boolean)this.roundaboutEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        this.roundaboutEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        Assertions.assertFalse((boolean)this.roundaboutEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.roundaboutEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testRailway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"rail");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("railway", (Object)"abandoned");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"track");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.setTag("highway", (Object)"primary");
        way.setTag("railway", (Object)"historic");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.setTag("motorcar", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"tram");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
    }

    @Test
    public void testFerry() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("route", (Object)"shuttle_train");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("bicycle", (Object)"no");
        way.setTag("way_distance", (Object)50000.0);
        way.setTag("speed_from_duration", (Object)85.71428571428571);
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
        way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("way_distance", (Object)100.0);
        way.setTag("speed_from_duration", (Object)0.5);
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
        way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("edge_distance", (Object)100.0);
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
        way.setTag("motorcar", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("foot", (Object)"designated");
        way.setTag("motor_vehicle", (Object)"designated");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.setTag("vehicle", (Object)"yes");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isFerry());
    }

    @Test
    public void testBarrierAccess() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"lift_gate");
        node.setTag("access", (Object)"yes");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"lift_gate");
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"lift_gate");
        node.setTag("access", (Object)"yes");
        node.setTag("bicycle", (Object)"yes");
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"lift_gate");
        node.setTag("access", (Object)"no");
        node.setTag("motorcar", (Object)"yes");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"bollard");
        Assertions.assertTrue((boolean)this.parser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"cattle_grid");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
    }

    @Test
    public void testChainBarrier() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"chain");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
        node.setTag("motor_vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.isBarrier(node));
        node.setTag("motor_vehicle", (Object)"yes");
        Assertions.assertFalse((boolean)this.parser.isBarrier(node));
    }

    @Test
    public void testMaxValue() {
        DecimalEncodedValueImpl smallFactorSpeedEnc = new DecimalEncodedValueImpl("car_average_speed", 10, 0.5, true);
        EncodingManager em = new EncodingManager.Builder().add((EncodedValue)new SimpleBooleanEncodedValue("car_access", true)).add((EncodedValue)smallFactorSpeedEnc).add((EncodedValue)FerrySpeed.create()).addTurnCostEncodedValue((EncodedValue)TurnCost.create((String)"car", (int)1)).build();
        CarAverageSpeedParser speedParser = new CarAverageSpeedParser((EncodedValueLookup)em);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway_link");
        way.setTag("maxspeed", (Object)"60 mph");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)em.getBytesForFlags());
        int edgeId = 0;
        speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)86.9, (double)smallFactorSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)86.9, (double)smallFactorSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(2L);
        way.setTag("highway", (Object)"motorway_link");
        way.setTag("maxspeed", (Object)"70 mph");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)em.getBytesForFlags());
        speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)101.5, (double)smallFactorSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testCombination() {
        ReaderWay way = new ReaderWay(123L);
        way.setTag("highway", (Object)"cycleway");
        way.setTag("sac_scale", (Object)"hiking");
        BikeAccessParser bikeParser = new BikeAccessParser((EncodedValueLookup)this.em, new PMap());
        Assertions.assertEquals((Object)WayAccess.CAN_SKIP, (Object)this.parser.getAccess(way));
        Assertions.assertNotEquals((Object)WayAccess.CAN_SKIP, (Object)bikeParser.getAccess(way));
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        bikeParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        BooleanEncodedValue bikeAccessEnc = bikeParser.getAccessEnc();
        Assertions.assertTrue((boolean)bikeAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)bikeAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testApplyBadSurfaceSpeed() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("surface", (Object)"unpaved");
        Assertions.assertEquals((double)30.0, (double)this.speedParser.applyBadSurfaceSpeed(way, 90.0), (double)0.1);
    }

    @Test
    public void testIssue_1256() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("edge_distance", (Object)257.0);
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)2.0, (double)this.speedParser.getAverageSpeedEnc().getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        DecimalEncodedValueImpl lowFactorSpeedEnc = new DecimalEncodedValueImpl(VehicleSpeed.key((String)"car"), 10, 1.0, false);
        EncodingManager lowFactorEm = new EncodingManager.Builder().add((EncodedValue)new SimpleBooleanEncodedValue(VehicleAccess.key((String)"car"), true)).add((EncodedValue)lowFactorSpeedEnc).add((EncodedValue)FerrySpeed.create()).build();
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)lowFactorEm.getBytesForFlags());
        new CarAverageSpeedParser((EncodedValueLookup)lowFactorEm).handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)1.0, (double)lowFactorSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void temporalAccess() {
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access:conditional", (Object)"no @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motorcar:conditional", (Object)"no @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motorcar", (Object)"no");
        way.setTag("access:conditional", (Object)"yes @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("vehicle", (Object)"no");
        way.setTag("bicycle:conditional", (Object)"yes @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("motorcar:conditional", (Object)"yes @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("motorcar:conditional", (Object)"yes @ (10:00 - 11:00)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("motorcar:conditional", (Object)"private @ (10:00 - 11:00)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @ParameterizedTest
    @ValueSource(strings={"mofa", "moped", "motorcar", "motor_vehicle", "motorcycle"})
    void footway_etc_not_allowed_despite_vehicle_yes(String vehicle) {
        for (String highway : Arrays.asList("footway", "cycleway", "steps")) {
            ReaderWay way = new ReaderWay(1L);
            way.setTag("highway", (Object)highway);
            way.setTag(vehicle, (Object)"yes");
            Assertions.assertEquals((Object)WayAccess.CAN_SKIP, (Object)this.parser.getAccess(way));
        }
    }

    @Test
    void nonHighwaysFallbackSpeed_issue2845() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("man_made", (Object)"pier");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(false, 0, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("railway", (Object)"platform");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(false, 0, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("route", (Object)"ski");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(false, 0, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"abandoned");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)10.0, (double)this.avSpeedEnc.getDecimal(false, 0, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"construction");
        way.setTag("maxspeed", (Object)"100");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.speedParser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)90.0, (double)this.avSpeedEnc.getDecimal(false, 0, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    void testPedestrianAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"pedestrian");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("motor_vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("motor_vehicle", (Object)"unknown");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("motor_vehicle", (Object)"destination");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("motorcar", (Object)"no");
        way.setTag("motor_vehicle", (Object)"destination");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("motor_vehicle:conditional", (Object)"destination @ ( 8:00 - 10:00 )");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("access", (Object)"no");
        way.setTag("motor_vehicle:conditional", (Object)"destination @ ( 8:00 - 10:00 )");
        Assertions.assertTrue((boolean)this.parser.getAccess(way).isWay());
    }

    private /* synthetic */ void lambda$testSetSpeed0_issue367_issue1234$0(int edgeId, EdgeIntAccess edgeIntAccess) throws Throwable {
        this.speedParser.setSpeed(false, edgeId, edgeIntAccess, 0.09);
    }
}

