/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.routing.util.parsers.FootPriorityParser;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FootTagParserTest {
    private final BooleanEncodedValue footAccessEnc = VehicleAccess.create((String)"foot");
    private final DecimalEncodedValue footAvgSpeedEnc = VehicleSpeed.create((String)"foot", (int)4, (double)1.0, (boolean)false);
    private final DecimalEncodedValue footPriorityEnc = VehiclePriority.create((String)"foot", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false);
    private final BooleanEncodedValue bikeAccessEnc = VehicleAccess.create((String)"bike");
    private final DecimalEncodedValue bikeAvgSpeedEnc = VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false);
    private final BooleanEncodedValue carAccessEnc = VehicleAccess.create((String)"car");
    private final DecimalEncodedValue carAvSpeedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.footAccessEnc).add((EncodedValue)this.footAvgSpeedEnc).add((EncodedValue)this.footPriorityEnc).add((EncodedValue)RouteNetwork.create((String)FootNetwork.KEY)).add((EncodedValue)this.bikeAccessEnc).add((EncodedValue)this.bikeAvgSpeedEnc).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)this.carAccessEnc).add((EncodedValue)this.carAvSpeedEnc).add((EncodedValue)FerrySpeed.create()).build();
    private final FootAccessParser accessParser = new FootAccessParser((EncodedValueLookup)this.encodingManager, new PMap());
    private final FootAverageSpeedParser speedParser = new FootAverageSpeedParser((EncodedValueLookup)this.encodingManager);
    private final FootPriorityParser prioParser = new FootPriorityParser((EncodedValueLookup)this.encodingManager);

    @Test
    public void testGetSpeed() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.footAccessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.footAccessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.footAvgSpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 10.0);
        Assertions.assertEquals((double)10.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testSteps() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"service");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.setTag("highway", (Object)"steps");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((5.0 > this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess) ? 1 : 0) != 0);
    }

    @Test
    public void testCombined() {
        BaseGraph g = new BaseGraph.Builder(this.encodingManager).create();
        EdgeIteratorState edge = g.edge(0, 1);
        edge.set(this.footAvgSpeedEnc, 10.0).set(this.footAccessEnc, true, true);
        edge.set(this.carAvSpeedEnc, 100.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((double)10.0, (double)edge.get(this.footAvgSpeedEnc), (double)0.1);
        Assertions.assertTrue((boolean)edge.get(this.footAccessEnc));
        Assertions.assertTrue((boolean)edge.getReverse(this.footAccessEnc));
        Assertions.assertEquals((double)100.0, (double)edge.get(this.carAvSpeedEnc), (double)0.1);
        Assertions.assertTrue((boolean)edge.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)edge.getReverse(this.carAccessEnc));
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.footAvgSpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 10.0);
        this.footAccessEnc.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        this.footAccessEnc.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertEquals((double)0.0, (double)this.carAvSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testGraph() {
        BaseGraph g = new BaseGraph.Builder(this.encodingManager).create();
        g.edge(0, 1).setDistance(10.0).set(this.footAvgSpeedEnc, 10.0).set(this.footAccessEnc, true, true);
        g.edge(0, 2).setDistance(10.0).set(this.footAvgSpeedEnc, 5.0).set(this.footAccessEnc, true, true);
        g.edge(1, 3).setDistance(10.0).set(this.footAvgSpeedEnc, 10.0).set(this.footAccessEnc, true, true);
        EdgeExplorer out = g.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)this.footAccessEnc));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{1, 2}), (Object)GHUtility.getNeighbors((EdgeIterator)out.setBaseNode(0)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0, 3}), (Object)GHUtility.getNeighbors((EdgeIterator)out.setBaseNode(1)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0}), (Object)GHUtility.getNeighbors((EdgeIterator)out.setBaseNode(2)));
    }

    @Test
    public void testAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway");
        way.setTag("sidewalk", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("sidewalk", (Object)"left");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("sidewalk", (Object)"none");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("sidewalk", (Object)"left");
        way.setTag("access", (Object)"private");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"footway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"platform");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"motorway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"path");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("foot", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("motorroad", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("access", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("foot", (Object)"yes");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"designated");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"permissive");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("foot", (Object)"designated");
        way.setTag("access", (Object)"private");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
    }

    @Test
    public void testRailPlatformIssue366() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("railway", (Object)"platform");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("railway", (Object)"platform");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("railway", (Object)"tram");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)0.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testPier() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("man_made", (Object)"pier");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testOneway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"path");
        way.setTag("foot:forward", (Object)"yes");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("foot:backward", (Object)"yes");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testMixSpeedAndSafe() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)0.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("sidewalk", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testPriority() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"cycleway");
        Assertions.assertEquals((int)PriorityCode.UNCHANGED.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("highway", (Object)"primary");
        Assertions.assertEquals((int)PriorityCode.AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("sidewalk", (Object)"yes");
        Assertions.assertEquals((int)PriorityCode.AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("sidewalk", (Object)"no");
        Assertions.assertEquals((int)PriorityCode.BAD.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        Assertions.assertEquals((int)PriorityCode.UNCHANGED.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("foot", (Object)"use_sidepath");
        Assertions.assertEquals((int)PriorityCode.VERY_BAD.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("sidewalk", (Object)"no");
        Assertions.assertEquals((int)PriorityCode.AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"official");
        Assertions.assertEquals((int)PriorityCode.SLIGHT_AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertEquals((int)PriorityCode.SLIGHT_AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("highway", (Object)"cycleway");
        way.setTag("bicycle", (Object)"designated");
        way.setTag("foot", (Object)"designated");
        Assertions.assertEquals((int)PriorityCode.PREFER.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        way.setTag("sidewalk", (Object)"no");
        Assertions.assertEquals((int)PriorityCode.AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"road");
        way.setTag("bicycle", (Object)"official");
        way.setTag("sidewalk", (Object)"no");
        Assertions.assertEquals((int)PriorityCode.SLIGHT_AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        Assertions.assertEquals((int)PriorityCode.AVOID.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("highway", (Object)"trunk");
        Assertions.assertEquals((int)PriorityCode.BAD.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("sidewalk", (Object)"no");
        Assertions.assertEquals((int)PriorityCode.REACH_DESTINATION.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.setTag("sidewalk", (Object)"none");
        Assertions.assertEquals((int)PriorityCode.REACH_DESTINATION.getValue(), (int)this.prioParser.handlePriority(way, null));
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("sidewalk", (Object)"yes");
        Assertions.assertEquals((int)PriorityCode.PREFER.getValue(), (int)this.prioParser.handlePriority(way, null));
    }

    @Test
    public void testSlowHiking() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("sac_scale", (Object)"hiking");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)5.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way.setTag("highway", (Object)"track");
        way.setTag("sac_scale", (Object)"mountain_hiking");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertEquals((double)2.0, (double)this.footAvgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testReadBarrierNodesFromWay() {
        int edgeId = 0;
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("gh:barrier_edge", (Object)true);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("barrier", "gate");
        tags.put("access", "no");
        way.setTag("node_tags", Collections.singletonList(tags));
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way);
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testBarrierAccess() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.setTag("bicycle", (Object)"yes");
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.setTag("foot", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("locked", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.clearTags();
        node.setTag("barrier", (Object)"yes");
        node.setTag("locked", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.clearTags();
        node.setTag("barrier", (Object)"yes");
        node.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testChainBarrier() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"chain");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testFord() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("ford", (Object)"no");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("ford", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("foot", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        FootAccessParser blockFordsParser = new FootAccessParser((EncodedValueLookup)this.encodingManager, new PMap("block_fords=true"));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("ford", (Object)"no");
        Assertions.assertFalse((boolean)blockFordsParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("ford", (Object)"yes");
        Assertions.assertTrue((boolean)blockFordsParser.isBarrier(node));
    }

    @Test
    public void testBlockByDefault() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"fence");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.setTag("barrier", (Object)"fence");
        node.setTag("access", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("access", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"fence");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"cattle_grid");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void maxSpeed() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("foot_speed", 4, 2.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(100.0).set((DecimalEncodedValue)speedEnc, 15.0);
        Assertions.assertEquals((double)16.0, (double)edge.get((DecimalEncodedValue)speedEnc));
        Assertions.assertEquals((double)16.0, (double)speedEnc.getNextStorableValue(15.0));
    }

    @Test
    public void temporalAccess() {
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access:conditional", (Object)"no @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("foot:conditional", (Object)"no @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("foot", (Object)"no");
        way.setTag("access:conditional", (Object)"yes @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("foot:conditional", (Object)"yes @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.footAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }
}

