/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.FootRoadAccess;
import com.graphhopper.routing.ev.HikeRating;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.routing.util.parsers.FootPriorityParser;
import com.graphhopper.routing.util.parsers.OSMHikeRatingParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HikeCustomModelTest {
    private EncodingManager em;
    private OSMParsers parsers;

    @BeforeEach
    public void setup() {
        IntEncodedValue hikeRating = HikeRating.create();
        this.em = new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"foot")).add((EncodedValue)VehicleSpeed.create((String)"foot", (int)4, (double)1.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"foot", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)FerrySpeed.create()).add((EncodedValue)RouteNetwork.create((String)FootNetwork.KEY)).add((EncodedValue)FootRoadAccess.create()).add((EncodedValue)hikeRating).build();
        this.parsers = new OSMParsers().addWayTagParser((TagParser)new OSMHikeRatingParser(hikeRating));
        this.parsers.addWayTagParser((TagParser)new FootAccessParser((EncodedValueLookup)this.em, new PMap()));
        this.parsers.addWayTagParser((TagParser)new FootAverageSpeedParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new FootPriorityParser((EncodedValueLookup)this.em));
    }

    EdgeIteratorState createEdge(ReaderWay way) {
        BaseGraph graph = new BaseGraph.Builder(this.em).create();
        EdgeIteratorState edge = graph.edge(0, 1);
        this.parsers.handleWayTags(edge.getEdge(), graph.getEdgeAccess(), way, this.em.createRelationFlags());
        return edge;
    }

    @Test
    public void testHikePrivate() {
        CustomModel cm = GHUtility.loadCustomModelFromJar((String)"hike.json");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"track");
        EdgeIteratorState edge = this.createEdge(way);
        CustomWeighting.Parameters p = CustomModelParser.createWeightingParameters((CustomModel)cm, (EncodedValueLookup)this.em);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("motor_vehicle", (Object)"private");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"alpine_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        Assertions.assertEquals((double)1.5, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"track");
        way.setTag("access", (Object)"private");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"alpine_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
    }
}

