/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MaxWeightExcept;
import com.graphhopper.routing.util.parsers.MaxWeightExceptParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MaxWeightExceptParserTest {
    private final int edgeId = 0;
    private EnumEncodedValue<MaxWeightExcept> mwEnc;
    private MaxWeightExceptParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.mwEnc = MaxWeightExcept.create();
        this.mwEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new MaxWeightExceptParser(this.mwEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("maxweight:conditional", (Object)"none @delivery");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.DELIVERY, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("maxweight:conditional", (Object)"no@ (destination)");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.DESTINATION, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testConditionalTags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv:conditional", (Object)"no @ (weight > 7.5)");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.MISSING, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.clearTags();
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("vehicle:conditional", (Object)"delivery @ (weight > 5)");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.MISSING, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.clearTags();
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("vehicle:conditional", (Object)"delivery @ (weight > 7.5)");
        readerWay.setTag("maxweight", (Object)"7.5");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.DELIVERY, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.clearTags();
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv:conditional", (Object)"destination @ (maxweight > 5)");
        readerWay.setTag("maxweight", (Object)"5");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)MaxWeightExcept.DESTINATION, (Object)this.mwEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
    }
}

