/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.BusAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.ModeAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ModeAccessParserTest {
    private final EncodingManager em = new EncodingManager.Builder().add((EncodedValue)Roundabout.create()).add((EncodedValue)BusAccess.create()).build();
    private final ModeAccessParser parser = new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.BUS), this.em.getBooleanEncodedValue("bus_access"), true, this.em.getBooleanEncodedValue("roundabout"), Set.of(), Set.of());
    private final BooleanEncodedValue busAccessEnc = this.em.getBooleanEncodedValue("bus_access");

    ModeAccessParserTest() {
    }

    @Test
    public void testAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testPrivate() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"private");
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testOneway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("oneway", (Object)"yes");
        int edgeId = 0;
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:forward", (Object)"no");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:backward", (Object)"no");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("bus:backward", (Object)"yes");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:backward", (Object)"yes");
        way.setTag("bus:backward", (Object)"no");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testBusYes() {
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(0L);
        way.setTag("motor_vehicle", (Object)"no");
        way.setTag("highway", (Object)"tertiary");
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("bus", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("oneway:bus", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("oneway:psv", (Object)"no");
        way.setTag("oneway:bus", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(true, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testBusNo() {
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"tertiary");
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("bus", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testBusNodeAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("gh:barrier_edge", (Object)true);
        way.setTag("node_tags", List.of(Map.of("access", "no", "bus", "yes"), Map.of()));
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        way.setTag("node_tags", List.of(Map.of("access", "yes", "bus", "no")));
        access = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        way.setTag("access", (Object)"no");
        way.setTag("node_tags", List.of(Map.of("bus", "yes"), Map.of()));
        access = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testBarrier() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("gh:barrier_edge", (Object)true);
        way.setTag("node_tags", Arrays.asList(Map.of("barrier", "bollard"), Map.of()));
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        way.setTag("node_tags", Arrays.asList(Map.of("barrier", "gate"), Map.of()));
        access = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        SimpleBooleanEncodedValue tmpAccessEnc = new SimpleBooleanEncodedValue("tmp_access", true);
        EncodingManager tmpEM = new EncodingManager.Builder().add((EncodedValue)tmpAccessEnc).add((EncodedValue)Roundabout.create()).build();
        ModeAccessParser tmpParser = new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.CAR), (BooleanEncodedValue)tmpAccessEnc, true, tmpEM.getBooleanEncodedValue("roundabout"), Set.of(), Set.of("kissing_gate"));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("gh:barrier_edge", (Object)true);
        way.setTag("node_tags", List.of(Map.of("barrier", "bollard"), Map.of()));
        access = new ArrayEdgeIntAccess(1);
        tmpParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)tmpAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testPsvYes() {
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(0L);
        way.setTag("motor_vehicle", (Object)"no");
        way.setTag("highway", (Object)"tertiary");
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("psv", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("psv", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testMotorcycleYes() {
        SimpleBooleanEncodedValue mcAccessEnc = new SimpleBooleanEncodedValue("motorcycle_access", true);
        EncodingManager mcEM = new EncodingManager.Builder().add((EncodedValue)mcAccessEnc).add((EncodedValue)Roundabout.create()).build();
        ModeAccessParser mcParser = new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.MOTORCYCLE), (BooleanEncodedValue)mcAccessEnc, true, mcEM.getBooleanEncodedValue("roundabout"), Set.of(), Set.of());
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(0L);
        way.setTag("motor_vehicle", (Object)"no");
        way.setTag("highway", (Object)"tertiary");
        mcParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)mcAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way.setTag("motorcycle", (Object)"yes");
        mcParser.handleWayTags(0, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)mcAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void temporalAccess() {
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access:conditional", (Object)"no @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("psv:conditional", (Object)"no @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("psv", (Object)"no");
        way.setTag("access:conditional", (Object)"yes @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("psv:conditional", (Object)"yes @ (May - June)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.busAccessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }
}

