/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractBikeTagParserTester;
import com.graphhopper.routing.util.parsers.BikeCommonAccessParser;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikeCommonPriorityParser;
import com.graphhopper.routing.util.parsers.MountainBikeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.MountainBikePriorityParser;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MountainBikeTagParserTest
extends AbstractBikeTagParserTester {
    @Override
    protected EncodingManager createEncodingManager() {
        return new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"mtb")).add((EncodedValue)VehicleSpeed.create((String)"mtb", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"mtb", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)Roundabout.create()).add((EncodedValue)Smoothness.create()).add((EncodedValue)FerrySpeed.create()).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)RouteNetwork.create((String)MtbNetwork.KEY)).build();
    }

    @Override
    protected BikeCommonAccessParser createAccessParser(EncodedValueLookup lookup, PMap pMap) {
        return new MountainBikeAccessParser(lookup, pMap);
    }

    @Override
    protected BikeCommonAverageSpeedParser createAverageSpeedParser(EncodedValueLookup lookup) {
        return new MountainBikeAverageSpeedParser(lookup);
    }

    @Override
    protected BikeCommonPriorityParser createPriorityParser(EncodedValueLookup lookup) {
        return new MountainBikePriorityParser(lookup);
    }

    @Test
    public void testSpeedAndPriority() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 18.0, way);
        way.setTag("highway", (Object)"residential");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 16.0, way);
        way.setTag("highway", (Object)"footway");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.setTag("highway", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"yes");
        way.setTag("tracktype", (Object)"grade3");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, way);
        way.setTag("tracktype", (Object)"grade1");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_PREFER, 18.0, way);
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"ground");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 16.0, way);
    }

    @Test
    public void testSmoothness() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        way.setTag("smoothness", (Object)"excellent");
        Assertions.assertEquals((double)18.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"unknown");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("surface", (Object)"ground");
        Assertions.assertEquals((double)16.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade5");
        Assertions.assertEquals((double)6.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
    }

    @Test
    public void testHandleWayTagsInfluencedByBikeAndMtbRelation() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"track");
        ReaderRelation osmRel = new ReaderRelation(1L);
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.BEST, 18.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"rcn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"ncn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"tertiary");
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.BEST, 18.0, osmWay, osmRel);
        osmWay.clearTags();
        osmRel.clearTags();
        osmWay.setTag("highway", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmRel.setTag("route", (Object)"mtb");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"rcn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"ncn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"tertiary");
        osmRel.setTag("route", (Object)"mtb");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, osmWay, osmRel);
    }

    @Override
    @Test
    public void testBarrierAccess() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"kissing_gate");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"kissing_gate");
        node.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"kissing_gate");
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testPreferenceForSlowSpeed() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"tertiary");
        this.assertPriority(PriorityCode.PREFER, osmWay);
    }
}

