/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.Crossing;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.util.parsers.OSMCrossingParser;
import com.graphhopper.util.PMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OSMCrossingParserTest {
    private OSMCrossingParser parser;
    private EnumEncodedValue<Crossing> crossingEV;

    OSMCrossingParserTest() {
    }

    @BeforeEach
    public void setup() {
        this.crossingEV = new EnumEncodedValue("crossing", Crossing.class);
        this.crossingEV.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMCrossingParser(this.crossingEV);
    }

    @Test
    public void testRailway() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("railway", (Object)"level_crossing").toMap()), null);
        Assertions.assertEquals((Object)Crossing.RAILWAY, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSignals() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing", (Object)"traffic_signals").toMap()), null);
        Assertions.assertEquals((Object)Crossing.TRAFFIC_SIGNALS, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing:signals", (Object)"yes").toMap()), null);
        Assertions.assertEquals((Object)Crossing.TRAFFIC_SIGNALS, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing:signals", (Object)"no").toMap()), null);
        Assertions.assertEquals((Object)Crossing.UNMARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testMarked() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new HashMap<String, Object>()), null);
        Assertions.assertEquals((Object)Crossing.MISSING, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("highway", (Object)"crossing").toMap()), null);
        Assertions.assertEquals((Object)Crossing.UNMARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing", (Object)"marked").toMap()), null);
        Assertions.assertEquals((Object)Crossing.MARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing:markings", (Object)"yes").toMap()), null);
        Assertions.assertEquals((Object)Crossing.MARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing:markings", (Object)"no").toMap()), null);
        Assertions.assertEquals((Object)Crossing.UNMARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, this.createReader(new PMap().putObject("crossing:signals", (Object)"no").putObject("crossing:markings", (Object)"yes").toMap()), null);
        Assertions.assertEquals((Object)Crossing.MARKED, (Object)this.crossingEV.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    ReaderWay createReader(Map<String, Object> map) {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("node_tags", Collections.singletonList(map));
        return way;
    }
}

