/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.OSMGetOffBikeParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OSMGetOffBikeParserTest {
    private final BooleanEncodedValue offBikeEnc = GetOffBike.create();
    private final BikeAccessParser accessParser;
    private final OSMGetOffBikeParser getOffParser;

    public OSMGetOffBikeParserTest() {
        EncodingManager em = new EncodingManager.Builder().add((EncodedValue)this.offBikeEnc).add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)Roundabout.create()).build();
        this.accessParser = new BikeAccessParser((EncodedValueLookup)em, new PMap());
        this.getOffParser = new OSMGetOffBikeParser(this.offBikeEnc, this.accessParser.getAccessEnc());
    }

    @Test
    public void testHandleCommonWayTags() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"steps");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("highway", (Object)"footway");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("highway", (Object)"footway");
        way.setTag("surface", (Object)"pebblestone");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("highway", (Object)"residential");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"footway");
        way.setTag("surface", (Object)"grass");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"official");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"permissive");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("railway", (Object)"platform");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("bicycle", (Object)"dismount");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"platform");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("foot", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"pedestrian");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"concrete");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"official");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"permissive");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"path");
        way.setTag("foot", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("foot", (Object)"designated");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"cycleway");
        way.setTag("vehicle", (Object)"no");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertFalse((boolean)this.isGetOffBike(way));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("vehicle", (Object)"forestry");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
        way.setTag("vehicle", (Object)"forestry;agricultural");
        Assertions.assertTrue((boolean)this.isGetOffBike(way));
    }

    @Test
    public void testOneway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("oneway", (Object)"yes");
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        IntsRef rel = new IntsRef(1);
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        this.getOffParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertFalse((boolean)this.offBikeEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)this.offBikeEnc.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    private boolean isGetOffBike(ReaderWay way) {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        IntsRef rel = new IntsRef(1);
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, rel);
        this.getOffParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, rel);
        return this.offBikeEnc.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess);
    }
}

