/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.HazmatTunnel;
import com.graphhopper.routing.util.parsers.OSMHazmatTunnelParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMHazmatTunnelParserTest {
    private EnumEncodedValue<HazmatTunnel> hazTunnelEnc;
    private OSMHazmatTunnelParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.hazTunnelEnc = HazmatTunnel.create();
        this.hazTunnelEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMHazmatTunnelParser(this.hazTunnelEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testADRTunnelCat() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:adr_tunnel_cat", (Object)"A");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.A, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:adr_tunnel_cat", (Object)"B");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.B, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:adr_tunnel_cat", (Object)"C");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.C, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:adr_tunnel_cat", (Object)"D");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.D, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:adr_tunnel_cat", (Object)"E");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.E, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testTunnelCat() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:tunnel_cat", (Object)"A");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.A, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:tunnel_cat", (Object)"B");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.B, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:tunnel_cat", (Object)"C");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.C, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:tunnel_cat", (Object)"D");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.D, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:tunnel_cat", (Object)"E");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.E, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testHazmatSubtags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:A", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.A, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:B", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.B, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:C", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.C, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:D", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.D, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:E", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.E, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testOrder() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:A", (Object)"no");
        readerWay.setTag("hazmat:B", (Object)"no");
        readerWay.setTag("hazmat:C", (Object)"no");
        readerWay.setTag("hazmat:D", (Object)"no");
        readerWay.setTag("hazmat:E", (Object)"no");
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.E, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:A", (Object)"no");
        readerWay.setTag("hazmat:B", (Object)"no");
        readerWay.setTag("hazmat:C", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.C, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("tunnel", (Object)"yes");
        readerWay.setTag("hazmat:B", (Object)"no");
        readerWay.setTag("hazmat:E", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.E, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testIgnoreNonTunnelSubtags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("hazmat:B", (Object)"no");
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.A, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testNoNPE() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatTunnel.A, (Object)this.hazTunnelEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

