/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.HazmatWater;
import com.graphhopper.routing.util.parsers.OSMHazmatWaterParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMHazmatWaterParserTest {
    private EnumEncodedValue<HazmatWater> hazWaterEnc;
    private OSMHazmatWaterParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.hazWaterEnc = HazmatWater.create();
        this.hazWaterEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMHazmatWaterParser(this.hazWaterEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("hazmat:water", (Object)"no");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatWater.NO, (Object)this.hazWaterEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("hazmat:water", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatWater.YES, (Object)this.hazWaterEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("hazmat:water", (Object)"permissive");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatWater.PERMISSIVE, (Object)this.hazWaterEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testNoNPE() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)HazmatWater.YES, (Object)this.hazWaterEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

