/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Hgv;
import com.graphhopper.routing.util.parsers.OSMHgvParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OSMHgvParserTest {
    private final int edgeId = 0;
    private EnumEncodedValue<Hgv> hgvEnc;
    private OSMHgvParser parser;
    private IntsRef relFlags;

    OSMHgvParserTest() {
    }

    @BeforeEach
    public void setUp() {
        this.hgvEnc = Hgv.create();
        this.hgvEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMHgvParser(this.hgvEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv", (Object)"destination");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)Hgv.DESTINATION, (Object)this.hgvEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testConditionalTags() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv:conditional", (Object)"no @ (weight > 3.5)");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)Hgv.NO, (Object)this.hgvEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("hgv:conditional", (Object)"delivery @ (weight > 7.5)");
        this.parser.handleWayTags(0, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)Hgv.MISSING, (Object)this.hgvEnc.getEnum(false, 0, (EdgeIntAccess)edgeIntAccess));
    }
}

