/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.util.parsers.OSMLanesParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OSMLanesParserTest {
    private final IntEncodedValue lanesEnc = Lanes.create();
    private OSMLanesParser parser;
    private IntsRef relFlags;

    OSMLanesParserTest() {
    }

    @BeforeEach
    void setup() {
        this.lanesEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMLanesParser(this.lanesEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    void basic() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("lanes", (Object)"4");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((int)4, (int)this.lanesEnc.getInt(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    void notTagged() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((int)1, (int)this.lanesEnc.getInt(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

