/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.MaxAxleLoad;
import com.graphhopper.routing.util.parsers.OSMMaxAxleLoadParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMMaxAxleLoadParserTest {
    private DecimalEncodedValue malEnc;
    private OSMMaxAxleLoadParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.malEnc = MaxAxleLoad.create();
        this.malEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMMaxAxleLoadParser(this.malEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("maxaxleload", (Object)"11.5");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)11.5, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("maxaxleload", (Object)"80");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)63.0, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
    }

    @Test
    public void testRounding() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("maxaxleload", (Object)"4.8");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)5.0, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("maxaxleload", (Object)"3.6");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)3.5, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("maxaxleload", (Object)"2.4");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)2.5, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
    }

    @Test
    public void testNoLimit() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.malEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
    }
}

