/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class OSMMaxSpeedParserTest {
    OSMMaxSpeedParserTest() {
    }

    @Test
    void countryRule() {
        DecimalEncodedValue maxSpeedEnc = MaxSpeed.create();
        maxSpeedEnc.init(new EncodedValue.InitializerConfig());
        OSMMaxSpeedParser parser = new OSMMaxSpeedParser(maxSpeedEnc);
        IntsRef relFlags = new IntsRef(2);
        ReaderWay way = new ReaderWay(29L);
        way.setTag("highway", (Object)"primary");
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        way.setTag("maxspeed", (Object)"30");
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((double)30.0, (double)maxSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(29L);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:forward", (Object)"30");
        way.setTag("maxspeed:backward", (Object)"40");
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((double)30.0, (double)maxSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)40.0, (double)maxSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void parseMaxSpeed() {
        ReaderWay way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"90");
        Assertions.assertEquals((double)90.0, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"90");
        way.setTag("maxspeed:backward", (Object)"50");
        Assertions.assertEquals((double)90.0, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        Assertions.assertEquals((double)50.0, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)true), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"none");
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"none");
        way.setTag("highway", (Object)"secondary");
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"none");
        way.setTag("highway", (Object)"motorway");
        Assertions.assertEquals((double)150.0, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"3");
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"5");
        Assertions.assertEquals((double)5.0, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
        way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"3mph");
        Assertions.assertEquals((double)4.83, (double)OSMMaxSpeedParser.parseMaxSpeed((ReaderWay)way, (boolean)false), (double)0.01);
    }

    @ParameterizedTest
    @ValueSource(strings={"motorway", "motorway_link", "trunk", "trunk_link", "primary"})
    void maxSpeedNone(String highway) {
        DecimalEncodedValue maxSpeedEnc = MaxSpeed.create();
        maxSpeedEnc.init(new EncodedValue.InitializerConfig());
        OSMMaxSpeedParser parser = new OSMMaxSpeedParser(maxSpeedEnc);
        IntsRef relFlags = new IntsRef(2);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((double)0.0, (double)maxSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        ReaderWay way = new ReaderWay(29L);
        way.setTag("highway", (Object)highway);
        way.setTag("maxspeed", (Object)"none");
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((double)150.0, (double)maxSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    void smallMaxSpeed() {
        DecimalEncodedValue maxSpeedEnc = MaxSpeed.create();
        maxSpeedEnc.init(new EncodedValue.InitializerConfig());
        OSMMaxSpeedParser parser = new OSMMaxSpeedParser(maxSpeedEnc);
        IntsRef relFlags = new IntsRef(2);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(29L);
        way.setTag("highway", (Object)"service");
        way.setTag("maxspeed", (Object)"3 mph");
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((double)4.0, (double)maxSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void parseMaxspeedString() {
        Assertions.assertEquals((double)40.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"40 km/h"), (double)0.1);
        Assertions.assertEquals((double)40.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"40km/h"), (double)0.1);
        Assertions.assertEquals((double)40.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"40kmh"), (double)0.1);
        Assertions.assertEquals((double)64.4, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"40mph"), (double)0.1);
        Assertions.assertEquals((double)48.3, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"30 mph"), (double)0.1);
        Assertions.assertEquals((double)18.5, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"10 knots"), (double)0.1);
        Assertions.assertEquals((double)19.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"19 kph"), (double)0.1);
        Assertions.assertEquals((double)19.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"19kph"), (double)0.1);
        Assertions.assertEquals((double)100.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"100"), (double)0.1);
        Assertions.assertEquals((double)100.5, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"100.5"), (double)0.1);
        Assertions.assertEquals((double)4.8, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"3 mph"), (double)0.1);
        Assertions.assertEquals((double)-1.0, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"none"), (double)0.1);
    }

    @Test
    public void parseMaxspeedString_invalid() {
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString(null));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"-20"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"0"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"1"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"1km/h"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"1mph"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"2"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"3"));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)OSMMaxSpeedParser.parseMaxspeedString((String)"4"));
    }
}

