/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.MaxWeight;
import com.graphhopper.routing.util.parsers.OSMMaxWeightParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMMaxWeightParserTest {
    private final int edgeId = 0;
    private DecimalEncodedValue mwEnc;
    private OSMMaxWeightParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.mwEnc = MaxWeight.create();
        this.mwEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMMaxWeightParser(this.mwEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("maxweight", (Object)"5");
        Assertions.assertEquals((double)5.0, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay.setTag("maxweight", (Object)"54");
        Assertions.assertEquals((double)51.0, (double)this.getMaxWeight(readerWay), (double)0.01);
    }

    @Test
    public void testConditionalTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("access:conditional", (Object)"no @ (weight > 7.5)");
        Assertions.assertEquals((double)7.5, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay.setTag("access:conditional", (Object)"no @ weight > 7");
        Assertions.assertEquals((double)7.0, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv:conditional", (Object)"no @ (weight > 7.5)");
        Assertions.assertEquals((double)7.5, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("hgv:conditional", (Object)"none @ (weight > 10t)");
        Assertions.assertEquals((double)10.0, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay.setTag("hgv:conditional", (Object)"no@ (weight > 7)");
        Assertions.assertEquals((double)7.0, (double)this.getMaxWeight(readerWay), (double)0.01);
        readerWay.setTag("hgv:conditional", (Object)"no @ (maxweight > 6)");
        Assertions.assertEquals((double)6.0, (double)this.getMaxWeight(readerWay), (double)0.01);
    }

    double getMaxWeight(ReaderWay readerWay) {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        return this.mwEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess);
    }
}

