/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.MtbRating;
import com.graphhopper.routing.util.parsers.OSMMtbRatingParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OSMMtbRatingParserTest {
    OSMMtbRatingParserTest() {
    }

    @Test
    void test() {
        this.checkRating(0, null);
        this.checkRating(1, "0");
        this.checkRating(6, "5");
        this.checkRating(7, "6");
        this.checkRating(2, "1+");
        this.checkRating(3, "2-");
        this.checkRating(0, "-1");
        this.checkRating(0, "S1");
        this.checkRating(0, "8");
        this.checkRating(0, "12");
        this.checkRating(0, "23");
        this.checkRating(0, "1-2");
        this.checkRating(0, "0;1");
        this.checkRating(0, "1;2");
    }

    private void checkRating(int expectedRating, String scaleString) {
        IntEncodedValue ev = MtbRating.create();
        ev.init(new EncodedValue.InitializerConfig());
        OSMMtbRatingParser parser = new OSMMtbRatingParser(ev);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(0L);
        if (scaleString != null) {
            way.setTag("mtb:scale", (Object)scaleString);
        }
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(2));
        Assertions.assertEquals((int)expectedRating, (int)ev.getInt(false, edgeId, (EdgeIntAccess)edgeIntAccess), (String)("unexpected rating for mtb:scale=" + scaleString));
    }
}

