/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.graphhopper.reader.osm.OSMRestrictionConverter;
import com.graphhopper.reader.osm.Pair;
import com.graphhopper.reader.osm.RestrictionTopology;
import com.graphhopper.reader.osm.RestrictionType;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.parsers.RestrictionSetter;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMRestrictionSetterTest {
    private static final IntArrayList NO_PATH = IntArrayList.from((int[])new int[0]);
    private DecimalEncodedValue speedEnc;
    private BooleanEncodedValue turnRestrictionEnc;
    private BaseGraph graph;
    private RestrictionSetter r;

    @BeforeEach
    void setup() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnRestrictionEnc = TurnRestriction.create((String)"car1");
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).add((EncodedValue)this.turnRestrictionEnc).build();
        this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        this.r = new RestrictionSetter(this.graph, List.of(this.turnRestrictionEnc));
    }

    @Test
    void viaNode_no() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        this.edge(1, 3);
        this.edge(2, 4);
        this.edge(3, 4);
        RestrictionTopology topology = RestrictionTopology.node((int)a, (int)1, (int)b);
        this.setRestrictions(List.of(new Pair((Object)topology, (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 3, 4, 2), (Object)this.calcPath(0, 2));
    }

    @Test
    void viaNode_only() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        this.edge(1, 3);
        this.edge(2, 4);
        this.edge(3, 4);
        RestrictionTopology topology = RestrictionTopology.node((int)a, (int)1, (int)b);
        this.setRestrictions(List.of(new Pair((Object)topology, (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 4, 3), (Object)this.calcPath(0, 3));
    }

    @Test
    void viaWay_no() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        this.edge(2, 4);
        this.edge(1, 5);
        this.edge(5, 8);
        this.edge(2, 6);
        this.edge(6, 9);
        this.edge(8, 9);
        RestrictionTopology topology = RestrictionTopology.way((int)a, (int)b, (int)c, (IntArrayList)this.nodes(1, 2));
        this.setRestrictions(List.of(new Pair((Object)topology, (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 5, 8, 9, 6, 2, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 4), (Object)this.calcPath(0, 4));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 3), (Object)this.calcPath(5, 3));
    }

    @Test
    void viaWay_no_withOverlap() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        int d = this.edge(3, 4);
        int s = this.edge(1, 5);
        int t = this.edge(2, 6);
        int u = this.edge(3, 7);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)b, (int)c, (IntArrayList)this.nodes(1, 2)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)b, (int)c, (int)d, (IntArrayList)this.nodes(2, 3)), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 6), (Object)this.calcPath(0, 6));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 3), (Object)this.calcPath(5, 3));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 6), (Object)this.calcPath(5, 6));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(1, 4));
        Assertions.assertEquals((Object)this.nodes(1, 2, 3, 7), (Object)this.calcPath(1, 7));
        Assertions.assertEquals((Object)this.nodes(6, 2, 3, 4), (Object)this.calcPath(6, 4));
        Assertions.assertEquals((Object)this.nodes(6, 2, 3, 7), (Object)this.calcPath(6, 7));
    }

    @Test
    void viaWay_no_withOverlap_more_complex() {
        int s = this.edge(0, 3);
        this.edge(1, 4);
        this.edge(2, 3);
        int a = this.edge(3, 4);
        int t = this.edge(4, 5);
        int b = this.edge(3, 7);
        int d = this.edge(4, 8);
        this.edge(6, 7);
        int c = this.edge(7, 8);
        this.edge(8, 9);
        this.edge(7, 10);
        this.edge(8, 11);
        this.edge(10, 11);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.node((int)t, (int)4, (int)d), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.node((int)s, (int)3, (int)a), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)a, (int)b, (int)c, (IntArrayList)this.nodes(3, 7)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)b, (int)c, (int)d, (IntArrayList)this.nodes(7, 8)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)c, (int)d, (int)a, (IntArrayList)this.nodes(8, 4)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)d, (int)a, (int)b, (IntArrayList)this.nodes(4, 3)), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)this.nodes(0, 3, 7, 8, 9), (Object)this.calcPath(0, 9));
        Assertions.assertEquals((Object)this.nodes(5, 4, 3, 7, 10, 11, 8, 9), (Object)this.calcPath(5, 9));
        Assertions.assertEquals((Object)this.nodes(5, 4, 3, 2), (Object)this.calcPath(5, 2));
        Assertions.assertEquals((Object)this.nodes(0, 3, 7, 10), (Object)this.calcPath(0, 10));
        Assertions.assertEquals((Object)this.nodes(6, 7, 8, 9), (Object)this.calcPath(6, 9));
    }

    @Test
    void viaWay_common_via_edge_opposite_direction() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(1, 4);
        int d = this.edge(3, 4);
        int e = this.edge(4, 5);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)b, (int)c, (int)e, (IntArrayList)this.nodes(1, 4)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)d, (int)c, (int)a, (IntArrayList)this.nodes(4, 1)), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2), (Object)this.calcPath(0, 2));
        Assertions.assertEquals((Object)this.nodes(0, 1, 4, 5), (Object)this.calcPath(0, 5));
        Assertions.assertEquals((Object)this.nodes(0, 1, 4, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(2, 1, 0), (Object)this.calcPath(2, 0));
        Assertions.assertEquals((Object)this.nodes(2, 1, 4, 3), (Object)this.calcPath(2, 3));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(2, 5));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(3, 0));
        Assertions.assertEquals((Object)this.nodes(3, 4, 1, 2), (Object)this.calcPath(3, 2));
        Assertions.assertEquals((Object)this.nodes(3, 4, 5), (Object)this.calcPath(3, 5));
        Assertions.assertEquals((Object)this.nodes(5, 4, 1, 0), (Object)this.calcPath(5, 0));
        Assertions.assertEquals((Object)this.nodes(5, 4, 1, 2), (Object)this.calcPath(5, 2));
        Assertions.assertEquals((Object)this.nodes(5, 4, 3), (Object)this.calcPath(5, 3));
    }

    @Test
    void viaWay_common_via_edge_same_direction() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(1, 4);
        int d = this.edge(3, 4);
        int e = this.edge(4, 5);
        Assertions.assertEquals((Object)this.nodes(0, 1, 4, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(2, 1, 4, 5), (Object)this.calcPath(2, 5));
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)c, (int)d, (IntArrayList)this.nodes(1, 4)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)b, (int)c, (int)e, (IntArrayList)this.nodes(1, 4)), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(3, 4, 1, 0), (Object)this.calcPath(3, 0));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(2, 5));
        Assertions.assertEquals((Object)this.nodes(5, 4, 1, 2), (Object)this.calcPath(5, 2));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2), (Object)this.calcPath(0, 2));
        Assertions.assertEquals((Object)this.nodes(1, 4, 3), (Object)this.calcPath(1, 3));
        Assertions.assertEquals((Object)this.nodes(0, 1, 4, 5), (Object)this.calcPath(0, 5));
        Assertions.assertEquals((Object)this.nodes(2, 1, 4, 3), (Object)this.calcPath(2, 3));
    }

    @Test
    void viaWay_only() {
        int a = this.edge(1, 2);
        int b = this.edge(0, 2);
        int c = this.edge(2, 3);
        int d = this.edge(2, 5);
        int e = this.edge(4, 5);
        int f = this.edge(5, 7);
        int g = this.edge(5, 6);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)d, (int)f, (IntArrayList)this.nodes(2, 5)), (Object)RestrictionType.ONLY), new Pair((Object)RestrictionTopology.node((int)d, (int)5, (int)e), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.node((int)e, (int)5, (int)f), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)this.nodes(1, 2, 5, 7), (Object)this.calcPath(1, 7));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(1, 3));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(1, 4));
        Assertions.assertEquals((Object)this.nodes(0, 2, 5, 6), (Object)this.calcPath(0, 6));
        Assertions.assertEquals((Object)this.nodes(0, 2, 5, 7), (Object)this.calcPath(0, 7));
    }

    @Test
    void viaWay_only_twoRestrictionsSharingSameVia() {
        int a = this.edge(0, 1);
        int b = this.edge(5, 1);
        int c = this.edge(1, 2);
        int d = this.edge(2, 3);
        int e = this.edge(2, 4);
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 4), (Object)this.calcPath(0, 4));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 3), (Object)this.calcPath(5, 3));
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)c, (int)d, (IntArrayList)this.nodes(1, 2)), (Object)RestrictionType.ONLY), new Pair((Object)RestrictionTopology.way((int)b, (int)c, (int)e, (IntArrayList)this.nodes(1, 2)), (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(5, 3));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 4), (Object)this.calcPath(5, 4));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 4));
        Assertions.assertEquals((Object)this.nodes(3, 2, 1, 0), (Object)this.calcPath(3, 0));
        Assertions.assertEquals((Object)this.nodes(3, 2, 1, 5), (Object)this.calcPath(3, 5));
        Assertions.assertEquals((Object)this.nodes(4, 2, 1, 0), (Object)this.calcPath(4, 0));
        Assertions.assertEquals((Object)this.nodes(4, 2, 1, 5), (Object)this.calcPath(4, 5));
    }

    @Test
    void viaWay_only_twoRestrictionsSharingSameVia_different_directions() {
        int a = this.edge(0, 1);
        int b = this.edge(5, 1);
        int c = this.edge(1, 2);
        int d = this.edge(2, 3);
        int e = this.edge(2, 4);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)c, (int)d, (IntArrayList)this.nodes(1, 2)), (Object)RestrictionType.ONLY), new Pair((Object)RestrictionTopology.way((int)e, (int)c, (int)b, (IntArrayList)this.nodes(2, 1)), (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 4));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 5));
        Assertions.assertEquals((Object)this.nodes(3, 2, 1, 0), (Object)this.calcPath(3, 0));
        Assertions.assertEquals((Object)this.nodes(3, 2, 4), (Object)this.calcPath(3, 4));
        Assertions.assertEquals((Object)this.nodes(3, 2, 1, 5), (Object)this.calcPath(3, 5));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(4, 0));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(4, 3));
        Assertions.assertEquals((Object)this.nodes(4, 2, 1, 5), (Object)this.calcPath(4, 5));
        Assertions.assertEquals((Object)this.nodes(5, 1, 0), (Object)this.calcPath(5, 0));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 3), (Object)this.calcPath(5, 3));
        Assertions.assertEquals((Object)this.nodes(5, 1, 2, 4), (Object)this.calcPath(5, 4));
    }

    @Test
    void viaWayAndNode() {
        int e0_1 = this.edge(0, 1);
        int e0_4 = this.edge(0, 4);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        Assertions.assertEquals((Object)this.nodes(0, 1, 3), (Object)this.calcPath(0, 3));
        Assertions.assertEquals((Object)this.nodes(4, 0, 1, 2), (Object)this.calcPath(4, 2));
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)e0_4, (int)e0_1, (int)e1_2, (IntArrayList)this.nodes(0, 1)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.node((int)e0_1, (int)1, (int)e1_3), (Object)RestrictionType.NO)));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(4, 2));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(0, 3));
    }

    @Test
    void viaWay_overlapping_no_only() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        int d = this.edge(2, 4);
        int e = this.edge(4, 5);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (int)b, (int)c, (IntArrayList)this.nodes(1, 2)), (Object)RestrictionType.NO), new Pair((Object)RestrictionTopology.way((int)b, (int)d, (int)e, (IntArrayList)this.nodes(2, 4)), (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 4, 5), (Object)this.calcPath(0, 5));
    }

    @Test
    void multiViaWay_only() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        int d = this.edge(1, 4);
        int e = this.edge(2, 5);
        int f = this.edge(3, 6);
        int g = this.edge(4, 5);
        int h = this.edge(5, 6);
        Assertions.assertEquals((Object)this.nodes(0, 1, 4), (Object)this.calcPath(0, 4));
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((int)a, (IntArrayList)IntArrayList.from((int[])new int[]{b, c}), (int)f, (IntArrayList)this.nodes(1, 2, 3)), (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(0, 1, 2, 3, 6, 5, 4), (Object)this.calcPath(0, 4));
    }

    @Test
    void loop_only() {
        int e0_1 = this.edge(0, 1);
        int e1_0 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        int e1_4 = this.edge(1, 4);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.node((int)e1_3, (int)1, (int)e0_1), (Object)RestrictionType.ONLY), new Pair((Object)RestrictionTopology.way((int)e0_1, (int)e1_0, (int)e1_2, (IntArrayList)this.nodes(0, 1)), (Object)RestrictionType.ONLY)));
        Assertions.assertEquals((Object)this.nodes(3, 1, 0, 1, 2), (Object)this.calcPath(3, 2));
        Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(3, 4));
    }

    @Test
    void multiFrom_viaWay() {
        int e1_0 = this.edge(1, 0);
        int e2_0 = this.edge(2, 0);
        int e3_0 = this.edge(3, 0);
        int e0_4 = this.edge(0, 4);
        int e4_5 = this.edge(4, 5);
        int e4_6 = this.edge(4, 6);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((IntArrayList)this.edges(e1_0, e2_0, e3_0), (IntArrayList)this.edges(e0_4), (IntArrayList)this.edges(e4_6), (IntArrayList)this.nodes(1, 4)), (Object)RestrictionType.NO)));
        for (int s = 1; s <= 3; ++s) {
            Assertions.assertEquals((Object)this.nodes(s, 0, 4, 5), (Object)this.calcPath(s, 5));
            Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(s, 6));
            Assertions.assertEquals((Object)this.nodes(5, 4, 0, s), (Object)this.calcPath(5, s));
            Assertions.assertEquals((Object)this.nodes(6, 4, 0, s), (Object)this.calcPath(6, s));
        }
        Assertions.assertEquals((Object)this.nodes(1, 0, 2), (Object)this.calcPath(1, 2));
        Assertions.assertEquals((Object)this.nodes(3, 0, 1), (Object)this.calcPath(3, 1));
    }

    @Test
    void multiTo_viaWay() {
        int e1_0 = this.edge(1, 0);
        int e2_0 = this.edge(2, 0);
        int e0_3 = this.edge(0, 3);
        int e3_4 = this.edge(3, 4);
        int e3_5 = this.edge(3, 5);
        int e3_6 = this.edge(3, 6);
        this.setRestrictions(List.of(new Pair((Object)RestrictionTopology.way((IntArrayList)this.edges(e1_0), (IntArrayList)this.edges(e0_3), (IntArrayList)this.edges(e3_4, e3_5, e3_6), (IntArrayList)this.nodes(0, 3)), (Object)RestrictionType.NO)));
        for (int s = 4; s <= 6; ++s) {
            Assertions.assertEquals((Object)NO_PATH, (Object)this.calcPath(1, s));
            Assertions.assertEquals((Object)this.nodes(2, 0, 3, s), (Object)this.calcPath(2, s));
            Assertions.assertEquals((Object)this.nodes(s, 3, 0, 1), (Object)this.calcPath(s, 1));
            Assertions.assertEquals((Object)this.nodes(s, 3, 0, 2), (Object)this.calcPath(s, 2));
        }
        Assertions.assertEquals((Object)this.nodes(4, 3, 5), (Object)this.calcPath(4, 5));
        Assertions.assertEquals((Object)this.nodes(5, 3, 6), (Object)this.calcPath(5, 6));
    }

    private void setRestrictions(List<Pair<RestrictionTopology, RestrictionType>> osmRestrictions) {
        this.setRestrictions(osmRestrictions, osmRestrictions.stream().map(r -> this.encBits(1)).toList());
    }

    private void setRestrictions(List<Pair<RestrictionTopology, RestrictionType>> osmRestrictions, List<BitSet> osmEncBits) {
        ArrayList restrictions = new ArrayList();
        ArrayList encBits = new ArrayList();
        for (int i = 0; i < osmRestrictions.size(); ++i) {
            Pair<RestrictionTopology, RestrictionType> p = osmRestrictions.get(i);
            List tmpRestrictions = OSMRestrictionConverter.buildRestrictionsForOSMRestriction((BaseGraph)this.graph, (RestrictionTopology)((RestrictionTopology)p.first), (RestrictionType)((RestrictionType)p.second));
            restrictions.addAll(tmpRestrictions);
            BitSet e = osmEncBits.get(i);
            tmpRestrictions.forEach(__ -> encBits.add(RestrictionSetter.copyEncBits((BitSet)e)));
        }
        this.r.setRestrictions(restrictions, encBits);
    }

    private IntArrayList calcPath(int from, int to) {
        return this.calcPath(from, to, this.turnRestrictionEnc);
    }

    private IntArrayList calcPath(int from, int to, BooleanEncodedValue turnRestrictionEnc) {
        return this.calcPath((Graph)this.graph, from, to, turnRestrictionEnc);
    }

    private IntArrayList calcPath(final Graph graph, int from, int to, final BooleanEncodedValue turnRestrictionEnc) {
        return new IntArrayList((IntContainer)new Dijkstra(graph, graph.wrapWeighting((Weighting)new SpeedWeighting(this.speedEnc, new TurnCostProvider(){

            public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
                if (inEdge == outEdge) {
                    return Double.POSITIVE_INFINITY;
                }
                return graph.getTurnCostStorage().get(turnRestrictionEnc, inEdge, viaNode, outEdge) ? Double.POSITIVE_INFINITY : 0.0;
            }

            public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
                return Double.isInfinite(this.calcTurnWeight(inEdge, viaNode, outEdge)) ? Long.MAX_VALUE : 0L;
            }
        })), TraversalMode.EDGE_BASED).calcPath(from, to).calcNodes());
    }

    private IntArrayList edges(int ... edges) {
        return IntArrayList.from((int[])edges);
    }

    private IntArrayList nodes(int ... nodes) {
        return IntArrayList.from((int[])nodes);
    }

    private BitSet encBits(int ... bits) {
        BitSet b = new BitSet((long)bits.length);
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i] != 0 && bits[i] != 1) {
                throw new IllegalArgumentException("bits must be 0 or 1");
            }
            if (bits[i] <= 0) continue;
            b.set((long)i);
        }
        return b;
    }

    private int edge(int from, int to) {
        return this.edge(from, to, true);
    }

    private int edge(int from, int to, boolean bothDir) {
        return this.graph.edge(from, to).setDistance(100.0).set(this.speedEnc, 10.0, bothDir ? 10.0 : 0.0).getEdge();
    }
}

