/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeRoadAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OSMRoadAccessParserTest {
    private final EnumEncodedValue<RoadAccess> roadAccessEnc = RoadAccess.create();
    private OSMRoadAccessParser<RoadAccess> parser;
    private final EnumEncodedValue<BikeRoadAccess> bikeRAEnc = BikeRoadAccess.create();
    private OSMRoadAccessParser<BikeRoadAccess> bikeRAParser;

    OSMRoadAccessParserTest() {
    }

    @BeforeEach
    public void setup() {
        this.roadAccessEnc.init(new EncodedValue.InitializerConfig());
        this.bikeRAEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMRoadAccessParser(this.roadAccessEnc, OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.CAR), RoadAccess::countryHook, RoadAccess::find);
        this.bikeRAParser = new OSMRoadAccessParser(this.bikeRAEnc, OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.BIKE), (ignr, access) -> access, BikeRoadAccess::find);
    }

    @Test
    void countryRule() {
        IntsRef relFlags = new IntsRef(2);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("country_rule", (Object)new CountryRule(){

            public RoadAccess getAccess(ReaderWay readerWay, TransportationMode transportationMode, RoadAccess currentRoadAccess) {
                return RoadAccess.DESTINATION;
            }
        });
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.removeTag("country_rule");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("motor_vehicle", (Object)"agricultural;destination;forestry");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("motor_vehicle", (Object)"agricultural;forestry");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((Object)RoadAccess.AGRICULTURAL, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("motor_vehicle", (Object)"forestry;agricultural");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, relFlags);
        Assertions.assertEquals((Object)RoadAccess.AGRICULTURAL, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testPermit() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(1L);
        way.setTag("motor_vehicle", (Object)"permit");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)RoadAccess.PRIVATE, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testCar() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(1L);
        way.setTag("access", (Object)"private");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)RoadAccess.PRIVATE, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("motorcar", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)this.roadAccessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testBike() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(1L);
        way.setTag("access", (Object)"private");
        this.bikeRAParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)BikeRoadAccess.PRIVATE, (Object)this.bikeRAEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(1L);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("vehicle", (Object)"private");
        this.bikeRAParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)BikeRoadAccess.PRIVATE, (Object)this.bikeRAEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("bicycle", (Object)"yes");
        this.bikeRAParser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(1));
        Assertions.assertEquals((Object)BikeRoadAccess.YES, (Object)this.bikeRAEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

