/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMRoadClassParserTest {
    private EnumEncodedValue<RoadClass> rcEnc;
    private OSMRoadClassParser parser;
    private IntsRef relFlags;

    @BeforeEach
    public void setUp() {
        this.rcEnc = RoadClass.create();
        this.rcEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMRoadClassParser(this.rcEnc);
        this.relFlags = new IntsRef(2);
    }

    @Test
    public void testSimpleTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.PRIMARY, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        intAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"unknownstuff");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        intAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"motorway_link");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.MOTORWAY, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        readerWay = new ReaderWay(1L);
        readerWay.setTag("highway", (Object)"cycleway");
        intAccess = new ArrayEdgeIntAccess(1);
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.CYCLEWAY, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
    }

    @Test
    public void testIgnore() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("route", (Object)"ferry");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testNoNPE() {
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, readerWay, this.relFlags);
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)this.rcEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
    }
}

