/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OSMRoadEnvironmentParserTest {
    OSMRoadEnvironmentParserTest() {
    }

    @Test
    void ferry() {
        EnumEncodedValue roadEnvironmentEnc = RoadEnvironment.create();
        roadEnvironmentEnc.init(new EncodedValue.InitializerConfig());
        OSMRoadEnvironmentParser parser = new OSMRoadEnvironmentParser(roadEnvironmentEnc);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(0L);
        way.setTag("route", (Object)"shuttle_train");
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(2));
        RoadEnvironment roadEnvironment = (RoadEnvironment)roadEnvironmentEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess);
        Assertions.assertEquals((Object)RoadEnvironment.FERRY, (Object)roadEnvironment);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"footway");
        way.setTag("route", (Object)"ferry");
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, new IntsRef(2));
        roadEnvironment = (RoadEnvironment)roadEnvironmentEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess);
        Assertions.assertEquals((Object)RoadEnvironment.FERRY, (Object)roadEnvironment);
    }
}

