/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMSmoothnessParserTest {
    private EnumEncodedValue<Smoothness> smoothnessEnc;
    private OSMSmoothnessParser parser;

    @BeforeEach
    public void setUp() {
        this.smoothnessEnc = Smoothness.create();
        this.smoothnessEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMSmoothnessParser(this.smoothnessEnc);
    }

    @Test
    public void testSimpleTags() {
        IntsRef relFlags = new IntsRef(2);
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Smoothness.MISSING, (Object)this.smoothnessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("smoothness", (Object)"bad");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Smoothness.BAD, (Object)this.smoothnessEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((Smoothness.BAD.ordinal() < Smoothness.VERY_BAD.ordinal() ? 1 : 0) != 0);
    }
}

