/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.util.parsers.OSMSurfaceParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMSurfaceParserTest {
    private EnumEncodedValue<Surface> surfaceEnc;
    private OSMSurfaceParser parser;

    @BeforeEach
    public void setUp() {
        this.surfaceEnc = Surface.create();
        this.surfaceEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMSurfaceParser(this.surfaceEnc);
    }

    @Test
    public void testSimpleTags() {
        IntsRef relFlags = new IntsRef(2);
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.MISSING, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"cobblestone");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.COBBLESTONE, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((Surface.COBBLESTONE.ordinal() > Surface.ASPHALT.ordinal() ? 1 : 0) != 0);
        readerWay.setTag("surface", (Object)"wood");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.WOOD, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSynonyms() {
        IntsRef relFlags = new IntsRef(2);
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("surface", (Object)"metal");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.PAVED, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"sett");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.COBBLESTONE, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"unhewn_cobblestone");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.COBBLESTONE, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"earth");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.DIRT, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"pebblestone");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.GRAVEL, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"grass_paver");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.GRASS, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSubtypes() {
        IntsRef relFlags = new IntsRef(2);
        ReaderWay readerWay = new ReaderWay(1L);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("surface", (Object)"concrete:plates");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.CONCRETE, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        readerWay.setTag("surface", (Object)"cobblestone:flattened");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Surface.COBBLESTONE, (Object)this.surfaceEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

