/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.CarTemporalAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OSMTemporalAccessParserTest {
    private final EnumEncodedValue<CarTemporalAccess> restricted = CarTemporalAccess.create();
    private final EncodingManager em = new EncodingManager.Builder().add(this.restricted).build();
    private final OSMTemporalAccessParser parser = new OSMTemporalAccessParser(CarTemporalAccess.CONDITIONALS, (edgeId, access, b) -> this.restricted.setEnum(false, edgeId, access, (Enum)(b ? CarTemporalAccess.YES : CarTemporalAccess.NO)), "2023-05-17");

    OSMTemporalAccessParserTest() {
    }

    @Test
    public void testBasics() {
        String today = "2023 May 17";
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"road");
        way.setTag("access:conditional", (Object)("no @ (" + today + ")"));
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.NO, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("access:conditional", (Object)("no @ ( 2023 Mar 23 - " + today + " )"));
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.NO, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.clearTags();
        way.setTag("highway", (Object)"road");
        way.setTag("access", (Object)"no");
        way.setTag("access:conditional", (Object)("yes @ (" + today + ")"));
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.YES, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("access:conditional", (Object)"no @ ( Mar 23 - Aug 23 )");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.NO, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("access:conditional", (Object)"no @ ( Jun 23 - Aug 23 )");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.YES, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("access:conditional", (Object)"no @ ( 2023 Mar 23 )");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.YES, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        way.setTag("access:conditional", (Object)"yes @ Apr-Nov");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.YES, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testTaggingMistake() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"road");
        way.setTag("access:conditional", (Object)"no @ 2023 Mar-Oct");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way.setTag("access:conditional", (Object)"no @ 1 Nov - 1 Mar");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testWithoutDay_handleAsOpenAsPossible() {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motor_vehicle", (Object)"no");
        way.setTag("motor_vehicle:conditional", (Object)"yes @ (21:00-9:00)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motor_vehicle:conditional", (Object)"no @ (21:00-9:00)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motor_vehicle:conditional", (Object)"no @ (fuel=diesel AND emissions <= euro_6)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("motor_vehicle:conditional", (Object)"no @ (weight > 7)");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((Object)CarTemporalAccess.MISSING, (Object)this.restricted.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testPermissiveTemporalRestriction() {
        List<String> restrictionKeys = List.of("vehicle", "access");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"no");
        way.setTag("vehicle:conditional", (Object)"yes @ (May - June)");
        Assertions.assertTrue((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes")));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("vehicle", (Object)"no");
        way.setTag("access:conditional", (Object)"yes @ (May - June)");
        Assertions.assertTrue((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes")));
        way.setTag("access:conditional", (Object)"private @ (May - June)");
        Assertions.assertFalse((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes")));
        Assertions.assertTrue((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes", "private")));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access", (Object)"yes");
        way.setTag("vehicle:conditional", (Object)"no @ (May - June)");
        Assertions.assertFalse((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes")));
        way = new ReaderWay(0L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access:conditional", (Object)"yes @ weight < 3.5");
        Assertions.assertFalse((boolean)OSMTemporalAccessParser.hasPermissiveTemporalRestriction((ReaderWay)way, (int)1, restrictionKeys, Set.of("yes")));
    }
}

