/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.util.parsers.OSMTollParser;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMTollParserTest {
    private EnumEncodedValue<Toll> tollEnc;
    private OSMTollParser parser;

    @BeforeEach
    public void setUp() {
        this.tollEnc = Toll.create();
        this.tollEnc.init(new EncodedValue.InitializerConfig());
        this.parser = new OSMTollParser(this.tollEnc);
    }

    @Test
    public void testSimpleTags() {
        ReaderWay readerWay = new ReaderWay(1L);
        IntsRef relFlags = new IntsRef(2);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        readerWay.setTag("highway", (Object)"primary");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.NO, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("toll:hgv", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("toll:N2", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("toll:N3", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("toll", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.ALL, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        readerWay.setTag("highway", (Object)"primary");
        readerWay.setTag("toll", (Object)"yes");
        readerWay.setTag("toll:hgv", (Object)"yes");
        readerWay.setTag("toll:N2", (Object)"yes");
        readerWay.setTag("toll:N3", (Object)"yes");
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        Assertions.assertEquals((Object)Toll.ALL, (Object)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    void country() {
        Assertions.assertEquals((Object)Toll.ALL, (Object)this.getToll("motorway", "", Country.HUN));
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.getToll("trunk", "", Country.HUN));
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.getToll("primary", "", Country.HUN));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("secondary", "", Country.HUN));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("tertiary", "", Country.HUN));
        Assertions.assertEquals((Object)Toll.ALL, (Object)this.getToll("motorway", "", Country.FRA));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("trunk", "", Country.FRA));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("primary", "", Country.FRA));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("motorway", "", Country.MEX));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("trunk", "", Country.MEX));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("primary", "", Country.MEX));
        Assertions.assertEquals((Object)Toll.ALL, (Object)this.getToll("secondary", "toll=yes", Country.HUN));
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.getToll("secondary", "toll:hgv=yes", Country.HUN));
        Assertions.assertEquals((Object)Toll.HGV, (Object)this.getToll("secondary", "toll:N3=yes", Country.HUN));
        Assertions.assertEquals((Object)Toll.NO, (Object)this.getToll("secondary", "toll=no", Country.HUN));
    }

    private Toll getToll(String highway, String toll, Country country) {
        ReaderWay readerWay = new ReaderWay(123L);
        readerWay.setTag("highway", (Object)highway);
        readerWay.setTag("country", (Object)country);
        String[] tollKV = toll.split("=");
        if (tollKV.length > 1) {
            readerWay.setTag(tollKV[0], (Object)tollKV[1]);
        }
        IntsRef relFlags = new IntsRef(2);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.parser.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, readerWay, relFlags);
        return (Toll)this.tollEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess);
    }
}

