/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OSMValueExtractorTest {
    private final double DELTA = 0.001;

    @Test
    public void stringToTons() {
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"1.5"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"1.5 t"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"1.5   t"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"1.5 tons"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"1.5 ton"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToTons((String)"3306.9 lbs"), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)OSMValueExtractor.stringToTons((String)"3 T"), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)OSMValueExtractor.stringToTons((String)"3ton"), (double)0.001);
        Assertions.assertEquals((double)10.0, (double)OSMValueExtractor.stringToTons((String)"10000 kg"), (double)0.001);
        Assertions.assertEquals((double)25.401, (double)OSMValueExtractor.stringToTons((String)"28 st"), (double)0.001);
        Assertions.assertEquals((double)6.0, (double)OSMValueExtractor.stringToTons((String)"6t mgw"), (double)0.001);
    }

    @Test
    public void stringToTonsNaN() {
        Assertions.assertTrue((boolean)Double.isNaN(OSMValueExtractor.stringToTons((String)"weight limit 1.5t")));
    }

    @Test
    public void stringToTonsNaN2() {
        Assertions.assertTrue((boolean)Double.isNaN(OSMValueExtractor.stringToTons((String)"")));
    }

    @Test
    public void stringToMeter() {
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"1.5"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"1.5m"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"1.5 m"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"1.5   m"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"1.5 meter"), (double)0.001);
        Assertions.assertEquals((double)1.499, (double)OSMValueExtractor.stringToMeter((String)"4 ft 11 in"), (double)0.001);
        Assertions.assertEquals((double)1.499, (double)OSMValueExtractor.stringToMeter((String)"4'11''"), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)OSMValueExtractor.stringToMeter((String)"3 m."), (double)0.001);
        Assertions.assertEquals((double)3.0, (double)OSMValueExtractor.stringToMeter((String)"3meters"), (double)0.001);
        Assertions.assertEquals((double)2.4000000000000004, (double)OSMValueExtractor.stringToMeter((String)"~3"), (double)0.001);
        Assertions.assertEquals((double)2.4000000000000004, (double)OSMValueExtractor.stringToMeter((String)"3 m approx"), (double)0.001);
        Assertions.assertEquals((double)2.921, (double)OSMValueExtractor.stringToMeter((String)"9 ft 7in"), (double)0.001);
        Assertions.assertEquals((double)2.921, (double)OSMValueExtractor.stringToMeter((String)"9'7\""), (double)0.001);
        Assertions.assertEquals((double)2.921, (double)OSMValueExtractor.stringToMeter((String)"9'7''"), (double)0.001);
        Assertions.assertEquals((double)2.921, (double)OSMValueExtractor.stringToMeter((String)"9' 7\""), (double)0.001);
        Assertions.assertEquals((double)2.743, (double)OSMValueExtractor.stringToMeter((String)"9'"), (double)0.001);
        Assertions.assertEquals((double)2.743, (double)OSMValueExtractor.stringToMeter((String)"9 feet"), (double)0.001);
        Assertions.assertEquals((double)1.5, (double)OSMValueExtractor.stringToMeter((String)"150 cm"), (double)0.001);
    }

    @Test
    public void stringToMeterNaN() {
        Assertions.assertTrue((boolean)Double.isNaN(OSMValueExtractor.stringToMeter((String)"height limit 1.5m")));
    }

    @Test
    public void stringToMeterNaN2() {
        Assertions.assertTrue((boolean)Double.isNaN(OSMValueExtractor.stringToMeter((String)"")));
    }

    @Test
    public void stringToMeterNaN3() {
        Assertions.assertTrue((boolean)Double.isNaN(OSMValueExtractor.stringToMeter((String)"default")));
    }

    @Test
    public void testConditionalWeightToTons() {
        Assertions.assertEquals((double)7.5, (double)OSMValueExtractor.conditionalWeightToTons((String)"no @ (weight>7.5)"));
        Assertions.assertEquals((double)7.5, (double)OSMValueExtractor.conditionalWeightToTons((String)"delivery @ (Mo-Sa 06:00-12:00); no @ (weight>7.5); no @ (length>12)"));
    }
}

