/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractBikeTagParserTester;
import com.graphhopper.routing.util.parsers.BikeCommonAccessParser;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikeCommonPriorityParser;
import com.graphhopper.routing.util.parsers.RacingBikeAccessParser;
import com.graphhopper.routing.util.parsers.RacingBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.RacingBikePriorityParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RacingBikeTagParserTest
extends AbstractBikeTagParserTester {
    @Override
    protected EncodingManager createEncodingManager() {
        return new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"racingbike")).add((EncodedValue)VehicleSpeed.create((String)"racingbike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"racingbike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)Roundabout.create()).add((EncodedValue)Smoothness.create()).add((EncodedValue)FerrySpeed.create()).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)RouteNetwork.create((String)MtbNetwork.KEY)).build();
    }

    @Override
    protected BikeCommonAccessParser createAccessParser(EncodedValueLookup lookup, PMap pMap) {
        return new RacingBikeAccessParser(lookup, pMap);
    }

    @Override
    protected BikeCommonAverageSpeedParser createAverageSpeedParser(EncodedValueLookup lookup) {
        return new RacingBikeAverageSpeedParser(lookup);
    }

    @Override
    protected BikeCommonPriorityParser createPriorityParser(EncodedValueLookup lookup) {
        return new RacingBikePriorityParser(lookup);
    }

    @Override
    @Test
    public void testAvoidTunnel() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"residential");
        osmWay.setTag("tunnel", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 18.0, osmWay);
        osmWay.setTag("highway", (Object)"secondary");
        osmWay.setTag("tunnel", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 20.0, osmWay);
        osmWay.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 20.0, osmWay);
    }

    @Override
    @Test
    public void testService() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"service");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 12.0, way);
        way.setTag("service", (Object)"parking_aisle");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
    }

    @Test
    public void testTrack() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"designated");
        way.setTag("segregated", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 2.0, way);
        way.setTag("surface", (Object)"asphalt");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 20.0, way);
        way.setTag("tracktype", (Object)"grade1");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 20.0, way);
    }

    @Test
    public void testGetSpeed() {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.avgSpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 10.0);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade3");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.1);
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"steps");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        Assertions.assertEquals((double)20.0, (double)this.getSpeedFromFlags(way), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"paved");
        Assertions.assertEquals((double)20.0, (double)this.getSpeedFromFlags(way), (double)0.1);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"unknownpavement");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.1);
    }

    @Test
    public void testSmoothness() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        Assertions.assertEquals((double)18.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"excellent");
        Assertions.assertEquals((double)22.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"unknown");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("surface", (Object)"ground");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade5");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
    }

    @Test
    public void testHandleWayTagsInfluencedByRelation() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"track");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(osmWay), (double)0.1);
        ReaderRelation osmRel = new ReaderRelation(1L);
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 2.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"icn");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 2.0, osmWay, osmRel);
        osmWay.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 2.0, osmWay, osmRel);
        osmWay.setTag("tracktype", (Object)"grade1");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 20.0, osmWay, osmRel);
        osmWay.setTag("tracktype", (Object)"grade2");
        osmWay.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 10.0, osmWay, osmRel);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"track");
        osmWay.setTag("tracktype", (Object)"grade3");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 4.0, osmWay);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 2.0, osmWay);
    }

    @Test
    public void testPriority_avoidanceOfHighMaxSpeed() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"racingbike");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"racingbike", (int)4, (double)2.0, (boolean)false);
        DecimalEncodedValue priorityEnc = VehiclePriority.create((String)"racingbike", (int)4, (double)PriorityCode.getValue((int)1), (boolean)false);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)priorityEnc).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)Smoothness.create()).add((EncodedValue)FerrySpeed.create()).build();
        List<TagParser> parsers = Arrays.asList(new RacingBikeAverageSpeedParser((EncodedValueLookup)encodingManager), new RacingBikePriorityParser((EncodedValueLookup)encodingManager));
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"tertiary");
        osmWay.setTag("maxspeed", (Object)"50");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.PREFER, 20.0, osmWay);
        osmWay.setTag("maxspeed", (Object)"60");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.PREFER, 20.0, osmWay);
        osmWay.setTag("maxspeed", (Object)"80");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.PREFER, 20.0, osmWay);
        osmWay.setTag("maxspeed", (Object)"90");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.UNCHANGED, 20.0, osmWay);
        osmWay.setTag("maxspeed", (Object)"120");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.UNCHANGED, 20.0, osmWay);
        osmWay.setTag("highway", (Object)"motorway");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.BAD, 18.0, osmWay);
        osmWay.setTag("tunnel", (Object)"yes");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.REACH_DESTINATION, 18.0, osmWay);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"motorway");
        osmWay.setTag("tunnel", (Object)"yes");
        osmWay.setTag("maxspeed", (Object)"80");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.REACH_DESTINATION, 18.0, osmWay);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"motorway");
        osmWay.setTag("tunnel", (Object)"yes");
        osmWay.setTag("maxspeed", (Object)"120");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.REACH_DESTINATION, 18.0, osmWay);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"notdefined");
        osmWay.setTag("tunnel", (Object)"yes");
        osmWay.setTag("maxspeed", (Object)"120");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.BAD, 4.0, osmWay);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"notdefined");
        osmWay.setTag("maxspeed", (Object)"50");
        this.assertPriorityAndSpeed(encodingManager, priorityEnc, speedEnc, parsers, PriorityCode.UNCHANGED, 4.0, osmWay);
    }

    private void assertPriorityAndSpeed(EncodingManager encodingManager, DecimalEncodedValue priorityEnc, DecimalEncodedValue speedEnc, List<TagParser> parsers, PriorityCode expectedPrio, double expectedSpeed, ReaderWay way) {
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)encodingManager.getBytesForFlags());
        int edgeId = 0;
        for (TagParser p : parsers) {
            p.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, null);
        }
        Assertions.assertEquals((double)PriorityCode.getValue((int)expectedPrio.getValue()), (double)priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.01);
        Assertions.assertEquals((double)expectedSpeed, (double)speedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testClassBicycle() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"tertiary");
        way.setTag("class:bicycle:roadcycling", (Object)"3");
        this.assertPriority(PriorityCode.BEST, way);
        way.setTag("class:bicycle", (Object)"-2");
        this.assertPriority(PriorityCode.BEST, way);
    }

    @Test
    public void testPreferenceForSlowSpeed() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"tertiary");
        this.assertPriority(PriorityCode.PREFER, osmWay);
    }
}

