/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.parsers.RestrictionSetter;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RestrictionSetterTest {
    private DecimalEncodedValue speedEnc;
    private BooleanEncodedValue turnRestrictionEnc;
    private BooleanEncodedValue turnRestrictionEnc2;
    private BaseGraph graph;
    private RestrictionSetter r;

    @BeforeEach
    void setup() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnRestrictionEnc = TurnRestriction.create((String)"car1");
        this.turnRestrictionEnc2 = TurnRestriction.create((String)"car2");
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).add((EncodedValue)this.turnRestrictionEnc).add((EncodedValue)this.turnRestrictionEnc2).build();
        this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        this.r = new RestrictionSetter(this.graph, List.of(this.turnRestrictionEnc, this.turnRestrictionEnc2));
    }

    @Test
    void viaNode_no() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        this.edge(1, 3);
        this.edge(2, 4);
        this.edge(3, 4);
        this.setRestrictions(RestrictionSetter.createViaNodeRestriction((int)a, (int)1, (int)b));
        this.assertPath(0, 2, this.nodes(0, 1, 3, 4, 2));
    }

    @Test
    void viaEdge_no() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        this.edge(2, 4);
        this.edge(1, 5);
        this.edge(5, 8);
        this.edge(2, 6);
        this.edge(6, 9);
        this.edge(8, 9);
        this.setRestrictions(this.createViaEdgeRestriction(a, b, c));
        this.assertPath(0, 3, this.nodes(0, 1, 5, 8, 9, 6, 2, 3));
        this.assertPath(0, 4, this.nodes(0, 1, 2, 4));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
    }

    @Test
    void viaEdge_withOverlap() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        int d = this.edge(3, 4);
        int s = this.edge(1, 5);
        int t = this.edge(2, 6);
        int u = this.edge(3, 7);
        this.setRestrictions(this.createViaEdgeRestriction(a, b, c), this.createViaEdgeRestriction(b, c, d));
        this.assertPath(0, 3, null);
        this.assertPath(0, 6, this.nodes(0, 1, 2, 6));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 6, this.nodes(5, 1, 2, 6));
        this.assertPath(1, 4, null);
        this.assertPath(1, 7, this.nodes(1, 2, 3, 7));
        this.assertPath(6, 4, this.nodes(6, 2, 3, 4));
        this.assertPath(6, 7, this.nodes(6, 2, 3, 7));
    }

    @Test
    void viaEdge_no_withOverlap_more_complex() {
        int s = this.edge(0, 3);
        this.edge(1, 4);
        this.edge(2, 3);
        int a = this.edge(3, 4);
        int t = this.edge(4, 5);
        int b = this.edge(3, 7);
        int d = this.edge(4, 8);
        this.edge(6, 7);
        int c = this.edge(7, 8);
        this.edge(8, 9);
        this.edge(7, 10);
        this.edge(8, 11);
        this.edge(10, 11);
        this.setRestrictions(this.createViaNodeRestriction(t, 4, d), this.createViaNodeRestriction(s, 3, a), this.createViaEdgeRestriction(a, b, c), this.createViaEdgeRestriction(b, c, d), this.createViaEdgeRestriction(c, d, a), this.createViaEdgeRestriction(d, a, b));
        this.assertPath(0, 9, this.nodes(0, 3, 7, 8, 9));
        this.assertPath(5, 9, this.nodes(5, 4, 3, 7, 10, 11, 8, 9));
        this.assertPath(5, 2, this.nodes(5, 4, 3, 2));
        this.assertPath(0, 10, this.nodes(0, 3, 7, 10));
        this.assertPath(6, 9, this.nodes(6, 7, 8, 9));
    }

    @Test
    void common_via_edge_opposite_direction() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(1, 4);
        int d = this.edge(3, 4);
        int e = this.edge(4, 5);
        this.setRestrictions(this.createViaEdgeRestriction(b, c, e), this.createViaEdgeRestriction(d, c, a));
        this.assertPath(0, 2, this.nodes(0, 1, 2));
        this.assertPath(0, 5, this.nodes(0, 1, 4, 5));
        this.assertPath(0, 3, this.nodes(0, 1, 4, 3));
        this.assertPath(2, 0, this.nodes(2, 1, 0));
        this.assertPath(2, 3, this.nodes(2, 1, 4, 3));
        this.assertPath(2, 5, null);
        this.assertPath(3, 0, null);
        this.assertPath(3, 2, this.nodes(3, 4, 1, 2));
        this.assertPath(3, 5, this.nodes(3, 4, 5));
        this.assertPath(5, 0, this.nodes(5, 4, 1, 0));
        this.assertPath(5, 2, this.nodes(5, 4, 1, 2));
        this.assertPath(5, 3, this.nodes(5, 4, 3));
    }

    @Test
    void viaEdge_common_via_edge_opposite_direction_edge0() {
        int v = this.edge(1, 2);
        int a = this.edge(0, 1);
        int b = this.edge(2, 3);
        this.setRestrictions(this.createViaEdgeRestriction(a, v, b), this.createViaEdgeRestriction(b, v, a));
        this.assertPath(0, 3, null);
        this.assertPath(1, 3, this.nodes(1, 2, 3));
        this.assertPath(3, 0, null);
        this.assertPath(2, 0, this.nodes(2, 1, 0));
    }

    @Test
    void common_via_edge_same_direction() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(1, 4);
        int d = this.edge(3, 4);
        int e = this.edge(4, 5);
        this.assertPath(0, 3, this.nodes(0, 1, 4, 3));
        this.assertPath(2, 5, this.nodes(2, 1, 4, 5));
        this.setRestrictions(this.createViaEdgeRestriction(a, c, d), this.createViaEdgeRestriction(b, c, e));
        this.assertPath(0, 3, null);
        this.assertPath(3, 0, this.nodes(3, 4, 1, 0));
        this.assertPath(2, 5, null);
        this.assertPath(5, 2, this.nodes(5, 4, 1, 2));
        this.assertPath(0, 2, this.nodes(0, 1, 2));
        this.assertPath(1, 3, this.nodes(1, 4, 3));
        this.assertPath(0, 5, this.nodes(0, 1, 4, 5));
        this.assertPath(2, 3, this.nodes(2, 1, 4, 3));
    }

    @Test
    void viaEdgeAndNode() {
        int e0_1 = this.edge(0, 1);
        int e0_4 = this.edge(0, 4);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        this.assertPath(0, 3, this.nodes(0, 1, 3));
        this.assertPath(4, 2, this.nodes(4, 0, 1, 2));
        this.setRestrictions(this.createViaEdgeRestriction(e0_4, e0_1, e1_2), this.createViaNodeRestriction(e0_1, 1, e1_3));
        this.assertPath(4, 2, null);
        this.assertPath(0, 3, null);
    }

    @Test
    void pTurn() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        int e3_4 = this.edge(3, 4);
        int e4_3 = this.edge(4, 3);
        this.setRestrictions(this.createViaNodeRestriction(e0_1, 1, e1_2), this.createViaEdgeRestriction(e1_3, e4_3, e3_4), this.createViaNodeRestriction(e4_3, 3, e3_4), this.createViaNodeRestriction(e3_4, 4, e4_3));
        this.assertPath(0, 2, null);
    }

    @Test
    void redundantRestriction_simple() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        this.setRestrictions(this.createViaNodeRestriction(e0_1, 1, e1_2), this.createViaNodeRestriction(e0_1, 1, e1_2));
        this.assertPath(0, 2, null);
    }

    @Test
    void multiViaEdge_no() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(1, 3);
        int d = this.edge(2, 4);
        int e = this.edge(3, 4);
        int f = this.edge(3, 6);
        int g = this.edge(5, 6);
        int h = this.edge(6, 7);
        this.setRestrictions(this.createViaEdgeRestriction(a, c, f, g));
        this.assertPath(0, 5, this.nodes(0, 1, 2, 4, 3, 6, 5));
        this.assertPath(1, 5, this.nodes(1, 3, 6, 5));
        this.assertPath(0, 7, this.nodes(0, 1, 3, 6, 7));
    }

    @Test
    void multiViaEdge_overlapping() {
        int a = this.edge(0, 1);
        int b = this.edge(1, 2);
        int c = this.edge(2, 3);
        int d = this.edge(3, 4);
        int e = this.edge(5, 1);
        int f = this.edge(6, 2);
        this.assertPath(5, 6, this.nodes(5, 1, 2, 6));
        this.assertPath(0, 4, this.nodes(0, 1, 2, 3, 4));
        this.setRestrictions(this.createViaEdgeRestriction(e, b, f), this.createViaEdgeRestriction(a, b, c, d));
        this.assertPath(5, 6, null);
        this.assertPath(0, 4, null);
        this.assertPath(0, 6, this.nodes(0, 1, 2, 6));
        this.assertPath(5, 4, this.nodes(5, 1, 2, 3, 4));
    }

    @Test
    void singleViaEdgeRestriction() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e2_4 = this.edge(2, 4);
        int e5_1 = this.edge(5, 1);
        this.assertPath(0, 3, this.nodes(0, 1, 2, 3));
        this.assertPath(0, 4, this.nodes(0, 1, 2, 4));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 4, this.nodes(5, 1, 2, 4));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_4));
        this.assertPath(0, 3, this.nodes(0, 1, 2, 3));
        this.assertPath(0, 4, null);
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 4, this.nodes(5, 1, 2, 4));
        Assertions.assertEquals((int)6, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void multiViaEdgeRestriction() {
        int e0_1 = this.edge(0, 1);
        int e1_6 = this.edge(1, 6);
        int e6_2 = this.edge(6, 2);
        int e2_3 = this.edge(2, 3);
        int e2_4 = this.edge(2, 4);
        int e5_1 = this.edge(5, 1);
        this.assertPath(0, 3, this.nodes(0, 1, 6, 2, 3));
        this.assertPath(0, 4, this.nodes(0, 1, 6, 2, 4));
        this.assertPath(5, 3, this.nodes(5, 1, 6, 2, 3));
        this.assertPath(5, 4, this.nodes(5, 1, 6, 2, 4));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_6, e6_2, e2_4));
        this.assertPath(0, 3, this.nodes(0, 1, 6, 2, 3));
        this.assertPath(0, 4, null);
        this.assertPath(5, 3, this.nodes(5, 1, 6, 2, 3));
        this.assertPath(5, 4, this.nodes(5, 1, 6, 2, 4));
        Assertions.assertEquals((int)11, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void overlappingSingleViaEdgeRestriction() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e2_4 = this.edge(2, 4);
        int e5_1 = this.edge(5, 1);
        int e2_7 = this.edge(2, 7);
        for (int i : new int[]{3, 4, 7}) {
            this.assertPath(0, i, this.nodes(0, 1, 2, i));
            this.assertPath(5, i, this.nodes(5, 1, 2, i));
        }
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_3), this.createViaEdgeRestriction(e0_1, e1_2, e2_4));
        this.assertPath(0, 3, null);
        this.assertPath(0, 4, null);
        this.assertPath(0, 7, this.nodes(0, 1, 2, 7));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 4, this.nodes(5, 1, 2, 4));
        this.assertPath(5, 7, this.nodes(5, 1, 2, 7));
        Assertions.assertEquals((int)7, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void overlappingSingleViaEdgeRestriction_differentStarts() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e5_1 = this.edge(5, 1);
        int e2_4 = this.edge(2, 4);
        int e2_7 = this.edge(2, 7);
        for (int i : new int[]{3, 4, 7}) {
            this.assertPath(0, i, this.nodes(0, 1, 2, i));
            this.assertPath(5, i, this.nodes(5, 1, 2, i));
        }
        this.assertPath(7, 4, this.nodes(7, 2, 4));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_3), this.createViaEdgeRestriction(e5_1, e1_2, e2_7), this.createViaEdgeRestriction(e0_1, e1_2, e2_4), this.createViaEdgeRestriction(e5_1, e1_2, e2_4));
        this.assertPath(0, 3, null);
        this.assertPath(0, 4, null);
        this.assertPath(0, 7, this.nodes(0, 1, 2, 7));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 4, null);
        this.assertPath(5, 7, null);
        this.assertPath(7, 4, this.nodes(7, 2, 4));
        Assertions.assertEquals((int)20, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void overlappingSingleViaEdgeRestriction_oppositeDirections() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e5_1 = this.edge(5, 1);
        int e2_7 = this.edge(2, 7);
        for (int i : new int[]{3, 7}) {
            this.assertPath(0, i, this.nodes(0, 1, 2, i));
            this.assertPath(5, i, this.nodes(5, 1, 2, i));
            this.assertPath(i, 0, this.nodes(i, 2, 1, 0));
            this.assertPath(i, 5, this.nodes(i, 2, 1, 5));
        }
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_3), this.createViaEdgeRestriction(e2_7, e1_2, e5_1));
        this.assertPath(0, 3, null);
        this.assertPath(0, 7, this.nodes(0, 1, 2, 7));
        this.assertPath(5, 3, this.nodes(5, 1, 2, 3));
        this.assertPath(5, 7, this.nodes(5, 1, 2, 7));
        this.assertPath(3, 0, this.nodes(3, 2, 1, 0));
        this.assertPath(3, 5, this.nodes(3, 2, 1, 5));
        this.assertPath(7, 0, this.nodes(7, 2, 1, 0));
        this.assertPath(7, 5, null);
        Assertions.assertEquals((int)18, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void viaNode() {
        int e0_1 = this.edge(0, 1);
        int e0_4 = this.edge(0, 4);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        this.assertPath(0, 3, this.nodes(0, 1, 3));
        this.assertPath(4, 2, this.nodes(4, 0, 1, 2));
        this.setRestrictions(this.createViaEdgeRestriction(e0_4, e0_1, e1_2), this.createViaNodeRestriction(e0_1, 1, e1_3));
        this.assertPath(4, 2, null);
        this.assertPath(0, 3, null);
        Assertions.assertEquals((int)8, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void circle() {
        int e4_1 = this.edge(4, 1, false);
        int e1_0 = this.edge(1, 0, false);
        int e0_2 = this.edge(0, 2, false);
        int e2_1 = this.edge(2, 1, false);
        int e2_3 = this.edge(2, 3, false);
        this.assertPath(4, 3, this.nodes(4, 1, 0, 2, 3));
        this.setRestrictions(this.createViaEdgeRestriction(e4_1, e1_0, e0_2, e2_3));
        this.assertPath(4, 3, this.nodes(4, 1, 0, 2, 1, 0, 2, 3));
        Assertions.assertEquals((int)11, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void avoidRedundantRestrictions() {
        this.edge(0, 1);
        this.edge(1, 2);
        this.edge(2, 3);
        this.edge(3, 4);
        this.edge(4, 5);
        this.edge(0, 6);
        this.edge(6, 7);
        this.edge(7, 8);
        this.edge(8, 9);
        this.edge(9, 10);
        this.edge(4, 9);
        this.edge(5, 10);
        this.setRestrictions(this.createViaEdgeRestriction(9, 8, 7), this.createViaEdgeRestriction(0, 1, 2, 3, 4, 11, 9, 8, 7, 6, 5), this.createViaEdgeRestriction(1, 2, 3, 4, 11, 9, 8, 7, 6, 5, 0), this.createViaEdgeRestriction(2, 3, 4, 11, 9, 8, 7, 6, 5, 0, 1), this.createViaEdgeRestriction(3, 4, 11, 9, 8, 7, 6, 5, 0, 1, 2), this.createViaEdgeRestriction(4, 11, 9, 8, 7, 6, 5, 0, 1, 2, 3));
        Assertions.assertEquals((int)6, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void duplicateRestrictions() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        this.assertPath(0, 2, this.nodes(0, 1, 2));
        this.setRestrictions(this.createViaNodeRestriction(e0_1, 1, e1_2), this.createViaNodeRestriction(e0_1, 1, e1_2));
        this.assertPath(0, 2, null);
        Assertions.assertEquals((int)1, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void duplicateViaEdgeRestrictions() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        this.assertPath(0, 3, this.nodes(0, 1, 2, 3));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_3), this.createViaEdgeRestriction(e0_1, e1_2, e2_3));
        this.assertPath(0, 3, null);
        Assertions.assertEquals((int)6, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void duplicateEdgesInViaEdgeRestriction() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        int e1_4 = this.edge(1, 4);
        this.setRestrictions(this.createViaNodeRestriction(e1_3, 1, e0_1), this.createViaEdgeRestriction(e1_2, e1_2, e0_1), this.createViaNodeRestriction(e1_3, 1, e1_4));
        this.assertPath(3, 0, null);
        Assertions.assertEquals((int)8, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void circleEdgesInViaEdgeRestriction() {
        int e0_1 = this.edge(0, 1);
        int e1_0 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e1_3 = this.edge(1, 3);
        int e1_4 = this.edge(1, 4);
        this.assertPath(3, 2, this.nodes(3, 1, 2));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_0, e1_2), this.createViaNodeRestriction(e1_3, 1, e1_2), this.createViaNodeRestriction(e1_3, 1, e1_0), this.createViaNodeRestriction(e1_4, 1, e1_2), this.createViaNodeRestriction(e1_4, 1, e0_1));
        this.assertPath(3, 2, null);
        this.assertPath(0, 2, this.nodes(0, 1, 2));
        this.assertPath(4, 2, this.nodes(4, 1, 0, 1, 2));
        Assertions.assertEquals((int)11, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void similarRestrictions() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e2_1 = this.edge(2, 1);
        int e2_3 = this.edge(2, 3);
        int e1_4 = this.edge(1, 4);
        this.assertPath(4, 0, this.nodes(4, 1, 0));
        this.setRestrictions(this.createViaNodeRestriction(e1_4, 1, e0_1), this.createViaNodeRestriction(e2_1, 2, e1_2), this.createViaNodeRestriction(e1_2, 2, e2_1), this.createViaNodeRestriction(e1_2, 1, e2_1));
        this.assertPath(4, 0, null);
        Assertions.assertEquals((int)4, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void similarRestrictions_with_artificial_edges() {
        int e0_1 = this.edge(0, 1);
        int e5_1 = this.edge(5, 1);
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e2_4 = this.edge(2, 4);
        this.setRestrictions(this.createViaNodeRestriction(e0_1, 1, e5_1), this.createViaEdgeRestriction(e0_1, e1_2, e2_4), this.createViaEdgeRestriction(e2_4, e1_2, e0_1), this.createViaNodeRestriction(e1_2, 2, e1_2), this.createViaNodeRestriction(e1_2, 1, e1_2));
        this.assertPath(0, 5, null);
        Assertions.assertEquals((int)25, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void restrictTurnsBetweenArtificialEdges() {
        int e3_1 = this.edge(3, 1, false);
        int e0_1 = this.edge(0, 1, false);
        int e1_2 = this.edge(1, 2);
        int e2_4 = this.edge(2, 4, false);
        int e1_5 = this.edge(1, 5);
        int e8_2 = this.edge(8, 2, false);
        this.assertPath(3, 4, this.nodes(3, 1, 2, 4));
        this.assertPath(0, 4, this.nodes(0, 1, 2, 4));
        this.assertPath(5, 4, this.nodes(5, 1, 2, 4));
        this.setRestrictions(this.createViaEdgeRestriction(e0_1, e1_2, e2_4), this.createViaEdgeRestriction(e3_1, e1_2, e2_4), this.createViaEdgeRestriction(e8_2, e1_2, e1_5));
        this.assertPath(3, 4, null);
        this.assertPath(0, 4, null);
        this.assertPath(5, 4, this.nodes(5, 1, 2, 4));
    }

    @Test
    void twoProfiles() {
        int e0_1 = this.edge(0, 1);
        int e1_2 = this.edge(1, 2);
        int e3_4 = this.edge(3, 4);
        int e4_5 = this.edge(4, 5);
        int e1_4 = this.edge(1, 4);
        for (BooleanEncodedValue t : List.of(this.turnRestrictionEnc, this.turnRestrictionEnc2)) {
            this.assertPath(2, 5, t, this.nodes(2, 1, 4, 5));
            this.assertPath(3, 0, t, this.nodes(3, 4, 1, 0));
        }
        List<RestrictionSetter.Restriction> restrictions = List.of(this.createViaEdgeRestriction(e1_2, e1_4, e4_5), this.createViaEdgeRestriction(e3_4, e1_4, e0_1));
        List<BitSet> encBits = List.of(this.encBits(1, 1), this.encBits(1, 1));
        this.setRestrictions(restrictions, encBits);
        for (BooleanEncodedValue t : List.of(this.turnRestrictionEnc, this.turnRestrictionEnc2)) {
            this.assertPath(2, 5, t, null);
            this.assertPath(3, 0, t, null);
        }
    }

    @Test
    void artificialEdgeSnapping() {
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e3_4 = this.edge(3, 4);
        int e0_3 = this.edge(0, 3);
        int e2_5 = this.edge(2, 5);
        int e2_6 = this.edge(2, 6);
        int e3_7 = this.edge(3, 7);
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 40.03, 5.03);
        na.setNode(1, 40.02, 5.01);
        na.setNode(2, 40.02, 5.02);
        na.setNode(3, 40.02, 5.03);
        na.setNode(4, 40.02, 5.04);
        na.setNode(5, 40.01, 5.02);
        na.setNode(6, 40.03, 5.02);
        na.setNode(7, 40.01, 5.03);
        this.assertPath(1, 0, this.nodes(1, 2, 3, 0));
        this.assertPath(1, 4, this.nodes(1, 2, 3, 4));
        this.assertPath(5, 0, this.nodes(5, 2, 3, 0));
        this.assertPath(6, 3, this.nodes(6, 2, 3));
        this.assertPath(2, 7, this.nodes(2, 3, 7));
        this.setRestrictions(this.createViaEdgeRestriction(e1_2, e2_3, e0_3), this.createViaNodeRestriction(e2_6, 2, e2_3), this.createViaNodeRestriction(e2_3, 3, e3_7));
        this.assertPath(1, 0, null);
        this.assertPath(1, 4, this.nodes(1, 2, 3, 4));
        this.assertPath(5, 0, this.nodes(5, 2, 3, 0));
        this.assertPath(6, 3, null);
        this.assertPath(2, 7, null);
        LocationIndex locationIndex = new LocationIndexTree((Graph)this.graph, this.graph.getDirectory()).prepareIndex();
        Snap snap = locationIndex.findClosest(40.02, 5.025, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        int x = 8;
        this.assertPath((Graph)queryGraph, 1, 0, this.nodes(1, 2, 8, 3, 0));
        this.assertPath((Graph)queryGraph, 1, 4, this.nodes(1, 2, 3, 4));
        this.assertPath((Graph)queryGraph, 1, 8, this.nodes(1, 2, 8));
        this.assertPath((Graph)queryGraph, 5, 8, this.nodes(5, 2, 8));
        this.assertPath((Graph)queryGraph, 8, 0, this.nodes(8, 3, 0));
        this.assertPath((Graph)queryGraph, 8, 4, this.nodes(8, 3, 4));
        this.assertPath((Graph)queryGraph, 6, 3, null);
        this.assertPath((Graph)queryGraph, 2, 7, null);
        Assertions.assertEquals((int)10, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    @Test
    void artificialEdgeSnapping_twoVirtualNodes() {
        int e1_2 = this.edge(1, 2);
        int e2_3 = this.edge(2, 3);
        int e3_4 = this.edge(3, 4);
        int e4_5 = this.edge(4, 5);
        int e5_6 = this.edge(5, 6);
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(1, 40.02, 5.01);
        na.setNode(2, 40.02, 5.02);
        na.setNode(3, 40.02, 5.03);
        na.setNode(4, 40.02, 5.04);
        na.setNode(5, 40.02, 5.05);
        na.setNode(6, 40.02, 5.06);
        this.assertPath(1, 4, this.nodes(1, 2, 3, 4));
        this.assertPath(2, 4, this.nodes(2, 3, 4));
        this.assertPath(2, 5, this.nodes(2, 3, 4, 5));
        this.assertPath(3, 5, this.nodes(3, 4, 5));
        this.assertPath(3, 6, this.nodes(3, 4, 5, 6));
        this.assertPath(4, 6, this.nodes(4, 5, 6));
        this.setRestrictions(this.createViaEdgeRestriction(e1_2, e2_3, e3_4), this.createViaEdgeRestriction(e2_3, e3_4, e4_5), this.createViaEdgeRestriction(e3_4, e4_5, e5_6));
        this.assertPath(1, 4, null);
        this.assertPath(2, 4, this.nodes(2, 3, 4));
        this.assertPath(2, 5, null);
        this.assertPath(3, 5, this.nodes(3, 4, 5));
        this.assertPath(3, 6, null);
        this.assertPath(4, 6, this.nodes(4, 5, 6));
        LocationIndex locationIndex = new LocationIndexTree((Graph)this.graph, this.graph.getDirectory()).prepareIndex();
        Snap snapX = locationIndex.findClosest(40.02, 5.025, EdgeFilter.ALL_EDGES);
        Snap snapY = locationIndex.findClosest(40.02, 5.035, EdgeFilter.ALL_EDGES);
        Snap snapZ = locationIndex.findClosest(40.02, 5.045, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, List.of(snapX, snapY, snapZ));
        int x = 8;
        int y = 7;
        int z = 9;
        Assertions.assertEquals((int)8, (int)snapX.getClosestNode());
        Assertions.assertEquals((int)7, (int)snapY.getClosestNode());
        Assertions.assertEquals((int)9, (int)snapZ.getClosestNode());
        this.assertPath((Graph)queryGraph, 1, 4, this.nodes(1, 2, 8, 3, 4));
        this.assertPath((Graph)queryGraph, 2, 4, this.nodes(2, 8, 3, 4));
        this.assertPath((Graph)queryGraph, 2, 5, this.nodes(2, 8, 3, 7, 4, 5));
        this.assertPath((Graph)queryGraph, 3, 5, this.nodes(3, 7, 4, 5));
        this.assertPath((Graph)queryGraph, 3, 6, this.nodes(3, 7, 4, 9, 5, 6));
        this.assertPath((Graph)queryGraph, 4, 6, this.nodes(4, 9, 5, 6));
        this.assertPath((Graph)queryGraph, 8, 7, this.nodes(8, 3, 7));
        this.assertPath((Graph)queryGraph, 7, 8, this.nodes(7, 3, 8));
        this.assertPath((Graph)queryGraph, 7, 9, this.nodes(7, 4, 9));
        this.assertPath((Graph)queryGraph, 9, 7, this.nodes(9, 4, 7));
        Assertions.assertEquals((int)20, (int)this.graph.getTurnCostStorage().getTurnCostsCount());
    }

    private RestrictionSetter.Restriction createViaNodeRestriction(int fromEdge, int viaNode, int toEdge) {
        return RestrictionSetter.createViaNodeRestriction((int)fromEdge, (int)viaNode, (int)toEdge);
    }

    private RestrictionSetter.Restriction createViaEdgeRestriction(int ... edges) {
        return RestrictionSetter.createViaEdgeRestriction((IntArrayList)IntArrayList.from((int[])edges));
    }

    private void setRestrictions(RestrictionSetter.Restriction ... restrictions) {
        this.setRestrictions(List.of(restrictions), Stream.of(restrictions).map(r -> this.encBits(1, 0)).toList());
    }

    private void setRestrictions(List<RestrictionSetter.Restriction> restrictions, List<BitSet> encBits) {
        this.r.setRestrictions(restrictions, encBits);
    }

    private void assertPath(int from, int to, IntArrayList expectedNodes) {
        this.assertPath((Graph)this.graph, from, to, this.turnRestrictionEnc, expectedNodes);
    }

    private void assertPath(int from, int to, BooleanEncodedValue turnRestrictionEnc, IntArrayList expectedNodes) {
        this.assertPath((Graph)this.graph, from, to, turnRestrictionEnc, expectedNodes);
    }

    private void assertPath(Graph graph, int from, int to, IntArrayList expectedNodes) {
        this.assertPath(graph, from, to, this.turnRestrictionEnc, expectedNodes);
    }

    private void assertPath(Graph graph, int from, int to, BooleanEncodedValue turnRestrictionEnc, IntArrayList expectedNodes) {
        Path path = this.calcPath(graph, from, to, turnRestrictionEnc);
        if (expectedNodes == null) {
            Assertions.assertFalse((boolean)path.isFound(), (String)("Did not expect to find a path, but found: " + String.valueOf(path.calcNodes()) + ", edges: " + String.valueOf(path.calcEdges())));
        } else {
            Assertions.assertTrue((boolean)path.isFound(), (String)("Expected path: " + String.valueOf(expectedNodes) + ", but did not find it"));
            IntIndexedContainer nodes = path.calcNodes();
            Assertions.assertEquals((Object)expectedNodes, (Object)nodes);
        }
    }

    private Path calcPath(final Graph graph, int from, int to, final BooleanEncodedValue turnRestrictionEnc) {
        Dijkstra dijkstra = new Dijkstra(graph, graph.wrapWeighting((Weighting)new SpeedWeighting(this.speedEnc, new TurnCostProvider(){

            public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
                if (inEdge == outEdge) {
                    return Double.POSITIVE_INFINITY;
                }
                return graph.getTurnCostStorage().get(turnRestrictionEnc, inEdge, viaNode, outEdge) ? Double.POSITIVE_INFINITY : 0.0;
            }

            public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
                return Double.isInfinite(this.calcTurnWeight(inEdge, viaNode, outEdge)) ? Long.MAX_VALUE : 0L;
            }
        })), TraversalMode.EDGE_BASED);
        return dijkstra.calcPath(from, to);
    }

    private IntArrayList nodes(int ... nodes) {
        return IntArrayList.from((int[])nodes);
    }

    private BitSet encBits(int ... bits) {
        BitSet b = new BitSet((long)bits.length);
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i] != 0 && bits[i] != 1) {
                throw new IllegalArgumentException("bits must be 0 or 1");
            }
            if (bits[i] <= 0) continue;
            b.set((long)i);
        }
        return b;
    }

    private int edge(int from, int to) {
        return this.edge(from, to, true);
    }

    private int edge(int from, int to, boolean bothDir) {
        return this.graph.edge(from, to).setDistance(100.0).set(this.speedEnc, 10.0, bothDir ? 10.0 : 0.0).getEdge();
    }
}

