/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.BikePriorityParser;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikePriorityParser;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TagParsingTest {
    TagParsingTest() {
    }

    @Test
    public void testCombineRelations() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"track");
        ReaderRelation osmRel = new ReaderRelation(1L);
        BooleanEncodedValue bike1AccessEnc = VehicleAccess.create((String)"bike1");
        DecimalEncodedValue bike1SpeedEnc = VehicleSpeed.create((String)"bike1", (int)4, (double)2.0, (boolean)false);
        DecimalEncodedValue bike1PriorityEnc = VehiclePriority.create((String)"bike1", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false);
        BooleanEncodedValue bike2AccessEnc = VehicleAccess.create((String)"bike2");
        DecimalEncodedValue bike2SpeedEnc = VehicleSpeed.create((String)"bike2", (int)4, (double)2.0, (boolean)false);
        DecimalEncodedValue bike2PriorityEnc = VehiclePriority.create((String)"bike2", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false);
        EnumEncodedValue bikeNetworkEnc = RouteNetwork.create((String)BikeNetwork.KEY);
        EncodingManager em = EncodingManager.start().add((EncodedValue)bike1AccessEnc).add((EncodedValue)bike1SpeedEnc).add((EncodedValue)bike1PriorityEnc).add((EncodedValue)bike2AccessEnc).add((EncodedValue)bike2SpeedEnc).add((EncodedValue)bike2PriorityEnc).add((EncodedValue)bikeNetworkEnc).add((EncodedValue)Smoothness.create()).add((EncodedValue)RoadClass.create()).build();
        BikePriorityParser bike1Parser = new BikePriorityParser(bike1PriorityEnc, bike1SpeedEnc, bikeNetworkEnc);
        BikePriorityParser bike2Parser = new BikePriorityParser(bike2PriorityEnc, bike2SpeedEnc, bikeNetworkEnc){

            public void handleWayTags(int edgeId, EdgeIntAccess intAccess, ReaderWay way, IntsRef relTags) {
                if (this.bikeRouteEnc.getEnum(false, edgeId, intAccess) != RouteNetwork.MISSING) {
                    this.priorityEnc.setDecimal(false, edgeId, intAccess, PriorityCode.getFactor((int)2));
                }
            }
        };
        OSMParsers osmParsers = new OSMParsers().addRelationTagParser(relConfig -> new OSMBikeNetworkTagParser(bikeNetworkEnc, relConfig)).addWayTagParser((TagParser)new OSMRoadClassParser(em.getEnumEncodedValue("road_class", RoadClass.class))).addWayTagParser((TagParser)bike1Parser).addWayTagParser((TagParser)bike2Parser);
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        IntsRef relFlags = osmParsers.createRelationFlags();
        relFlags = osmParsers.handleRelationTags(osmRel, relFlags);
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)em.getBytesForFlags());
        int edgeId = 0;
        osmParsers.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, osmWay, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)bikeNetworkEnc.getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((bike1PriorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess) > bike2PriorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess) ? 1 : 0) != 0);
    }

    @Test
    public void testMixBikeTypesAndRelationCombination() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"track");
        osmWay.setTag("tracktype", (Object)"grade1");
        ReaderRelation osmRel = new ReaderRelation(1L);
        BooleanEncodedValue bikeAccessEnc = VehicleAccess.create((String)"bike");
        DecimalEncodedValue bikeSpeedEnc = VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false);
        DecimalEncodedValue bikePriorityEnc = VehiclePriority.create((String)"bike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false);
        BooleanEncodedValue mtbAccessEnc = VehicleAccess.create((String)"mtb");
        DecimalEncodedValue mtbSpeedEnc = VehicleSpeed.create((String)"mtb", (int)4, (double)2.0, (boolean)false);
        DecimalEncodedValue mtbPriorityEnc = VehiclePriority.create((String)"mtb", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false);
        EnumEncodedValue bikeNetworkEnc = RouteNetwork.create((String)BikeNetwork.KEY);
        EncodingManager em = EncodingManager.start().add((EncodedValue)bikeAccessEnc).add((EncodedValue)bikeSpeedEnc).add((EncodedValue)bikePriorityEnc).add((EncodedValue)mtbAccessEnc).add((EncodedValue)mtbSpeedEnc).add((EncodedValue)mtbPriorityEnc).add((EncodedValue)bikeNetworkEnc).add((EncodedValue)Smoothness.create()).add((EncodedValue)RoadClass.create()).build();
        BikePriorityParser bikeTagParser = new BikePriorityParser((EncodedValueLookup)em);
        MountainBikePriorityParser mtbTagParser = new MountainBikePriorityParser((EncodedValueLookup)em);
        OSMParsers osmParsers = new OSMParsers().addRelationTagParser(relConfig -> new OSMBikeNetworkTagParser(bikeNetworkEnc, relConfig)).addWayTagParser((TagParser)new OSMRoadClassParser(em.getEnumEncodedValue("road_class", RoadClass.class))).addWayTagParser((TagParser)bikeTagParser).addWayTagParser((TagParser)mtbTagParser);
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"rcn");
        IntsRef relFlags = osmParsers.createRelationFlags();
        relFlags = osmParsers.handleRelationTags(osmRel, relFlags);
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)em.getBytesForFlags());
        int edgeId = 0;
        osmParsers.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, osmWay, relFlags);
        Assertions.assertTrue((bikePriorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess) > mtbPriorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess) ? 1 : 0) != 0);
    }

    @Test
    public void testSharedEncodedValues() {
        BooleanEncodedValue carAccessEnc = VehicleAccess.create((String)"car");
        BooleanEncodedValue footAccessEnc = VehicleAccess.create((String)"foot");
        BooleanEncodedValue bikeAccessEnc = VehicleAccess.create((String)"bike");
        BooleanEncodedValue mtbAccessEnc = VehicleAccess.create((String)"mtb");
        List<BooleanEncodedValue> accessEncs = Arrays.asList(carAccessEnc, footAccessEnc, bikeAccessEnc, mtbAccessEnc);
        EncodingManager manager = EncodingManager.start().add((EncodedValue)carAccessEnc).add((EncodedValue)VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)true)).add((EncodedValue)footAccessEnc).add((EncodedValue)VehicleSpeed.create((String)"foot", (int)4, (double)1.0, (boolean)true)).add((EncodedValue)VehiclePriority.create((String)"foot", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)bikeAccessEnc).add((EncodedValue)VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"bike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)mtbAccessEnc).add((EncodedValue)VehicleSpeed.create((String)"mtb", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"mtb", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)RouteNetwork.create((String)FootNetwork.KEY)).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)Roundabout.create()).add((EncodedValue)Smoothness.create()).build();
        BooleanEncodedValue roundaboutEnc = manager.getBooleanEncodedValue("roundabout");
        List<TagParser> tagParsers = Arrays.asList(new OSMRoundaboutParser(roundaboutEnc), new CarAccessParser((EncodedValueLookup)manager, new PMap()), new FootAccessParser((EncodedValueLookup)manager, new PMap()), new BikeAccessParser((EncodedValueLookup)manager, new PMap()), new MountainBikeAccessParser((EncodedValueLookup)manager, new PMap()));
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)manager.getBytesForFlags());
        int edgeId = 0;
        IntsRef relFlags = manager.createRelationFlags();
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("junction", (Object)"roundabout");
        tagParsers.forEach(p -> p.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags));
        Assertions.assertTrue((boolean)roundaboutEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        for (BooleanEncodedValue accessEnc : accessEncs) {
            Assertions.assertTrue((boolean)accessEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        }
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("junction", (Object)"circular");
        tagParsers.forEach(p -> p.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags));
        Assertions.assertTrue((boolean)roundaboutEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        for (BooleanEncodedValue accessEnc : accessEncs) {
            Assertions.assertTrue((boolean)accessEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        }
    }
}

