/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.custom.ClassHelper;
import com.graphhopper.routing.weighting.custom.ConditionalExpressionVisitor;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import com.graphhopper.util.Helper;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConditionalExpressionVisitorTest {
    @BeforeEach
    public void before() {
        StringEncodedValue sev = new StringEncodedValue("country", 10);
        new EncodingManager.Builder().add((EncodedValue)sev).build();
        sev.setString(false, 0, (EdgeIntAccess)new ArrayEdgeIntAccess(1), "DEU");
    }

    @Test
    public void protectUsFromStuff() {
        NameValidator allNamesInvalid = s -> false;
        for (String toParse : Arrays.asList("", "new Object()", "java.lang.Object", "Test.class", "new Object(){}.toString().length", "{ 5}", "{ 5, 7 }", "Object.class", "System.out.println(\"\")", "something.newInstance()", "e.getClass ( )", "edge.getDistance()*7/*test", "edge.getDistance()//*test", "edge . getClass()", "(edge = edge) == edge", ") edge (", "in(area_blup(), edge)", "s -> truevalue")) {
            ParseResult res = ConditionalExpressionVisitor.parse((String)toParse, (NameValidator)allNamesInvalid, k -> "");
            Assertions.assertFalse((boolean)res.ok, (String)("should not be simple condition: " + toParse));
            Assertions.assertTrue((res.guessedVariables == null || res.guessedVariables.isEmpty() ? 1 : 0) != 0);
        }
        Assertions.assertFalse((boolean)ConditionalExpressionVisitor.parse((String)"edge; getClass()", (NameValidator)allNamesInvalid, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$protectUsFromStuff$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).ok);
    }

    @Test
    public void testConvertExpression() {
        NameValidator validVariable = s -> Helper.toUpperCase((String)s).equals(s) || s.equals("road_class") || s.equals("toll");
        ParseResult result = ConditionalExpressionVisitor.parse((String)"toll == NO", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[toll]", (Object)result.guessedVariables.toString());
        Assertions.assertEquals((Object)"road_class == Hello.PRIMARY", (Object)ConditionalExpressionVisitor.parse((String)"road_class == PRIMARY", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$testConvertExpression$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).converted.toString());
        Assertions.assertEquals((Object)"toll == Toll.NO", (Object)ConditionalExpressionVisitor.parse((String)"toll == NO", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$testConvertExpression$6(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).converted.toString());
        Assertions.assertEquals((Object)"toll == Toll.NO || road_class == RoadClass.NO", (Object)ConditionalExpressionVisitor.parse((String)"toll == NO || road_class == NO", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$testConvertExpression$7(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).converted.toString());
        Assertions.assertEquals((Object)(CustomWeightingHelper.class.getSimpleName() + ".in(this.in_custom_1, edge)"), (Object)ConditionalExpressionVisitor.parse((String)"in_custom_1", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$testConvertExpression$8(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).converted.toString());
        Assertions.assertNull((Object)ConditionalExpressionVisitor.parse((String)"toll == Toll.NO", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$testConvertExpression$9(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).converted);
    }

    @Test
    public void isValidAndSimpleCondition() {
        NameValidator validVariable = s -> Helper.toUpperCase((String)s).equals(s) || s.equals("road_class") || s.equals("toll") || s.equals("my_speed") || s.equals("backward_my_speed");
        ParseResult result = ConditionalExpressionVisitor.parse((String)"in_something", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[in_something]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"edge == edge", (NameValidator)validVariable, k -> "");
        Assertions.assertFalse((boolean)result.ok);
        result = ConditionalExpressionVisitor.parse((String)"Math.sqrt(my_speed)", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[my_speed]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"Math.sqrt(2)", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertTrue((boolean)result.guessedVariables.isEmpty());
        result = ConditionalExpressionVisitor.parse((String)"edge.blup()", (NameValidator)validVariable, k -> "");
        Assertions.assertFalse((boolean)result.ok);
        Assertions.assertTrue((boolean)result.guessedVariables.isEmpty());
        result = ConditionalExpressionVisitor.parse((String)"edge.getDistance()", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[edge]", (Object)result.guessedVariables.toString());
        Assertions.assertFalse((boolean)ConditionalExpressionVisitor.parse((String)"road_class == PRIMARY", (NameValidator)(NameValidator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Z, lambda$isValidAndSimpleCondition$17(java.lang.String ), (Ljava/lang/String;)Z)(), (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$isValidAndSimpleCondition$18(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).ok);
        result = ConditionalExpressionVisitor.parse((String)"road_class == PRIMARY", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[road_class]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"toll == Toll.NO", (NameValidator)validVariable, k -> "");
        Assertions.assertFalse((boolean)result.ok);
        Assertions.assertEquals((Object)"[toll]", (Object)result.guessedVariables.toString());
        Assertions.assertTrue((boolean)ConditionalExpressionVisitor.parse((String)"road_class.ordinal()*2 == PRIMARY.ordinal()*2", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$isValidAndSimpleCondition$21(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).ok);
        Assertions.assertTrue((boolean)ConditionalExpressionVisitor.parse((String)"Math.sqrt(road_class.ordinal()) > 1", (NameValidator)validVariable, (ClassHelper)(ClassHelper)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$isValidAndSimpleCondition$22(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).ok);
        result = ConditionalExpressionVisitor.parse((String)"(toll == NO || road_class == PRIMARY) && toll == NO", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[toll, road_class]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"backward_my_speed", (NameValidator)validVariable, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[backward_my_speed]", (Object)result.guessedVariables.toString());
    }

    @Test
    public void testAbs() {
        ParseResult result = ConditionalExpressionVisitor.parse((String)"Math.abs(average_slope) < -0.5", "average_slope"::equals, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[average_slope]", (Object)result.guessedVariables.toString());
    }

    @Test
    public void testNegativeConstant() {
        ParseResult result = ConditionalExpressionVisitor.parse((String)"average_slope < -0.5", "average_slope"::equals, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[average_slope]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"-average_slope > -0.5", "average_slope"::equals, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertEquals((Object)"[average_slope]", (Object)result.guessedVariables.toString());
        result = ConditionalExpressionVisitor.parse((String)"Math.sqrt(-2)", var -> false, k -> "");
        Assertions.assertTrue((boolean)result.ok);
        Assertions.assertTrue((boolean)result.guessedVariables.isEmpty());
    }

    private static /* synthetic */ String lambda$isValidAndSimpleCondition$22(String k) {
        return "";
    }

    private static /* synthetic */ String lambda$isValidAndSimpleCondition$21(String k) {
        return "";
    }

    private static /* synthetic */ String lambda$isValidAndSimpleCondition$18(String k) {
        return "";
    }

    private static /* synthetic */ boolean lambda$isValidAndSimpleCondition$17(String s) {
        return false;
    }

    private static /* synthetic */ String lambda$testConvertExpression$9(String k) {
        return "";
    }

    private static /* synthetic */ String lambda$testConvertExpression$8(String k) {
        return "";
    }

    private static /* synthetic */ String lambda$testConvertExpression$7(String k) {
        return k.equals("toll") ? "Toll" : "RoadClass";
    }

    private static /* synthetic */ String lambda$testConvertExpression$6(String k) {
        return "Toll";
    }

    private static /* synthetic */ String lambda$testConvertExpression$5(String k) {
        return "Hello";
    }

    private static /* synthetic */ String lambda$protectUsFromStuff$2(String k) {
        return "";
    }
}

