/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DefaultImportRegistry;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.JsonFeatureCollection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

class CustomModelParserTest {
    BaseGraph graph;
    EncodingManager encodingManager;
    EnumEncodedValue<RoadClass> roadClassEnc;
    BooleanEncodedValue accessEnc;
    DecimalEncodedValue avgSpeedEnc;
    EnumEncodedValue<Country> countryEnc;
    EnumEncodedValue<State> stateEnc;
    double maxSpeed;

    CustomModelParserTest() {
    }

    @BeforeEach
    void setup() {
        this.accessEnc = VehicleAccess.create((String)"car");
        this.avgSpeedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        this.countryEnc = Country.create();
        this.stateEnc = State.create();
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.accessEnc).add((EncodedValue)this.avgSpeedEnc).add((EncodedValue)new EnumEncodedValue("bus", MyBus.class)).add(this.stateEnc).add(this.countryEnc).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Surface.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadEnvironment.create()).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
        this.roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        this.maxSpeed = 140.0;
    }

    @Test
    void setPriorityForRoadClass() {
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        CustomWeighting.EdgeToDoubleMapping priorityMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToPriorityMapping();
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        EdgeIteratorState edge1 = graph.edge(0, 1).setDistance(100.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY);
        EdgeIteratorState edge2 = graph.edge(1, 2).setDistance(100.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY);
        Assertions.assertEquals((double)0.5, (double)priorityMapping.get(edge1, false), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)priorityMapping.get(edge2, false), (double)1.0E-6);
    }

    @Test
    void testPriority() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 80.0).set(this.accessEnc, true, true);
        EdgeIteratorState secondary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        EdgeIteratorState tertiary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.TERTIARY).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel.addToPriority(Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.7"));
        customModel.addToPriority(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToPriority(Statement.If((String)"road_environment != FERRY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        CustomWeighting.EdgeToDoubleMapping priorityMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToPriorityMapping();
        Assertions.assertEquals((double)0.4, (double)priorityMapping.get(primary, false), (double)0.01);
        Assertions.assertEquals((double)0.5599999999999999, (double)priorityMapping.get(secondary, false), (double)0.01);
        Assertions.assertEquals((double)0.7200000000000001, (double)priorityMapping.get(tertiary, false), (double)0.01);
        customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"1"));
        customModel.addToPriority(Statement.If((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        priorityMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToPriorityMapping();
        Assertions.assertEquals((double)1.0, (double)priorityMapping.get(primary, false), (double)0.01);
        Assertions.assertEquals((double)0.9, (double)priorityMapping.get(secondary, false), (double)0.01);
    }

    @Test
    public void testCountry() {
        EdgeIteratorState usRoad = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 80.0).set(this.accessEnc, true, true).set(this.countryEnc, (Enum)Country.USA).set(this.stateEnc, (Enum)State.US_AK);
        EdgeIteratorState us2Road = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 80.0).set(this.accessEnc, true, true).set(this.countryEnc, (Enum)Country.USA);
        EdgeIteratorState deRoad = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true).set(this.countryEnc, (Enum)Country.DEU);
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"country == USA", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel.addToPriority(Statement.If((String)"country == USA && state == US_AK", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.6"));
        customModel.addToPriority(Statement.If((String)"country == DEU", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        CustomWeighting.EdgeToDoubleMapping priorityMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToPriorityMapping();
        Assertions.assertEquals((double)0.3, (double)priorityMapping.get(usRoad, false), (double)0.01);
        Assertions.assertEquals((double)0.5, (double)priorityMapping.get(us2Road, false), (double)0.01);
        Assertions.assertEquals((double)0.8, (double)priorityMapping.get(deRoad, false), (double)0.01);
    }

    @Test
    public void testBrackets() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.accessEnc, true, true).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 80.0);
        EdgeIteratorState secondary = this.graph.edge(0, 1).setDistance(10.0).set(this.accessEnc, true, true).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avgSpeedEnc, 40.0);
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"(road_class == PRIMARY || car_access == true) && car_average_speed > 50", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        CustomWeighting.Parameters parameters = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager);
        Assertions.assertEquals((double)0.9, (double)parameters.getEdgeToPriorityMapping().get(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.0, (double)parameters.getEdgeToPriorityMapping().get(secondary, false), (double)0.01);
    }

    @Test
    public void testSpeedFactorAndPriorityAndMaxSpeed() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avgSpeedEnc, 80.0).set(this.accessEnc, true, true);
        EdgeIteratorState secondary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.avgSpeedEnc.getName()));
        customModel.addToSpeed(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        CustomWeighting.Parameters parameters = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager);
        Assertions.assertEquals((double)0.9, (double)parameters.getEdgeToPriorityMapping().get(primary, false), (double)0.01);
        Assertions.assertEquals((double)64.0, (double)parameters.getEdgeToSpeedMapping().get(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.0, (double)parameters.getEdgeToPriorityMapping().get(secondary, false), (double)0.01);
        Assertions.assertEquals((double)70.0, (double)parameters.getEdgeToSpeedMapping().get(secondary, false), (double)0.01);
        customModel.addToSpeed(Statement.If((String)"road_class != PRIMARY", (Statement.Op)Statement.Op.LIMIT, (String)"50"));
        CustomWeighting.EdgeToDoubleMapping speedMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToSpeedMapping();
        Assertions.assertEquals((double)64.0, (double)speedMapping.get(primary, false), (double)0.01);
        Assertions.assertEquals((double)50.0, (double)speedMapping.get(secondary, false), (double)0.01);
    }

    @Test
    void testIllegalOrder() {
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToPriority(Statement.If((String)"road_environment != FERRY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager));
        CustomModel customModel2 = new CustomModel();
        customModel2.addToPriority(Statement.ElseIf((String)"road_environment != FERRY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel2.addToPriority(Statement.If((String)"road_class != PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.createWeightingParameters((CustomModel)customModel2, (EncodedValueLookup)this.encodingManager));
    }

    @Test
    public void multipleAreas() {
        CustomModel customModel = new CustomModel();
        JsonFeatureCollection areas = new JsonFeatureCollection();
        Coordinate[] area_1_coordinates = new Coordinate[]{new Coordinate(48.019324184801185, 11.28021240234375), new Coordinate(48.019324184801185, 11.53564453125), new Coordinate(48.11843396091691, 11.53564453125), new Coordinate(48.11843396091691, 11.28021240234375), new Coordinate(48.019324184801185, 11.28021240234375)};
        Coordinate[] area_2_coordinates = new Coordinate[]{new Coordinate(48.15509285476017, 11.53289794921875), new Coordinate(48.15509285476017, 11.8212890625), new Coordinate(48.281365151571755, 11.8212890625), new Coordinate(48.281365151571755, 11.53289794921875), new Coordinate(48.15509285476017, 11.53289794921875)};
        areas.getFeatures().add(new JsonFeature("area_1", "Feature", null, (Geometry)new GeometryFactory().createPolygon(area_1_coordinates), new HashMap()));
        areas.getFeatures().add(new JsonFeature("area_2", "Feature", null, (Geometry)new GeometryFactory().createPolygon(area_2_coordinates), new HashMap()));
        customModel.setAreas(areas);
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.avgSpeedEnc.getName()));
        customModel.addToSpeed(Statement.If((String)"in_area_1", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        customModel.addToSpeed(Statement.If((String)"!in_area_2", (Statement.Op)Statement.Op.LIMIT, (String)"25"));
        customModel.addToSpeed(Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"15"));
        Assertions.assertAll((Executable[])new Executable[]{() -> CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager)});
        CustomModel customModel2 = new CustomModel();
        customModel2.setAreas(areas);
        customModel2.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.avgSpeedEnc.getName()));
        customModel2.addToSpeed(Statement.If((String)"in_area_1", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        customModel2.addToSpeed(Statement.If((String)"in_area_2", (Statement.Op)Statement.Op.LIMIT, (String)"25"));
        customModel2.addToSpeed(Statement.If((String)"in_area_3", (Statement.Op)Statement.Op.LIMIT, (String)"150"));
        customModel2.addToSpeed(Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"15"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.createWeightingParameters((CustomModel)customModel2, (EncodedValueLookup)this.encodingManager));
    }

    @Test
    public void parseValue() {
        DecimalEncodedValue maxSpeedEnc = this.encodingManager.getDecimalEncodedValue("max_speed");
        EdgeIteratorState maxLower = this.graph.edge(0, 1).setDistance(10.0).set(maxSpeedEnc, 60.0).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        EdgeIteratorState maxSame = this.graph.edge(1, 2).setDistance(10.0).set(maxSpeedEnc, 70.0).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.avgSpeedEnc.getName()));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"max_speed * 1.1"));
        CustomWeighting.EdgeToDoubleMapping speedMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToSpeedMapping();
        Assertions.assertEquals((double)70.0, (double)speedMapping.get(maxSame, false), (double)0.01);
        Assertions.assertEquals((double)66.0, (double)speedMapping.get(maxLower, false), (double)0.01);
    }

    @Test
    public void parseBlock() {
        DecimalEncodedValue maxSpeedEnc = this.encodingManager.getDecimalEncodedValue("max_speed");
        EdgeIteratorState edge60 = this.graph.edge(0, 1).setDistance(10.0).set(maxSpeedEnc, 60.0).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        EdgeIteratorState edge70 = this.graph.edge(1, 2).setDistance(10.0).set(maxSpeedEnc, 70.0).set(this.avgSpeedEnc, 70.0).set(this.accessEnc, true, true);
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"200"));
        customModel.addToSpeed(Statement.If((String)"max_speed > 65", List.of(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"65"))));
        CustomWeighting.EdgeToDoubleMapping speedMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToSpeedMapping();
        Assertions.assertEquals((double)65.0, (double)speedMapping.get(edge70, false), (double)0.01);
        Assertions.assertEquals((double)200.0, (double)speedMapping.get(edge60, false), (double)0.01);
    }

    @Test
    public void parseValueWithError() {
        CustomModel customModel1 = new CustomModel();
        customModel1.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"unknown"));
        IllegalArgumentException ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.createWeightingParameters((CustomModel)customModel1, (EncodedValueLookup)this.encodingManager));
        Assertions.assertEquals((Object)"Cannot compile expression: 'unknown' not available", (Object)ret.getMessage());
        CustomModel customModel3 = new CustomModel();
        customModel3.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.avgSpeedEnc.getName()));
        customModel3.addToSpeed(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel3.addToSpeed(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"road_class"));
        ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.createWeightingParameters((CustomModel)customModel3, (EncodedValueLookup)this.encodingManager));
        Assertions.assertTrue((boolean)ret.getMessage().contains("Binary numeric promotion not possible on types \"double\" and \"com.graphhopper.routing.ev.RoadClass\""), (String)ret.getMessage());
    }

    @Test
    public void parseConditionWithError() {
        NameValidator validVariable = s -> this.encodingManager.hasEncodedValue(s);
        IllegalArgumentException ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.parseExpressions((StringBuilder)new StringBuilder(), (NameValidator)validVariable, (String)"[HERE]", new HashSet(), Arrays.asList(Statement.If((String)"max_weight > 10", (Statement.Op)Statement.Op.MULTIPLY, (String)"0")), s -> "", (String)""));
        Assertions.assertTrue((boolean)ret.getMessage().startsWith("[HERE] invalid condition \"max_weight > 10\": 'max_weight' not available"), (String)ret.getMessage());
        ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.parseExpressions((StringBuilder)new StringBuilder(), (NameValidator)validVariable, (String)"[HERE]", new HashSet(), Arrays.asList(Statement.If((String)"country == GERMANY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0")), s -> "", (String)""));
        Assertions.assertTrue((boolean)ret.getMessage().startsWith("[HERE] invalid condition \"country == GERMANY\": 'GERMANY' not available"), (String)ret.getMessage());
        ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CustomModelParser.parseExpressions((StringBuilder)new StringBuilder(), (NameValidator)validVariable, (String)"[HERE]", new HashSet(), Arrays.asList(Statement.If((String)"edge.fetchWayGeometry().size() > 2", (Statement.Op)Statement.Op.MULTIPLY, (String)"0")), s -> "", (String)""));
        Assertions.assertTrue((boolean)ret.getMessage().startsWith("[HERE] invalid condition \"edge.fetchWayGeometry().size() > 2\": size is an illegal method"), (String)ret.getMessage());
    }

    @Test
    void testBackwardFunction() {
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"backward_car_access != car_access", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        CustomWeighting.EdgeToDoubleMapping priorityMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getEdgeToPriorityMapping();
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        EdgeIteratorState edge1 = graph.edge(0, 1).setDistance(100.0).set(this.accessEnc, true, false);
        EdgeIteratorState edge2 = graph.edge(1, 2).setDistance(100.0).set(this.accessEnc, true, true);
        Assertions.assertEquals((double)0.5, (double)priorityMapping.get(edge1, false), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)priorityMapping.get(edge2, false), (double)1.0E-6);
    }

    @Test
    void testTurnPenalty() {
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        customModel.addToTurnPenalty(Statement.If((String)"prev_road_class != PRIMARY && road_class == PRIMARY", (Statement.Op)Statement.Op.ADD, (String)"100"));
        CustomWeighting.TurnPenaltyMapping turnPenaltyMapping = CustomModelParser.createWeightingParameters((CustomModel)customModel, (EncodedValueLookup)this.encodingManager).getTurnPenaltyMapping();
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        EdgeIteratorState edge1 = graph.edge(0, 1).setDistance(100.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY);
        EdgeIteratorState edge2 = graph.edge(1, 2).setDistance(100.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY);
        EdgeIteratorState edge3 = graph.edge(2, 3).setDistance(100.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY);
        Assertions.assertEquals((double)100.0, (double)turnPenaltyMapping.get(graph, graph.getEdgeAccess(), edge1.getEdge(), 1, edge2.getEdge()));
        Assertions.assertEquals((double)0.0, (double)turnPenaltyMapping.get(graph, graph.getEdgeAccess(), edge2.getEdge(), 2, edge3.getEdge()));
    }

    @Test
    public void findVariablesForEncodedValueString() {
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"!foot_access && (hike_rating < 4 || road_access == PRIVATE)", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        List variables = CustomModelParser.findVariablesForEncodedValuesString((CustomModel)customModel, s -> new DefaultImportRegistry().createImportUnit(s) != null, s -> "");
        Assertions.assertEquals(List.of("foot_access", "hike_rating", "road_access"), (Object)variables);
    }

    public static enum MyBus {
        MISSING,
        YES,
        DESIGNATED,
        DESTINATION,
        NO;

    }
}

