/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Orientation;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.OrientationCalculator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.shapes.Polygon;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CustomWeightingHelperTest {
    CustomWeightingHelperTest() {
    }

    @Test
    public void testInRectangle() {
        Polygon square = new Polygon(new double[]{0.0, 0.0, 20.0, 20.0}, new double[]{0.0, 20.0, 20.0, 0.0});
        Assertions.assertTrue((boolean)square.isRectangle());
        BaseGraph g = new BaseGraph.Builder(1).create();
        g.getNodeAccess().setNode(0, 1.0, 1.0);
        g.getNodeAccess().setNode(1, 3.0, 3.0);
        EdgeIteratorState edge = g.edge(0, 1).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 2.0}));
        Assertions.assertTrue((boolean)CustomWeightingHelper.in((Polygon)square, (EdgeIteratorState)edge));
        g.getNodeAccess().setNode(2, 0.0, 0.0);
        g.getNodeAccess().setNode(3, 20.0, 20.0);
        edge = g.edge(2, 3).setWayGeometry(Helper.createPointList((double[])new double[]{20.0, 0.0}));
        Assertions.assertTrue((boolean)CustomWeightingHelper.in((Polygon)square, (EdgeIteratorState)edge));
        g.getNodeAccess().setNode(4, 0.0, 30.0);
        g.getNodeAccess().setNode(5, 20.0, 50.0);
        edge = g.edge(4, 5).setWayGeometry(Helper.createPointList((double[])new double[]{10.0, 40.0}));
        Assertions.assertFalse((boolean)CustomWeightingHelper.in((Polygon)square, (EdgeIteratorState)edge));
        g.getNodeAccess().setNode(6, 0.0, 30.0);
        g.getNodeAccess().setNode(7, 30.0, 0.0);
        edge = g.edge(6, 7).setWayGeometry(Helper.createPointList((double[])new double[]{30.0, 30.0}));
        Assertions.assertFalse((boolean)CustomWeightingHelper.in((Polygon)square, (EdgeIteratorState)edge));
    }

    @Test
    public void testNegativeMax() {
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)VehicleSpeed.key((String)"car")));
        customModel.addToSpeed(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        customModel.addToSpeed(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"-0.5"));
        CustomWeightingHelper helper = new CustomWeightingHelper();
        EncodingManager lookup = new EncodingManager.Builder().add((EncodedValue)VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)true)).build();
        helper.init(customModel, (EncodedValueLookup)lookup, null);
        IllegalArgumentException ret = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CustomWeightingHelper)helper).calcMaxSpeed());
        Assertions.assertTrue((boolean)ret.getMessage().startsWith("statement resulted in negative value"));
    }

    @Test
    public void testCalcChangeAngle() {
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)Orientation.create()).build();
        DecimalEncodedValue orientationEnc = encodingManager.getDecimalEncodedValue("orientation");
        OrientationCalculator calc = new OrientationCalculator(orientationEnc);
        BaseGraph graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        graph.getNodeAccess().setNode(1, 0.03, 0.011);
        graph.getNodeAccess().setNode(2, 0.02, 0.009);
        graph.getNodeAccess().setNode(3, 0.01, 0.0);
        graph.getNodeAccess().setNode(4, 0.0, 0.008);
        EdgeIntAccess edgeIntAccess = graph.getEdgeAccess();
        EdgeIteratorState edge12 = this.handleWayTags(edgeIntAccess, calc, graph.edge(1, 2), List.of());
        EdgeIteratorState edge24 = this.handleWayTags(edgeIntAccess, calc, graph.edge(2, 4), List.of());
        EdgeIteratorState edge23 = this.handleWayTags(edgeIntAccess, calc, graph.edge(2, 3), Arrays.asList(0.02, 0.002));
        EdgeIteratorState edge23down = this.handleWayTags(edgeIntAccess, calc, graph.edge(2, 3), Arrays.asList(0.01, 0.005));
        Assertions.assertEquals((double)-12.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge12.getEdge(), 2, edge24.getEdge()), (double)1.0);
        Assertions.assertEquals((double)-12.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge23down.getEdge(), 2, edge12.getEdge()), (double)1.0);
        Assertions.assertEquals((double)-84.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge24.getEdge(), 2, edge23.getEdge()), (double)1.0);
        Assertions.assertEquals((double)-84.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge23.getEdge(), 2, edge12.getEdge()), (double)1.0);
        Assertions.assertEquals((double)96.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge23down.getEdge(), 3, edge23.getEdge()), (double)1.0);
        Assertions.assertEquals((double)84.0, (double)CustomWeightingHelperTest.calcChangeAngle(graph, edgeIntAccess, orientationEnc, edge12.getEdge(), 2, edge23.getEdge()), (double)1.0);
    }

    public static double calcChangeAngle(BaseGraph graph, EdgeIntAccess edgeIntAccess, DecimalEncodedValue orientationEnc, int inEdge, int viaNode, int outEdge) {
        boolean inEdgeReverse = !graph.isAdjNode(inEdge, viaNode);
        boolean outEdgeReverse = !graph.isAdjNode(outEdge, viaNode);
        return CustomWeightingHelper.calcChangeAngle((EdgeIntAccess)edgeIntAccess, (DecimalEncodedValue)orientationEnc, (int)inEdge, (boolean)inEdgeReverse, (int)outEdge, (boolean)outEdgeReverse);
    }

    @Test
    public void testCalcTurnWeight() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue avgSpeedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)true);
        DecimalEncodedValue orientEnc = Orientation.create();
        EncodingManager em = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)avgSpeedEnc).add((EncodedValue)orientEnc).addTurnCostEncodedValue((EncodedValue)TurnRestriction.create((String)"car")).build();
        BaseGraph graph = new BaseGraph.Builder(em).withTurnCosts(true).create();
        graph.getNodeAccess().setNode(0, 51.0362, 13.714);
        graph.getNodeAccess().setNode(1, 51.0362, 13.72);
        graph.getNodeAccess().setNode(2, 51.0362, 13.726);
        graph.getNodeAccess().setNode(3, 51.0358, 13.7205);
        graph.getNodeAccess().setNode(4, 51.0366, 13.72);
        graph.getNodeAccess().setNode(5, 51.0366, 13.726);
        graph.getNodeAccess().setNode(6, 51.0358, 13.726);
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        customModel.addToTurnPenalty(Statement.If((String)"change_angle > -25 && change_angle < 25", (Statement.Op)Statement.Op.ADD, (String)"0"));
        customModel.addToTurnPenalty(Statement.ElseIf((String)"change_angle >= 25 && change_angle < 80", (Statement.Op)Statement.Op.ADD, (String)"0.5"));
        customModel.addToTurnPenalty(Statement.ElseIf((String)"change_angle >= 80 && change_angle <= 180", (Statement.Op)Statement.Op.ADD, (String)"1"));
        customModel.addToTurnPenalty(Statement.ElseIf((String)"change_angle <= -25 && change_angle > -80", (Statement.Op)Statement.Op.ADD, (String)"6"));
        customModel.addToTurnPenalty(Statement.ElseIf((String)"change_angle <= -80 && change_angle >= -180", (Statement.Op)Statement.Op.ADD, (String)"12"));
        customModel.addToTurnPenalty(Statement.Else((Statement.Op)Statement.Op.ADD, (String)"Infinity"));
        Profile profile = new Profile("car");
        profile.setTurnCostsConfig(new TurnCostsConfig());
        profile.setCustomModel(customModel);
        Weighting weighting = new DefaultWeightingFactory(graph, em).createWeighting(profile, new PMap(), false);
        OrientationCalculator calc = new OrientationCalculator(orientEnc);
        EdgeIntAccess edgeIntAccess = graph.getEdgeAccess();
        EdgeIteratorState edge01 = this.handleWayTags(edgeIntAccess, calc, graph.edge(0, 1).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        EdgeIteratorState edge13 = this.handleWayTags(edgeIntAccess, calc, graph.edge(1, 3).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        EdgeIteratorState edge14 = this.handleWayTags(edgeIntAccess, calc, graph.edge(1, 4).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        EdgeIteratorState edge26 = this.handleWayTags(edgeIntAccess, calc, graph.edge(2, 6).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        EdgeIteratorState edge25 = this.handleWayTags(edgeIntAccess, calc, graph.edge(2, 5).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        EdgeIteratorState edge12 = this.handleWayTags(edgeIntAccess, calc, graph.edge(1, 2).setDistance(500.0).set(avgSpeedEnc, 15.0).set(accessEnc, true, true), List.of());
        Assertions.assertEquals((double)1.0, (double)weighting.calcTurnWeight(edge14.getEdge(), 1, edge01.getEdge()), (double)0.01);
        Assertions.assertEquals((double)0.0, (double)weighting.calcTurnWeight(edge01.getEdge(), 1, edge12.getEdge()), (double)0.01);
        Assertions.assertEquals((double)12.0, (double)weighting.calcTurnWeight(edge14.getEdge(), 1, edge12.getEdge()), (double)0.01);
        Assertions.assertEquals((double)0.5, (double)weighting.calcTurnWeight(edge01.getEdge(), 1, edge13.getEdge()), (double)0.01);
        Assertions.assertEquals((double)6.0, (double)weighting.calcTurnWeight(edge13.getEdge(), 1, edge01.getEdge()), (double)0.01);
        Assertions.assertEquals((double)12.0, (double)weighting.calcTurnWeight(edge12.getEdge(), 2, edge25.getEdge()), (double)0.01);
        Assertions.assertEquals((double)12.0, (double)weighting.calcTurnWeight(edge26.getEdge(), 2, edge12.getEdge()), (double)0.01);
        Assertions.assertEquals((double)1.0, (double)weighting.calcTurnWeight(edge25.getEdge(), 2, edge12.getEdge()), (double)0.01);
    }

    EdgeIteratorState handleWayTags(EdgeIntAccess edgeIntAccess, OrientationCalculator calc, EdgeIteratorState edge, List<Double> rawPointList) {
        if (rawPointList.size() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (!rawPointList.isEmpty()) {
            PointList list = new PointList();
            for (int i = 0; i < rawPointList.size(); i += 2) {
                list.add(rawPointList.get(0).doubleValue(), rawPointList.get(1).doubleValue());
            }
            edge.setWayGeometry(list);
        }
        ReaderWay way = new ReaderWay(1L);
        way.setTag("point_list", (Object)edge.fetchWayGeometry(FetchMode.ALL));
        calc.handleWayTags(edge.getEdge(), edgeIntAccess, way, null);
        return edge;
    }
}

