/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.json.Statement;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Hazmat;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.TurnCostsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CustomWeightingTest {
    BaseGraph graph;
    DecimalEncodedValue avSpeedEnc;
    BooleanEncodedValue accessEnc;
    DecimalEncodedValue maxSpeedEnc;
    EnumEncodedValue<RoadClass> roadClassEnc;
    EncodingManager encodingManager;
    BooleanEncodedValue turnRestrictionEnc = TurnRestriction.create((String)"car");

    CustomWeightingTest() {
    }

    @BeforeEach
    public void setup() {
        this.accessEnc = VehicleAccess.create((String)"car");
        this.avSpeedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)true);
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.accessEnc).add((EncodedValue)this.avSpeedEnc).add((EncodedValue)Toll.create()).add((EncodedValue)Hazmat.create()).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).addTurnCostEncodedValue((EncodedValue)this.turnRestrictionEnc).build();
        this.maxSpeedEnc = this.encodingManager.getDecimalEncodedValue("max_speed");
        this.roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
    }

    private void setTurnRestriction(Graph graph, int from, int via, int to) {
        graph.getTurnCostStorage().set(this.turnRestrictionEnc, GHUtility.getEdge((Graph)graph, (int)from, (int)via).getEdge(), via, GHUtility.getEdge((Graph)graph, (int)via, (int)to).getEdge(), true);
    }

    private CustomModel createSpeedCustomModel(DecimalEncodedValue speedEnc) {
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)speedEnc.getName()));
        return customModel;
    }

    private Weighting createWeighting(CustomModel vehicleModel) {
        return CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)vehicleModel);
    }

    @Test
    public void speedOnly() {
        EdgeIteratorState edge = this.graph.edge(0, 1).setDistance(1000.0).set(this.avSpeedEnc, 50.0, 100.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(0.0));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)72.0, (double)weighting.calcEdgeWeight(edge, false), (double)1.0E-6);
        Assertions.assertEquals((double)36.0, (double)weighting.calcEdgeWeight(edge, true), (double)1.0E-6);
    }

    @Test
    public void withPriority() {
        EdgeIteratorState slow = this.graph.edge(0, 1).set(this.avSpeedEnc, 25.0, 25.0).setDistance(1000.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY);
        EdgeIteratorState medium = this.graph.edge(0, 1).set(this.avSpeedEnc, 50.0, 50.0).setDistance(1000.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY);
        EdgeIteratorState fast = this.graph.edge(0, 1).set(this.avSpeedEnc, 100.0).setDistance(1000.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY);
        Weighting weighting = this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc));
        Assertions.assertEquals((double)144.0, (double)weighting.calcEdgeWeight(slow, false), (double)0.1);
        Assertions.assertEquals((double)72.0, (double)weighting.calcEdgeWeight(medium, false), (double)0.1);
        Assertions.assertEquals((double)36.0, (double)weighting.calcEdgeWeight(fast, false), (double)0.1);
        weighting = CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5")));
        Assertions.assertEquals((double)288.0, (double)weighting.calcEdgeWeight(slow, false), (double)0.1);
        Assertions.assertEquals((double)144.0, (double)weighting.calcEdgeWeight(medium, false), (double)0.1);
        Assertions.assertEquals((double)72.0, (double)weighting.calcEdgeWeight(fast, false), (double)0.1);
    }

    @Test
    public void withDistanceInfluence() {
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(10000.0).set(this.avSpeedEnc, 50.0);
        EdgeIteratorState edge2 = this.graph.edge(0, 1).setDistance(5000.0).set(this.avSpeedEnc, 25.0);
        Weighting weighting = this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(0.0)));
        Assertions.assertEquals((double)720.0, (double)weighting.calcEdgeWeight(edge1, false), (double)0.1);
        Assertions.assertEquals((double)720000.0, (double)weighting.calcEdgeMillis(edge1, false), (double)0.1);
        Assertions.assertEquals((double)720.0, (double)weighting.calcEdgeWeight(edge2, false), (double)0.1);
        Assertions.assertEquals((double)720000.0, (double)weighting.calcEdgeMillis(edge2, false), (double)0.1);
        weighting = this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(30.0)));
        Assertions.assertEquals((double)1020.0, (double)weighting.calcEdgeWeight(edge1, false), (double)0.1);
        Assertions.assertEquals((double)870.0, (double)weighting.calcEdgeWeight(edge2, false), (double)0.1);
        Assertions.assertEquals((double)720000.0, (double)weighting.calcEdgeMillis(edge1, false), (double)0.1);
        Assertions.assertEquals((double)720000.0, (double)weighting.calcEdgeMillis(edge2, false), (double)0.1);
    }

    @Test
    public void testSpeedFactorBooleanEV() {
        EdgeIteratorState edge = this.graph.edge(0, 1).set(this.avSpeedEnc, 15.0, 15.0).setDistance(10.0);
        Weighting weighting = this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)));
        Assertions.assertEquals((double)3.1, (double)weighting.calcEdgeWeight(edge, false), (double)0.01);
        weighting = this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"road_class_link", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5")));
        BooleanEncodedValue rcLinkEnc = this.encodingManager.getBooleanEncodedValue("road_class_link");
        Assertions.assertEquals((double)3.1, (double)weighting.calcEdgeWeight(edge.set(rcLinkEnc, false), false), (double)0.01);
        Assertions.assertEquals((double)5.5, (double)weighting.calcEdgeWeight(edge.set(rcLinkEnc, true), false), (double)0.01);
    }

    @Test
    public void testBoolean() {
        SimpleBooleanEncodedValue specialEnc = new SimpleBooleanEncodedValue("special", true);
        DecimalEncodedValue avSpeedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)specialEnc).add((EncodedValue)avSpeedEnc).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
        EdgeIteratorState edge = this.graph.edge(0, 1).set((BooleanEncodedValue)specialEnc, false, true).set(avSpeedEnc, 15.0).setDistance(10.0);
        Weighting weighting = this.createWeighting(this.createSpeedCustomModel(avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)));
        Assertions.assertEquals((double)3.1, (double)weighting.calcEdgeWeight(edge, false), (double)0.01);
        weighting = this.createWeighting(this.createSpeedCustomModel(avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"special == true", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8")).addToPriority(Statement.If((String)"special == false", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.4")));
        Assertions.assertEquals((double)6.7, (double)weighting.calcEdgeWeight(edge, false), (double)0.01);
        Assertions.assertEquals((double)3.7, (double)weighting.calcEdgeWeight(edge, true), (double)0.01);
    }

    @Test
    public void testSpeedFactorAndPriority() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avSpeedEnc, 80.0);
        EdgeIteratorState secondary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avSpeedEnc, 70.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"road_class != PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5")).addToSpeed(Statement.If((String)"road_class != PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.15, (double)weighting.calcEdgeWeight(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.84, (double)weighting.calcEdgeWeight(secondary, false), (double)0.01);
        customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"1.0")).addToPriority(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.5")).addToSpeed(Statement.If((String)"road_class != PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.15, (double)weighting.calcEdgeWeight(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.84, (double)weighting.calcEdgeWeight(secondary, false), (double)0.01);
    }

    @Test
    public void testIssueSameKey() {
        EdgeIteratorState withToll = this.graph.edge(0, 1).setDistance(10.0).set(this.avSpeedEnc, 80.0);
        EdgeIteratorState noToll = this.graph.edge(1, 2).setDistance(10.0).set(this.avSpeedEnc, 80.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        customModel.setDistanceInfluence(Double.valueOf(70.0)).addToSpeed(Statement.If((String)"toll == HGV || toll == ALL", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8")).addToSpeed(Statement.If((String)"hazmat != NO", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.26, (double)weighting.calcEdgeWeight(withToll, false), (double)0.01);
        Assertions.assertEquals((double)1.26, (double)weighting.calcEdgeWeight(noToll, false), (double)0.01);
        customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        customModel.setDistanceInfluence(Double.valueOf(70.0)).addToSpeed(Statement.If((String)"bike_network != OTHER", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.26, (double)weighting.calcEdgeWeight(withToll, false), (double)0.01);
        Assertions.assertEquals((double)1.26, (double)weighting.calcEdgeWeight(noToll, false), (double)0.01);
    }

    @Test
    public void testFirstMatch() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avSpeedEnc, 80.0);
        EdgeIteratorState secondary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avSpeedEnc, 70.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToSpeed(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.26, (double)weighting.calcEdgeWeight(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.21, (double)weighting.calcEdgeWeight(secondary, false), (double)0.01);
        customModel.addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.9"));
        customModel.addToPriority(Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.33, (double)weighting.calcEdgeWeight(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.34, (double)weighting.calcEdgeWeight(secondary, false), (double)0.01);
    }

    @Test
    public void testSpeedBiggerThan() {
        EdgeIteratorState edge40 = this.graph.edge(0, 1).setDistance(10.0).set(this.avSpeedEnc, 40.0);
        EdgeIteratorState edge50 = this.graph.edge(1, 2).setDistance(10.0).set(this.avSpeedEnc, 50.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"car_average_speed > 40", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.6, (double)weighting.calcEdgeWeight(edge40, false), (double)0.01);
        Assertions.assertEquals((double)2.14, (double)weighting.calcEdgeWeight(edge50, false), (double)0.01);
    }

    @Test
    public void testRoadClass() {
        EdgeIteratorState primary = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avSpeedEnc, 80.0);
        EdgeIteratorState secondary = this.graph.edge(1, 2).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.SECONDARY).set(this.avSpeedEnc, 80.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.6, (double)weighting.calcEdgeWeight(primary, false), (double)0.01);
        Assertions.assertEquals((double)1.15, (double)weighting.calcEdgeWeight(secondary, false), (double)0.01);
    }

    @Test
    public void testArea() throws Exception {
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avSpeedEnc, 80.0);
        EdgeIteratorState edge2 = this.graph.edge(2, 3).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.PRIMARY).set(this.avSpeedEnc, 80.0);
        this.graph.getNodeAccess().setNode(0, 50.012, 11.582);
        this.graph.getNodeAccess().setNode(1, 50.0125, 11.585);
        this.graph.getNodeAccess().setNode(2, 40.0, 8.0);
        this.graph.getNodeAccess().setNode(3, 40.1, 8.1);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToPriority(Statement.If((String)"in_custom1", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        ObjectMapper om = new ObjectMapper().registerModule((Module)new JtsModule());
        JsonFeature json = (JsonFeature)om.readValue("{ \"geometry\":{ \"type\": \"Polygon\", \"coordinates\": [[[11.5818,50.0126], [11.5818,50.0119], [11.5861,50.0119], [11.5861,50.0126], [11.5818,50.0126]]] }}", JsonFeature.class);
        json.setId("custom1");
        customModel.getAreas().getFeatures().add(json);
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.6, (double)weighting.calcEdgeWeight(edge1, false), (double)0.01);
        Assertions.assertEquals((double)1.15, (double)weighting.calcEdgeWeight(edge2, false), (double)0.01);
    }

    @Test
    public void testMaxSpeed() {
        Assertions.assertEquals((double)155.0, (double)this.avSpeedEnc.getMaxOrMaxStorableDecimal(), (double)0.1);
        Assertions.assertEquals((double)0.049999999999999996, (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"72"))).calcMinWeightPerDistance(), (double)0.001);
        Assertions.assertEquals((double)0.023225806451612905, (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"180"))).calcMinWeightPerDistance(), (double)0.001);
        Assertions.assertEquals((double)0.024, (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToSpeed(Statement.If((String)"road_class == SERVICE", (Statement.Op)Statement.Op.MULTIPLY, (String)"1.5")).addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"150"))).calcMinWeightPerDistance(), (double)0.001);
    }

    @Test
    public void testMaxPriority() {
        double maxSpeed = 155.0;
        Assertions.assertEquals((double)maxSpeed, (double)this.avSpeedEnc.getMaxOrMaxStorableDecimal(), (double)0.1);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 0.5 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"))).calcMinWeightPerDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 1.0 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"2.0"))).calcMinWeightPerDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 2.0 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"3.0")).addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"2.0"))).calcMinWeightPerDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 1.5 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"1.5"))).calcMinWeightPerDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 3.0 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"road_class == SERVICE", (Statement.Op)Statement.Op.MULTIPLY, (String)"3.0"))).calcMinWeightPerDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 / maxSpeed / 1.0 * 3.6), (double)this.createWeighting(this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"road_class == SERVICE", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"))).calcMinWeightPerDistance(), (double)1.0E-6);
    }

    @Test
    public void maxSpeedViolated_bug_2307() {
        EdgeIteratorState motorway = this.graph.edge(0, 1).setDistance(10.0).set(this.roadClassEnc, (Enum)RoadClass.MOTORWAY).set(this.avSpeedEnc, 80.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setDistanceInfluence(Double.valueOf(70.0)).addToSpeed(Statement.If((String)"road_class == MOTORWAY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.7")).addToSpeed(Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"30"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)1.3429, (double)weighting.calcEdgeWeight(motorway, false), (double)1.0E-4);
        Assertions.assertEquals((double)642.8571428571429, (double)weighting.calcEdgeMillis(motorway, false), (double)1.0);
    }

    @Test
    public void bugWithNaNForBarrierEdges() {
        EdgeIteratorState motorway = this.graph.edge(0, 1).setDistance(0.0).set(this.roadClassEnc, (Enum)RoadClass.MOTORWAY).set(this.avSpeedEnc, 80.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).addToPriority(Statement.If((String)"road_class == MOTORWAY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertFalse((boolean)Double.isNaN(weighting.calcEdgeWeight(motorway, false)));
        Assertions.assertTrue((boolean)Double.isInfinite(weighting.calcEdgeWeight(motorway, false)));
    }

    @Test
    public void testMinWeightHasSameUnitAs_getWeight() {
        EdgeIteratorState edge = this.graph.edge(0, 1).set(this.avSpeedEnc, 140.0, 0.0).setDistance(10.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        Weighting weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)(weighting.calcMinWeightPerDistance() * 10.0), (double)weighting.calcEdgeWeight(edge, false), (double)1.0E-8);
    }

    @Test
    public void testWeightWrongHeading() {
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc).setHeadingPenalty(100.0);
        Weighting weighting = this.createWeighting(customModel);
        EdgeIteratorState edge = this.graph.edge(1, 2).set(this.avSpeedEnc, 10.0, 10.0).setDistance(10.0).setWayGeometry(Helper.createPointList((double[])new double[]{51.0, 0.0, 51.0, 1.0}));
        VirtualEdgeIteratorState virtEdge = new VirtualEdgeIteratorState(edge.getEdgeKey(), 99, 5, 6, edge.getDistance(), edge.getFlags(), edge.getKeyValues(), edge.fetchWayGeometry(FetchMode.PILLAR_ONLY), false);
        double time = weighting.calcEdgeWeight((EdgeIteratorState)virtEdge, false);
        virtEdge.setUnfavored(true);
        Assertions.assertEquals((double)(time + 100.0), (double)weighting.calcEdgeWeight((EdgeIteratorState)virtEdge, false), (double)1.0E-8);
        virtEdge.setUnfavored(true);
        Assertions.assertEquals((double)(time + 100.0), (double)weighting.calcEdgeWeight((EdgeIteratorState)virtEdge, true), (double)1.0E-8);
        virtEdge.setUnfavored(false);
        Assertions.assertEquals((double)time, (double)weighting.calcEdgeWeight((EdgeIteratorState)virtEdge, true), (double)1.0E-8);
        virtEdge.setUnfavored(true);
        customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        weighting = this.createWeighting(customModel);
        Assertions.assertEquals((double)(time + 300.0), (double)weighting.calcEdgeWeight((EdgeIteratorState)virtEdge, false), (double)1.0E-8);
    }

    @Test
    public void testSpeed0() {
        EdgeIteratorState edge = this.graph.edge(0, 1).setDistance(10.0);
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        Weighting weighting = this.createWeighting(customModel);
        edge.set(this.avSpeedEnc, 0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)weighting.calcEdgeWeight(edge, false), (double)1.0E-8);
        edge.setDistance(0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)weighting.calcEdgeWeight(edge, false), (double)1.0E-8);
    }

    @Test
    public void testTime() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 2.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = g.edge(0, 1).set((DecimalEncodedValue)speedEnc, 15.0, 10.0).setDistance(100000.0);
        CustomModel customModel = this.createSpeedCustomModel((DecimalEncodedValue)speedEnc);
        CustomWeighting w = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        Assertions.assertEquals((long)22500000L, (long)w.calcEdgeMillis(edge, false));
        Assertions.assertEquals((long)36000000L, (long)w.calcEdgeMillis(edge, true));
    }

    @Test
    public void calcWeightAndTime_withTurnCosts() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).create();
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)new DefaultTurnCostProvider(this.turnRestrictionEnc, (Graph)graph, new TurnCostsConfig(), null), (CustomModel)customModel);
        graph.edge(0, 1).set(this.avSpeedEnc, 60.0, 60.0).setDistance(100.0);
        EdgeIteratorState edge = graph.edge(1, 2).set(this.avSpeedEnc, 60.0, 60.0).setDistance(100.0);
        this.setTurnRestriction((Graph)graph, 0, 1, 2);
        Assertions.assertTrue((boolean)Double.isInfinite(GHUtility.calcWeightWithTurnWeight((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0)));
        Assertions.assertEquals((long)6000L, (long)GHUtility.calcMillisWithTurnMillis((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0));
    }

    @Test
    public void calcWeightAndTime_uTurnCosts() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).create();
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)new DefaultTurnCostProvider(this.turnRestrictionEnc, (Graph)graph, new TurnCostsConfig().setUTurnCosts(40), null), (CustomModel)customModel);
        EdgeIteratorState edge = graph.edge(0, 1).set(this.avSpeedEnc, 60.0, 60.0).setDistance(100.0);
        Assertions.assertEquals((double)46.0, (double)GHUtility.calcWeightWithTurnWeight((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0), (double)1.0E-6);
        Assertions.assertEquals((double)6000.0, (double)GHUtility.calcMillisWithTurnMillis((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0), (double)1.0E-6);
    }

    @Test
    public void calcWeightAndTime_uTurnCostsAndUTurnTimes() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).create();
        CustomModel customModel = this.createSpeedCustomModel(this.avSpeedEnc);
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)new DefaultTurnCostProvider(this.turnRestrictionEnc, (Graph)graph, new TurnCostsConfig().setUTurnCosts(120).setEnableUTurnTimes(true), null), (CustomModel)customModel);
        EdgeIteratorState edge = graph.edge(0, 1).set(this.avSpeedEnc, 60.0, 60.0).setDistance(100.0);
        Assertions.assertEquals((double)126.0, (double)GHUtility.calcWeightWithTurnWeight((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0), (double)1.0E-6);
        Assertions.assertEquals((double)126000.0, (double)GHUtility.calcMillisWithTurnMillis((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)0), (double)1.0E-6);
    }

    @Test
    public void testDestinationTag() {
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)carSpeedEnc).add((EncodedValue)bikeSpeedEnc).add((EncodedValue)RoadAccess.create()).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(1000.0);
        edge.set((DecimalEncodedValue)carSpeedEnc, 60.0);
        edge.set((DecimalEncodedValue)bikeSpeedEnc, 18.0);
        EnumEncodedValue roadAccessEnc = em.getEnumEncodedValue("road_access", RoadAccess.class);
        CustomModel customModel = this.createSpeedCustomModel((DecimalEncodedValue)carSpeedEnc).addToPriority(Statement.If((String)"road_access == DESTINATION", (Statement.Op)Statement.Op.MULTIPLY, (String)".1"));
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        CustomModel bikeCustomModel = this.createSpeedCustomModel((DecimalEncodedValue)bikeSpeedEnc);
        CustomWeighting bikeWeighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)bikeCustomModel);
        edge.set(roadAccessEnc, (Enum)RoadAccess.YES);
        Assertions.assertEquals((double)60.0, (double)weighting.calcEdgeWeight(edge, false), (double)1.0E-6);
        Assertions.assertEquals((double)200.0, (double)bikeWeighting.calcEdgeWeight(edge, false), (double)1.0E-6);
        edge.set(roadAccessEnc, (Enum)RoadAccess.DESTINATION);
        Assertions.assertEquals((double)600.0, (double)weighting.calcEdgeWeight(edge, false), (double)0.1);
        Assertions.assertEquals((double)200.0, (double)bikeWeighting.calcEdgeWeight(edge, false), (double)0.1);
    }

    @Test
    public void testPrivateTag() {
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)carSpeedEnc).add((EncodedValue)bikeSpeedEnc).add((EncodedValue)RoadAccess.create()).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(1000.0);
        edge.set((DecimalEncodedValue)carSpeedEnc, 60.0);
        edge.set((DecimalEncodedValue)bikeSpeedEnc, 18.0);
        EnumEncodedValue roadAccessEnc = em.getEnumEncodedValue("road_access", RoadAccess.class);
        CustomModel customModel = this.createSpeedCustomModel((DecimalEncodedValue)carSpeedEnc).addToPriority(Statement.If((String)"road_access == PRIVATE", (Statement.Op)Statement.Op.MULTIPLY, (String)".1"));
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        customModel = this.createSpeedCustomModel((DecimalEncodedValue)bikeSpeedEnc).addToPriority(Statement.If((String)"road_access == PRIVATE", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8333"));
        CustomWeighting bikeWeighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        edge.set(roadAccessEnc, (Enum)RoadAccess.YES);
        Assertions.assertEquals((double)60.0, (double)weighting.calcEdgeWeight(edge, false), (double)0.01);
        Assertions.assertEquals((double)200.0, (double)bikeWeighting.calcEdgeWeight(edge, false), (double)0.01);
        edge.set(roadAccessEnc, (Enum)RoadAccess.PRIVATE);
        Assertions.assertEquals((double)600.0, (double)weighting.calcEdgeWeight(edge, false), (double)0.01);
        Assertions.assertEquals((double)240.0, (double)bikeWeighting.calcEdgeWeight(edge, false), (double)0.01);
    }
}

