/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.custom.FindMinMax;
import com.graphhopper.util.CustomModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FindMinMaxTest {
    private EncodedValueLookup lookup;

    FindMinMaxTest() {
    }

    @BeforeEach
    void setup() {
        this.lookup = new EncodingManager.Builder().add((EncodedValue)RoadEnvironment.create()).build();
    }

    @Test
    public void testCheck() {
        CustomModel queryModel = new CustomModel();
        queryModel.addToPriority(Statement.If((String)"max_width < 3", (Statement.Op)Statement.Op.MULTIPLY, (String)"10"));
        Assertions.assertEquals((int)1, (int)CustomModel.merge((CustomModel)new CustomModel(), (CustomModel)queryModel).getPriority().size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> FindMinMax.checkLMConstraints((CustomModel)new CustomModel(), (CustomModel)queryModel, (EncodedValueLookup)this.lookup));
    }

    @Test
    public void testFindMax() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100"));
        Assertions.assertEquals((double)100.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)120.0), statements, (EncodedValueLookup)this.lookup).max);
        statements.add(Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"20"));
        Assertions.assertEquals((double)100.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)120.0), statements, (EncodedValueLookup)this.lookup).max);
        statements = new ArrayList();
        statements.add(Statement.If((String)"road_environment == BRIDGE", (Statement.Op)Statement.Op.LIMIT, (String)"85"));
        statements.add(Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"100"));
        Assertions.assertEquals((double)100.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)120.0), statements, (EncodedValueLookup)this.lookup).max);
        statements = new ArrayList();
        statements.add(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"2"));
        statements.add(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"35"));
        Assertions.assertEquals((double)35.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)30.0), statements, (EncodedValueLookup)this.lookup).max);
    }

    @Test
    public void findMax_limitAndMultiply() {
        List<Statement> statements = Arrays.asList(Statement.If((String)"road_class == TERTIARY", (Statement.Op)Statement.Op.LIMIT, (String)"90"), Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"1.0"), Statement.ElseIf((String)"road_class == PRIMARY", (Statement.Op)Statement.Op.LIMIT, (String)"30"), Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"3"));
        Assertions.assertEquals((double)140.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)140.0), statements, (EncodedValueLookup)this.lookup).max);
    }

    @Test
    public void testFindMaxPriority() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"2"));
        Assertions.assertEquals((double)2.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)1.0), statements, (EncodedValueLookup)this.lookup).max);
        ArrayList<Statement> statements2 = new ArrayList<Statement>();
        statements2.add(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        Assertions.assertEquals((double)0.5, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)1.0), statements2, (EncodedValueLookup)this.lookup).max);
        ArrayList<Statement> statements3 = new ArrayList<Statement>();
        statements3.add(Statement.If((String)"road_class == MOTORWAY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        statements3.add(Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"-0.5"));
        IllegalArgumentException m = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FindMinMax.findMinMax((MinMax)new MinMax(1.0, 1.0), (List)statements3, (EncodedValueLookup)this.lookup));
        Assertions.assertTrue((boolean)m.getMessage().startsWith("statement resulted in negative value"));
    }

    @Test
    public void findMax_multipleBlocks() {
        List<Statement> statements = Arrays.asList(Statement.If((String)"road_class == TERTIARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.2"), Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.LIMIT, (String)"25"), Statement.If((String)"road_environment == TUNNEL", (Statement.Op)Statement.Op.LIMIT, (String)"60"), Statement.ElseIf((String)"road_environment == BRIDGE", (Statement.Op)Statement.Op.LIMIT, (String)"50"), Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertEquals((double)120.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)150.0), statements, (EncodedValueLookup)this.lookup).max);
        Assertions.assertEquals((double)80.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)100.0), statements, (EncodedValueLookup)this.lookup).max);
        Assertions.assertEquals((double)60.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)60.0), statements, (EncodedValueLookup)this.lookup).max);
        statements = Arrays.asList(Statement.If((String)"road_environment == TUNNEL", (Statement.Op)Statement.Op.LIMIT, (String)"130"), Statement.ElseIf((String)"road_environment == BRIDGE", (Statement.Op)Statement.Op.LIMIT, (String)"50"), Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertEquals((double)130.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)150.0), statements, (EncodedValueLookup)this.lookup).max);
        statements = Arrays.asList(Statement.If((String)"road_class == TERTIARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.2"), Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.LIMIT, (String)"25"), Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"40"), Statement.If((String)"road_environment == TUNNEL", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"), Statement.ElseIf((String)"road_environment == BRIDGE", (Statement.Op)Statement.Op.LIMIT, (String)"30"));
        Assertions.assertEquals((double)40.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)150.0), statements, (EncodedValueLookup)this.lookup).max);
        Assertions.assertEquals((double)40.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)40.0), statements, (EncodedValueLookup)this.lookup).max);
    }

    @Test
    public void testBlock() {
        List<Statement> statements = Arrays.asList(Statement.If((String)"road_class == TERTIARY", List.of(Statement.If((String)"max_speed > 100", (Statement.Op)Statement.Op.LIMIT, (String)"100"), Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"30"))), Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.LIMIT, (String)"25"), Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertEquals((double)100.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)120.0), statements, (EncodedValueLookup)this.lookup).max);
        statements = Arrays.asList(Statement.If((String)"road_class == TERTIARY", List.of(Statement.If((String)"max_speed > 100", (Statement.Op)Statement.Op.LIMIT, (String)"90"), Statement.Else((Statement.Op)Statement.Op.LIMIT, (String)"30"))), Statement.ElseIf((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.LIMIT, (String)"25"), Statement.Else((Statement.Op)Statement.Op.MULTIPLY, (String)"0.8"));
        Assertions.assertEquals((double)96.0, (double)FindMinMax.findMinMax((MinMax)new MinMax((double)0.0, (double)120.0), statements, (EncodedValueLookup)this.lookup).max);
    }
}

