/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import com.graphhopper.routing.weighting.custom.ValueExpressionVisitor;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ValueExpressionVisitorTest {
    ValueExpressionVisitorTest() {
    }

    @Test
    public void protectUsFromStuff() {
        NameValidator allNamesInvalid = s -> false;
        for (String toParse : Arrays.asList("", "new Object()", "java.lang.Object", "Test.class", "new Object(){}.toString().length", "{ 5}", "{ 5, 7 }", "Object.class", "System.out.println(\"\")", "something.newInstance()", "e.getClass ( )", "edge.getDistance()*7/*test", "edge.getDistance()//*test", "edge . getClass()", "(edge = edge) == edge", ") edge (", "in(area_blup(), edge)", "s -> truevalue")) {
            ParseResult res = ValueExpressionVisitor.parse((String)toParse, (NameValidator)allNamesInvalid);
            Assertions.assertFalse((boolean)res.ok, (String)("should not be simple condition: " + toParse));
            Assertions.assertTrue((res.guessedVariables == null || res.guessedVariables.isEmpty() ? 1 : 0) != 0);
        }
        Assertions.assertFalse((boolean)ValueExpressionVisitor.parse((String)"edge; getClass()", (NameValidator)allNamesInvalid).ok);
    }

    @Test
    public void isValidAndSimpleCondition() {
        ParseResult result = ValueExpressionVisitor.parse((String)"edge == edge", arg -> false);
        Assertions.assertFalse((boolean)result.ok);
        result = ValueExpressionVisitor.parse((String)"Math.sqrt(2)", arg -> false);
        Assertions.assertTrue((boolean)result.ok, (String)result.invalidMessage);
        Assertions.assertTrue((boolean)result.guessedVariables.isEmpty());
        result = ValueExpressionVisitor.parse((String)"Math.sqrt(my_speed)", arg -> arg.equals("my_speed"));
        Assertions.assertTrue((boolean)result.ok, (String)result.invalidMessage);
        Assertions.assertEquals((Object)"[my_speed]", (Object)result.guessedVariables.toString());
        result = ValueExpressionVisitor.parse((String)"edge.getDistance()", arg -> false);
        Assertions.assertFalse((boolean)result.ok);
        result = ValueExpressionVisitor.parse((String)"road_class == PRIMARY", arg -> false);
        Assertions.assertFalse((boolean)result.ok);
        result = ValueExpressionVisitor.parse((String)"toll == Toll.NO", arg -> false);
        Assertions.assertFalse((boolean)result.ok);
        result = ValueExpressionVisitor.parse((String)"priority * 2", s -> s.equals("priority"));
        Assertions.assertTrue((boolean)result.ok, (String)result.invalidMessage);
        Assertions.assertEquals((Object)"[priority]", (Object)result.guessedVariables.toString());
    }

    @Test
    public void testErrors() {
        DecimalEncodedValueImpl prio1 = new DecimalEncodedValueImpl("my_priority", 5, 1.0, false);
        IntEncodedValueImpl prio2 = new IntEncodedValueImpl("my_priority2", 5, -5, false, false);
        EncodingManager lookup = new EncodingManager.Builder().add((EncodedValue)prio1).add((EncodedValue)prio2).build();
        String msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$8((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("'unknown' not available"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$9((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("a single EncodedValue"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$10((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("a single EncodedValue"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$11((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("invalid operation '/'"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$12((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("Currently only a single EncodedValue is allowed on the right-hand side"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$13((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("'unknown' not available"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$14((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("a single EncodedValue"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$15((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("a single EncodedValue"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$16((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("invalid operation '/'"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$17((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertTrue((boolean)msg.contains("Currently only a single EncodedValue is allowed on the right-hand side"), (String)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$18((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertEquals((Object)"'my_prio' not available", (Object)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$19((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertEquals((Object)"illegal expression as it can result in a negative weight: -0.5", (Object)msg);
        msg = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$testErrors$20((EncodedValueLookup)lookup))).getMessage();
        Assertions.assertEquals((Object)"illegal expression as it can result in a negative weight: -my_priority", (Object)msg);
    }

    @Test
    public void runMaxMin() {
        DecimalEncodedValueImpl prio1 = new DecimalEncodedValueImpl("my_priority", 5, 1.0, false);
        IntEncodedValueImpl prio2 = new IntEncodedValueImpl("my_priority2", 5, -5, false, false);
        EncodingManager lookup = new EncodingManager.Builder().add((EncodedValue)prio1).add((EncodedValue)prio2).build();
        this.assertInterval(2.0, 2.0, "2", (EncodedValueLookup)lookup);
        this.assertInterval(0.0, 62.0, "2*my_priority", (EncodedValueLookup)lookup);
        this.assertInterval(-52.0, 10.0, "-2*my_priority2", (EncodedValueLookup)lookup);
    }

    @Test
    public void runVariables() {
        DecimalEncodedValueImpl prio1 = new DecimalEncodedValueImpl("my_priority", 5, 1.0, false);
        IntEncodedValueImpl prio2 = new IntEncodedValueImpl("my_priority2", 5, -5, false, false);
        EncodingManager lookup = new EncodingManager.Builder().add((EncodedValue)prio1).add((EncodedValue)prio2).build();
        Assertions.assertEquals(Set.of(), (Object)ValueExpressionVisitor.findVariables((String)"2", (EncodedValueLookup)lookup));
        Assertions.assertEquals(Set.of("my_priority"), (Object)ValueExpressionVisitor.findVariables((String)"2*my_priority", (EncodedValueLookup)lookup));
        Exception ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> ValueExpressionVisitorTest.lambda$runVariables$21((EncodedValueLookup)lookup));
        Assertions.assertTrue((boolean)ex.getMessage().contains("illegal expression as it can result in a negative weight"));
    }

    void assertInterval(double min, double max, String expression, EncodedValueLookup lookup) {
        MinMax minmax = ValueExpressionVisitor.findMinMax((String)expression, (EncodedValueLookup)lookup);
        Assertions.assertEquals((double)min, (double)minmax.min, (double)0.1, (String)expression);
        Assertions.assertEquals((double)max, (double)minmax.max, (double)0.1, (String)expression);
    }

    private static /* synthetic */ void lambda$runVariables$21(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"-2*my_priority", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$20(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"-my_priority", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$19(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"-0.5", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$18(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"my_prio*my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$17(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"my_priority*my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$16(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"1/my_priority", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$15(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"-my_priority + my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$14(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"my_priority - my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$13(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findVariables((String)"unknown*3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$12(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findMinMax((String)"my_priority*my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$11(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findMinMax((String)"1/my_priority", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$10(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findMinMax((String)"-my_priority + my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$9(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findMinMax((String)"my_priority - my_priority2 * 3", (EncodedValueLookup)lookup);
    }

    private static /* synthetic */ void lambda$testErrors$8(EncodedValueLookup lookup) throws Throwable {
        ValueExpressionVisitor.findMinMax((String)"unknown*3", (EncodedValueLookup)lookup);
    }
}

