/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.search;

import com.carrotsearch.hppc.LongArrayList;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.util.Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class KVStorageTest {
    private static final String location = "./target/edge-kv-storage";

    private KVStorage create() {
        return new KVStorage((Directory)new RAMDirectory(), true).create(1000L);
    }

    Map<String, KVStorage.KValue> createMap(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Cannot create list from " + Arrays.toString(keyValues));
        }
        LinkedHashMap<String, KVStorage.KValue> map = new LinkedHashMap<String, KVStorage.KValue>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put((String)keyValues[i], new KVStorage.KValue(keyValues[i + 1]));
        }
        return map;
    }

    @Test
    public void putSame() {
        KVStorage index = this.create();
        long aPointer = index.add(this.createMap("a", "same name", "b", "same name"));
        Assertions.assertNull((Object)index.get(aPointer, "", false));
        Assertions.assertEquals((Object)"same name", (Object)index.get(aPointer, "a", false));
        Assertions.assertEquals((Object)"same name", (Object)index.get(aPointer, "b", false));
        Assertions.assertNull((Object)index.get(aPointer, "c", false));
        index = this.create();
        aPointer = index.add(this.createMap("a", "a name", "b", "same name"));
        Assertions.assertEquals((Object)"a name", (Object)index.get(aPointer, "a", false));
    }

    @Test
    public void putAB() {
        KVStorage index = this.create();
        long aPointer = index.add(this.createMap("a", "a name", "b", "b name"));
        Assertions.assertNull((Object)index.get(aPointer, "", false));
        Assertions.assertEquals((Object)"a name", (Object)index.get(aPointer, "a", false));
        Assertions.assertEquals((Object)"b name", (Object)index.get(aPointer, "b", false));
    }

    @Test
    public void getForwardBackward() {
        KVStorage index = this.create();
        LinkedHashMap<String, KVStorage.KValue> map = new LinkedHashMap<String, KVStorage.KValue>();
        map.put("keyA", new KVStorage.KValue((Object)"FORWARD", null));
        map.put("keyB", new KVStorage.KValue(null, (Object)"BACKWARD"));
        map.put("keyC", new KVStorage.KValue((Object)"BOTH"));
        map.put("keyD", new KVStorage.KValue((Object)"BOTH1", (Object)"BOTH2"));
        long aPointer = index.add(map);
        Assertions.assertNull((Object)index.get(aPointer, "", false));
        Map deserializedList = index.getAll(aPointer);
        Assertions.assertEquals(map, (Object)deserializedList);
        Assertions.assertEquals((Object)"FORWARD", (Object)index.get(aPointer, "keyA", false));
        Assertions.assertNull((Object)index.get(aPointer, "keyA", true));
        Assertions.assertNull((Object)index.get(aPointer, "keyB", false));
        Assertions.assertEquals((Object)"BACKWARD", (Object)index.get(aPointer, "keyB", true));
        Assertions.assertEquals((Object)"BOTH", (Object)index.get(aPointer, "keyC", false));
        Assertions.assertEquals((Object)"BOTH", (Object)index.get(aPointer, "keyC", true));
        Assertions.assertEquals((Object)"BOTH1", (Object)index.get(aPointer, "keyD", false));
        Assertions.assertEquals((Object)"BOTH2", (Object)index.get(aPointer, "keyD", true));
    }

    @Test
    public void putEmpty() {
        KVStorage index = this.create();
        Assertions.assertEquals((long)1L, (long)index.add(this.createMap("", "")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertEquals((long)5L, (long)index.add(this.createMap("", null))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(this.createMap("blup", null)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(this.createMap(null, null)));
        Assertions.assertNull((Object)index.get(0L, "", false));
        Assertions.assertEquals((long)5L, (long)index.add(this.createMap("else", "else")));
    }

    @Test
    public void putMany() {
        KVStorage index = this.create();
        long aPointer = 0L;
        long tmpPointer = 0L;
        for (int i = 0; i < 10000; ++i) {
            aPointer = index.add(this.createMap("a", "a name " + i, "b", "b name " + i, "c", "c name " + i));
            if (i != 567) continue;
            tmpPointer = aPointer;
        }
        Assertions.assertEquals((Object)"b name 9999", (Object)index.get(aPointer, "b", false));
        Assertions.assertEquals((Object)"c name 9999", (Object)index.get(aPointer, "c", false));
        Assertions.assertEquals((Object)"a name 567", (Object)index.get(tmpPointer, "a", false));
        Assertions.assertEquals((Object)"b name 567", (Object)index.get(tmpPointer, "b", false));
        Assertions.assertEquals((Object)"c name 567", (Object)index.get(tmpPointer, "c", false));
    }

    @Test
    public void putManyKeys() {
        KVStorage index = this.create();
        for (int i = 1; i < 16384; ++i) {
            index.add(this.createMap("a" + i, "a name"));
        }
        try {
            index.add(this.createMap("new", "a name"));
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoErrorOnLargeStringValue() {
        KVStorage index = this.create();
        Object str = "";
        for (int i = 0; i < 127; ++i) {
            str = (String)str + "\u00df";
        }
        Assertions.assertEquals((int)254, (int)((String)str).getBytes(Helper.UTF_CS).length);
        long result = index.add(this.createMap("", str));
        Assertions.assertEquals((int)127, (int)((String)index.get(result, "", false)).length());
    }

    @Test
    public void testTooLongStringValueError() {
        KVStorage index = this.create();
        Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(this.createMap("", "\u0411\u0443\u0445\u0430\u0440\u0435\u0441\u0442\u0441\u043a\u0430\u044f \u0443\u043b\u0438\u0446\u0430 (http://ru.wikipedia.org/wiki/%D0%91%D1%83%D1%85%D0%B0%D1%80%D0%B5%D1%81%D1%82%D1%81%D0%BA%D0%B0%D1%8F_%D1%83%D0%BB%D0%B8%D1%86%D0%B0_(%D0%A1%D0%B0%D0%BD%D0%BA%D1%82-%D0%9F%D0%B5%D1%82%D0%B5%D1%80%D0%B1%D1%83%D1%80%D0%B3))")));
        Object str = "sdfsdfds";
        for (int i = 0; i < 768; ++i) {
            str = (String)str + "\u0411";
        }
        String finalStr = str;
        Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(this.createMap("", finalStr)));
    }

    @Test
    public void testNoErrorOnLargestByteArray() {
        KVStorage index = this.create();
        byte[] bytes = new byte[255];
        byte[] copy = new byte[255];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(i % 255);
            copy[i] = bytes[i];
        }
        long result = index.add(Map.of("myval", new KVStorage.KValue((Object)bytes)));
        bytes = (byte[])index.get(result, "myval", false);
        Assertions.assertArrayEquals((byte[])copy, (byte[])bytes);
        byte[] biggerByteArray = Arrays.copyOf(bytes, 256);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(Map.of("myval2", new KVStorage.KValue((Object)biggerByteArray))));
        Assertions.assertTrue((boolean)e.getMessage().contains("bytes.length cannot be > 255"));
    }

    @Test
    public void testIntLongDoubleFloat() {
        KVStorage index = this.create();
        long intres = index.add(Map.of("intres", new KVStorage.KValue((Object)4)));
        long doubleres = index.add(Map.of("doubleres", new KVStorage.KValue((Object)4.0)));
        long floatres = index.add(Map.of("floatres", new KVStorage.KValue((Object)Float.valueOf(4.0f))));
        long longres = index.add(Map.of("longres", new KVStorage.KValue((Object)4L)));
        long after4Inserts = index.add(Map.of("somenext", new KVStorage.KValue((Object)0)));
        Assertions.assertEquals((long)37L, (long)after4Inserts);
        Assertions.assertEquals((Object)Float.valueOf(4.0f), (Object)index.get(floatres, "floatres", false));
        Assertions.assertEquals((Object)4L, (Object)index.get(longres, "longres", false));
        Assertions.assertEquals((Object)4.0, (Object)index.get(doubleres, "doubleres", false));
        Assertions.assertEquals((Object)4, (Object)index.get(intres, "intres", false));
    }

    @Test
    public void testIntLongDoubleFloat2() {
        KVStorage index = this.create();
        LinkedHashMap<String, KVStorage.KValue> map = new LinkedHashMap<String, KVStorage.KValue>();
        map.put("int", new KVStorage.KValue((Object)4));
        map.put("long", new KVStorage.KValue((Object)4L));
        map.put("double", new KVStorage.KValue((Object)4.0));
        map.put("float", new KVStorage.KValue((Object)Float.valueOf(4.0f)));
        long allInOne = index.add(map);
        long afterMapInsert = index.add(Map.of("somenext", new KVStorage.KValue((Object)0)));
        Assertions.assertEquals((long)34L, (long)afterMapInsert);
        Map resMap = index.getAll(allInOne);
        Assertions.assertEquals((Object)4, (Object)((KVStorage.KValue)resMap.get("int")).getFwd());
        Assertions.assertEquals((Object)4L, (Object)((KVStorage.KValue)resMap.get("long")).getFwd());
        Assertions.assertEquals((Object)4.0, (Object)((KVStorage.KValue)resMap.get("double")).getFwd());
        Assertions.assertEquals((Object)Float.valueOf(4.0f), (Object)((KVStorage.KValue)resMap.get("float")).getFwd());
    }

    @Test
    public void testFlush() {
        Helper.removeDir((File)new File(location));
        KVStorage index = new KVStorage(new RAMDirectory(location, true).create(), true);
        long pointer = index.add(this.createMap("", "test"));
        index.flush();
        index.close();
        index = new KVStorage((Directory)new RAMDirectory(location, true), true);
        Assertions.assertTrue((boolean)index.loadExisting());
        Assertions.assertEquals((Object)"test", (Object)index.get(pointer, "", false));
        long newPointer = index.add(this.createMap("", "testing"));
        Assertions.assertEquals((long)(pointer + 1L + 3L + (long)"test".getBytes().length), (long)newPointer, (String)(newPointer + ">" + pointer));
        index.close();
        Helper.removeDir((File)new File(location));
    }

    @Test
    public void testLoadKeys() {
        Helper.removeDir((File)new File(location));
        KVStorage index = new KVStorage(new RAMDirectory(location, true).create(), true).create(1000L);
        long pointerA = index.add(this.createMap("c", "test value"));
        Assertions.assertEquals((int)2, (int)index.getKeys().size());
        long pointerB = index.add(this.createMap("a", "value", "b", "another value"));
        Assertions.assertEquals((Object)"[, c, a, b]", (Object)index.getKeys().toString());
        index.flush();
        index.close();
        index = new KVStorage((Directory)new RAMDirectory(location, true), true);
        Assertions.assertTrue((boolean)index.loadExisting());
        Assertions.assertEquals((Object)"[, c, a, b]", (Object)index.getKeys().toString());
        Assertions.assertEquals((Object)"test value", (Object)index.get(pointerA, "c", false));
        Assertions.assertNull((Object)index.get(pointerA, "b", false));
        Assertions.assertNull((Object)index.get(pointerB, "", false));
        Assertions.assertEquals((Object)"value", (Object)index.get(pointerB, "a", false));
        Assertions.assertEquals((Object)"another value", (Object)index.get(pointerB, "b", false));
        Assertions.assertEquals((Object)"{a=value, b=another value}", (Object)index.getAll(pointerB).toString());
        index.close();
        Helper.removeDir((File)new File(location));
    }

    @Test
    public void testEmptyKey() {
        KVStorage index = this.create();
        long pointerA = index.add(this.createMap("", "test value"));
        long pointerB = index.add(this.createMap("a", "value", "b", "another value"));
        Assertions.assertEquals((Object)"test value", (Object)index.get(pointerA, "", false));
        Assertions.assertNull((Object)index.get(pointerA, "a", false));
        Assertions.assertEquals((Object)"value", (Object)index.get(pointerB, "a", false));
        Assertions.assertNull((Object)index.get(pointerB, "", false));
    }

    @Test
    public void testDifferentValuePerDirection() {
        LinkedHashMap<String, KVStorage.KValue> map = new LinkedHashMap<String, KVStorage.KValue>();
        map.put("test", new KVStorage.KValue((Object)"forw", (Object)"back"));
        KVStorage index = this.create();
        long pointerA = index.add(map);
        Assertions.assertEquals((Object)"forw", (Object)index.get(pointerA, "test", false));
        Assertions.assertEquals((Object)"back", (Object)index.get(pointerA, "test", true));
    }

    @Test
    public void testSameByteArray() {
        KVStorage index = this.create();
        long pointerA = index.add(this.createMap("mykey", new byte[]{1, 2, 3, 4}));
        long pointerB = index.add(this.createMap("mykey", new byte[]{1, 2, 3, 4}));
        Assertions.assertEquals((long)pointerA, (long)pointerB);
        byte[] sameRef = new byte[]{1, 2, 3, 4};
        pointerA = index.add(this.createMap("mykey", sameRef));
        pointerB = index.add(this.createMap("mykey", sameRef));
        Assertions.assertEquals((long)pointerA, (long)pointerB);
    }

    @Test
    public void testUnknownValueClass() {
        KVStorage index = this.create();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> index.add(this.createMap("mykey", new Object())));
        Assertions.assertTrue((boolean)ex.getMessage().contains("The Class of a value was Object, currently supported"), (String)ex.getMessage());
    }

    @RepeatedTest(value=20)
    public void testRandom() {
        long seed = new Random().nextLong();
        try {
            Object value;
            Map map;
            int i;
            KVStorage index = new KVStorage(new RAMDirectory(location, true).create(), true).create(1000L);
            Random random = new Random(seed);
            List<String> keys = this.createRandomStringList(random, "_key", 100);
            List<Integer> values = this.createRandomMap(random, 500);
            int size = 10000;
            LongArrayList pointers = new LongArrayList(size);
            for (i = 0; i < size; ++i) {
                Map<String, KVStorage.KValue> list = this.createRandomMap(random, keys, values);
                long pointer = index.add(list);
                try {
                    Assertions.assertEquals((int)list.size(), (int)index.getAll(pointer).size(), (String)("" + i));
                }
                catch (Exception ex) {
                    throw new RuntimeException(i + " " + String.valueOf(list) + ", " + pointer, ex);
                }
                pointers.add(pointer);
            }
            for (i = 0; i < size; ++i) {
                map = index.getAll(pointers.get(i));
                Assertions.assertFalse((boolean)map.isEmpty(), (String)(i + " " + String.valueOf(map)));
                for (Map.Entry entry : map.entrySet()) {
                    value = index.get(pointers.get(i), (String)entry.getKey(), false);
                    Assertions.assertEquals((Object)((KVStorage.KValue)entry.getValue()).getFwd(), (Object)value, (String)(i + " " + String.valueOf(map)));
                }
            }
            index.flush();
            index.close();
            index = new KVStorage(new RAMDirectory(location, true).create(), true);
            Assertions.assertTrue((boolean)index.loadExisting());
            for (i = 0; i < size; ++i) {
                map = index.getAll(pointers.get(i));
                Assertions.assertFalse((boolean)map.isEmpty(), (String)(i + " " + String.valueOf(map)));
                for (Map.Entry entry : map.entrySet()) {
                    value = index.get(pointers.get(i), (String)entry.getKey(), false);
                    Assertions.assertEquals((Object)((KVStorage.KValue)entry.getValue()).getFwd(), (Object)value, (String)(i + " " + String.valueOf(map)));
                }
            }
            index.close();
        }
        catch (Throwable t) {
            throw new RuntimeException("KVStorageTest.testRandom seed:" + seed, t);
        }
    }

    private List<Integer> createRandomMap(Random random, int size) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(random.nextInt(size * 5));
        }
        return list;
    }

    private List<String> createRandomStringList(Random random, String postfix, int size) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(random.nextInt(size * 5) + postfix);
        }
        return list;
    }

    private Map<String, KVStorage.KValue> createRandomMap(Random random, List<String> keys, List<Integer> values) {
        int count = random.nextInt(10) + 2;
        HashSet<String> avoidDuplicates = new HashSet<String>();
        LinkedHashMap<String, KVStorage.KValue> list = new LinkedHashMap<String, KVStorage.KValue>();
        for (int i = 0; i < count; ++i) {
            String key = keys.get(random.nextInt(keys.size()));
            if (!avoidDuplicates.add(key)) continue;
            Integer o = values.get(random.nextInt(values.size()));
            list.put(key, new KVStorage.KValue(key.endsWith("_s") ? String.valueOf(o) + "_s" : o));
        }
        return list;
    }

    public void ignoreRandomString() {
        Object s = "";
        long seed = new Random().nextLong();
        Random rand = new Random(seed);
        for (int i = 0; i < 255; ++i) {
            s = (String)s + (char)rand.nextInt();
        }
        Assertions.assertTrue((((String)(s = KVStorage.cutString((String)s))).getBytes(Helper.UTF_CS).length <= 255 ? 1 : 0) != 0, (String)(((String)s).getBytes(Helper.UTF_CS).length + " -> seed " + seed));
    }

    @Test
    public void testCutString() {
        String s = KVStorage.cutString((String)"\u0411\u0443\u0445\u0430\u0440\u0435\u0441\u0442\u0441\u043a\u0430\u044f \u0443\u043b\u0438\u0446\u0430 (http://ru.wikipedia.org/wiki/%D0%91%D1%83%D1%85%D0%B0%D1%80%D0%B5%D1%81%D1%82%D1%81%D0%BA%D0%B0%D1%8F_%D1%83%D0%BB%D0%B8%D1%86%D0%B0_(%D0%A1%D0%B0%D0%BD%D0%BA%D1%82-%D0%9F%D0%B5%D1%82%D0%B5%D1%80%D0%B1%D1%83%D1%80%D0%B3))");
        Assertions.assertEquals((int)250, (int)s.getBytes(Helper.UTF_CS).length);
    }

    @Test
    public void testMax() {
        long pointer = Integer.MAX_VALUE;
        int storedPointer = (int)(pointer + 100L);
        Assertions.assertTrue((storedPointer < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((long)(pointer + 100L), (long)Integer.toUnsignedLong(storedPointer));
    }
}

