/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import java.io.File;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractDirectoryTester {
    protected String location = "./target/tmp/dir";
    private DataAccess da;

    abstract Directory createDir();

    @AfterEach
    public void tearDown() {
        if (this.da != null) {
            this.da.close();
        }
        Helper.removeDir((File)new File(this.location));
    }

    @BeforeEach
    public void setUp() {
        Helper.removeDir((File)new File(this.location));
    }

    @Test
    public void testNoDuplicates() {
        Directory dir = this.createDir();
        DataAccess da1 = dir.create("testing");
        Assertions.assertThrows(IllegalStateException.class, () -> dir.create("testing"));
        da1.close();
    }

    @Test
    public void testNoErrorForDACreate() {
        Directory dir = this.createDir();
        this.da = dir.create("testing");
        this.da.create(100L);
        this.da.flush();
    }
}

