/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.BaseGraphNodesAndEdges;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractGraphStorageTester {
    private final String locationParent = "./target/graphstorage";
    protected int defaultSize = 100;
    protected String defaultGraphLoc = "./target/graphstorage/default";
    protected BooleanEncodedValue carAccessEnc = new SimpleBooleanEncodedValue("car_access", true);
    protected DecimalEncodedValue carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
    protected BooleanEncodedValue footAccessEnc = new SimpleBooleanEncodedValue("foot_access", true);
    protected DecimalEncodedValue footSpeedEnc = new DecimalEncodedValueImpl("foot_speed", 4, 1.0, true);
    protected EncodingManager encodingManager = this.createEncodingManager();
    protected BaseGraph graph;
    EdgeFilter carOutFilter = AccessFilter.outEdges((BooleanEncodedValue)this.carAccessEnc);
    EdgeFilter carInFilter = AccessFilter.inEdges((BooleanEncodedValue)this.carAccessEnc);
    EdgeExplorer carOutExplorer;
    EdgeExplorer carInExplorer;
    EdgeExplorer carAllExplorer;

    protected EncodingManager createEncodingManager() {
        return new EncodingManager.Builder().add((EncodedValue)this.carAccessEnc).add((EncodedValue)this.carSpeedEnc).add((EncodedValue)this.footAccessEnc).add((EncodedValue)this.footSpeedEnc).add((EncodedValue)RoadClass.create()).build();
    }

    public static void assertPList(PointList expected, PointList list) {
        Assertions.assertEquals((int)expected.size(), (int)list.size(), (String)"size of point lists is not equal");
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((double)expected.getLat(i), (double)list.getLat(i), (double)1.0E-5);
            Assertions.assertEquals((double)expected.getLon(i), (double)list.getLon(i), (double)1.0E-5);
        }
    }

    public static int getIdOf(Graph g, double latitude) {
        int s = g.getNodes();
        NodeAccess na = g.getNodeAccess();
        for (int i = 0; i < s; ++i) {
            if (!(Math.abs(na.getLat(i) - latitude) < 1.0E-5)) continue;
            return i;
        }
        return -1;
    }

    public static int getIdOf(Graph g, double latitude, double longitude) {
        int s = g.getNodes();
        NodeAccess na = g.getNodeAccess();
        for (int i = 0; i < s; ++i) {
            if (!(Math.abs(na.getLat(i) - latitude) < 1.0E-5) || !(Math.abs(na.getLon(i) - longitude) < 1.0E-5)) continue;
            return i;
        }
        throw new IllegalArgumentException("did not find node with location " + (float)latitude + "," + (float)longitude);
    }

    protected BaseGraph createGHStorage() {
        BaseGraph g = this.createGHStorage(this.defaultGraphLoc, false);
        this.carOutExplorer = g.createEdgeExplorer(this.carOutFilter);
        this.carInExplorer = g.createEdgeExplorer(this.carInFilter);
        this.carAllExplorer = g.createEdgeExplorer();
        return g;
    }

    abstract BaseGraph createGHStorage(String var1, boolean var2);

    @BeforeEach
    public void setUp() {
        Helper.removeDir((File)new File("./target/graphstorage"));
    }

    @AfterEach
    public void tearDown() {
        Helper.close((Closeable)this.graph);
        Helper.removeDir((File)new File("./target/graphstorage"));
    }

    @Test
    public void testSetTooBigDistance_435() {
        this.graph = this.createGHStorage();
        double maxDist = BaseGraphNodesAndEdges.MAX_DIST;
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(maxDist);
        Assertions.assertEquals((double)maxDist, (double)edge1.getDistance(), (double)1.0);
        EdgeIteratorState edge2 = this.graph.edge(0, 2).setDistance(maxDist + 1.0);
        Assertions.assertEquals((double)maxDist, (double)edge2.getDistance(), (double)1.0);
    }

    @Test
    public void testSetNodes() {
        this.graph = this.createGHStorage();
        NodeAccess na = this.graph.getNodeAccess();
        for (int i = 0; i < this.defaultSize * 2; ++i) {
            na.setNode(i, (double)(2 * i), (double)(3 * i));
        }
        this.graph.edge(this.defaultSize + 1, this.defaultSize + 2).setDistance(10.0);
        this.graph.edge(this.defaultSize + 1, this.defaultSize + 3).setDistance(10.0);
        Assertions.assertEquals((int)2, (int)this.getCountAll(this.defaultSize + 1));
    }

    @Test
    public void testPropertiesWithNoInit() {
        this.graph = this.createGHStorage();
        Assertions.assertEquals((int)0, (int)this.graph.edge((int)0, (int)1).getFlags().ints[0]);
        Assertions.assertEquals((double)0.0, (double)this.graph.edge(0, 2).getDistance(), (double)1.0E-6);
    }

    @Test
    public void testCreateLocation() {
        this.graph = this.createGHStorage();
        this.graph.edge(3, 1).setDistance(50.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)1, (int)this.getCountOut(1));
        this.graph.edge(1, 2).setDistance(100.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)2, (int)this.getCountOut(1));
    }

    @Test
    public void testEdges() {
        this.graph = this.createGHStorage();
        this.graph.edge(2, 1).setDistance(12.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)1, (int)this.getCountOut(2));
        this.graph.edge(2, 3).setDistance(12.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)1, (int)this.getCountOut(1));
        Assertions.assertEquals((int)2, (int)this.getCountOut(2));
        Assertions.assertEquals((int)1, (int)this.getCountOut(3));
    }

    @Test
    public void testUnidirectional() {
        this.graph = this.createGHStorage();
        this.graph.edge(1, 2).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(1, 11).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(11, 1).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(1, 12).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 2).setDistance(112.0).set(this.carAccessEnc, true, false);
        EdgeIterator i = this.carOutExplorer.setBaseNode(2);
        Assertions.assertFalse((boolean)i.next());
        Assertions.assertEquals((int)1, (int)this.getCountIn(1));
        Assertions.assertEquals((int)2, (int)this.getCountIn(2));
        Assertions.assertEquals((int)0, (int)this.getCountIn(3));
        Assertions.assertEquals((int)3, (int)this.getCountOut(1));
        Assertions.assertEquals((int)0, (int)this.getCountOut(2));
        Assertions.assertEquals((int)1, (int)this.getCountOut(3));
        i = this.carOutExplorer.setBaseNode(3);
        i.next();
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        i = this.carOutExplorer.setBaseNode(1);
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)12, (int)i.getAdjNode());
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)11, (int)i.getAdjNode());
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        Assertions.assertFalse((boolean)i.next());
    }

    @Test
    public void testUnidirectionalEdgeFilter() {
        this.graph = this.createGHStorage();
        this.graph.edge(1, 2).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(1, 11).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(11, 1).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(1, 12).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 2).setDistance(112.0).set(this.carAccessEnc, true, false);
        EdgeIterator i = this.carOutExplorer.setBaseNode(2);
        Assertions.assertFalse((boolean)i.next());
        Assertions.assertEquals((int)4, (int)this.getCountAll(1));
        Assertions.assertEquals((int)1, (int)this.getCountIn(1));
        Assertions.assertEquals((int)2, (int)this.getCountIn(2));
        Assertions.assertEquals((int)0, (int)this.getCountIn(3));
        Assertions.assertEquals((int)3, (int)this.getCountOut(1));
        Assertions.assertEquals((int)0, (int)this.getCountOut(2));
        Assertions.assertEquals((int)1, (int)this.getCountOut(3));
        i = this.carOutExplorer.setBaseNode(3);
        i.next();
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        i = this.carOutExplorer.setBaseNode(1);
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)12, (int)i.getAdjNode());
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)11, (int)i.getAdjNode());
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        Assertions.assertFalse((boolean)i.next());
    }

    @Test
    public void testUpdateUnidirectional() {
        this.graph = this.createGHStorage();
        this.graph.edge(1, 2).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 2).setDistance(112.0).set(this.carAccessEnc, true, false);
        EdgeIterator i = this.carOutExplorer.setBaseNode(2);
        Assertions.assertFalse((boolean)i.next());
        i = this.carOutExplorer.setBaseNode(3);
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        Assertions.assertFalse((boolean)i.next());
        this.graph.edge(2, 3).setDistance(112.0).set(this.carAccessEnc, true, false);
        i = this.carOutExplorer.setBaseNode(2);
        Assertions.assertTrue((boolean)i.next());
        Assertions.assertEquals((int)3, (int)i.getAdjNode());
        i = this.carOutExplorer.setBaseNode(3);
        i.next();
        Assertions.assertEquals((int)2, (int)i.getAdjNode());
        Assertions.assertFalse((boolean)i.next());
    }

    @Test
    public void testCopyProperties() {
        this.graph = this.createGHStorage();
        EdgeIteratorState edge = this.graph.edge(1, 3).setDistance(10.0).set(this.carAccessEnc, true, false).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"testing"))).setWayGeometry(Helper.createPointList((double[])new double[]{1.0, 2.0}));
        EdgeIteratorState newEdge = this.graph.edge(1, 3).setDistance(10.0).set(this.carAccessEnc, true, false);
        newEdge.copyPropertiesFrom(edge);
        Assertions.assertEquals((Object)edge.getName(), (Object)newEdge.getName());
        Assertions.assertEquals((double)edge.getDistance(), (double)newEdge.getDistance(), (double)1.0E-7);
        Assertions.assertEquals((Object)edge.getFlags(), (Object)newEdge.getFlags());
        Assertions.assertEquals((Object)edge.fetchWayGeometry(FetchMode.PILLAR_ONLY), (Object)newEdge.fetchWayGeometry(FetchMode.PILLAR_ONLY));
    }

    @Test
    public void testGetLocations() {
        this.graph = this.createGHStorage();
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 12.0, 23.0);
        na.setNode(1, 22.0, 23.0);
        Assertions.assertEquals((int)2, (int)this.graph.getNodes());
        this.graph.edge(0, 1).setDistance(10.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)2, (int)this.graph.getNodes());
        this.graph.edge(0, 2).setDistance(10.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)3, (int)this.graph.getNodes());
        Helper.close((Closeable)this.graph);
        this.graph = this.createGHStorage();
        Assertions.assertEquals((int)0, (int)this.graph.getNodes());
    }

    @Test
    public void testAddLocation() {
        this.graph = this.createGHStorage();
        this.initExampleGraph((Graph)this.graph);
        this.checkExampleGraph((Graph)this.graph);
    }

    protected void initExampleGraph(Graph g) {
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 12.0, 23.0);
        na.setNode(1, (double)38.33f, (double)135.3f);
        na.setNode(2, 6.0, 139.0);
        na.setNode(3, 78.0, 89.0);
        na.setNode(4, 2.0, 1.0);
        na.setNode(5, 7.0, 5.0);
        g.edge(0, 1).setDistance(12.0).set(this.carAccessEnc, true, true);
        g.edge(0, 2).setDistance(212.0).set(this.carAccessEnc, true, true);
        g.edge(0, 3).setDistance(212.0).set(this.carAccessEnc, true, true);
        g.edge(0, 4).setDistance(212.0).set(this.carAccessEnc, true, true);
        g.edge(0, 5).setDistance(212.0).set(this.carAccessEnc, true, true);
    }

    private void checkExampleGraph(Graph graph) {
        NodeAccess na = graph.getNodeAccess();
        Assertions.assertEquals((double)12.0, (double)na.getLat(0), (double)1.0E-6);
        Assertions.assertEquals((double)23.0, (double)na.getLon(0), (double)1.0E-6);
        Assertions.assertEquals((double)38.33f, (double)na.getLat(1), (double)1.0E-6);
        Assertions.assertEquals((double)135.3f, (double)na.getLon(1), (double)1.0E-6);
        Assertions.assertEquals((double)6.0, (double)na.getLat(2), (double)1.0E-6);
        Assertions.assertEquals((double)139.0, (double)na.getLon(2), (double)1.0E-6);
        Assertions.assertEquals((double)78.0, (double)na.getLat(3), (double)1.0E-6);
        Assertions.assertEquals((double)89.0, (double)na.getLon(3), (double)1.0E-6);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(1)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{5, 4, 3, 2, 1}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(0)));
        try {
            Assertions.assertEquals((int)0, (int)this.getCountOut(6));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDirectional() {
        this.graph = this.createGHStorage();
        this.graph.edge(1, 2).setDistance(12.0).set(this.carAccessEnc, true, true);
        this.graph.edge(2, 3).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 4).setDistance(12.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 5).setDistance(12.0).set(this.carAccessEnc, true, true);
        this.graph.edge(6, 3).setDistance(12.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)1, (int)this.getCountAll(1));
        Assertions.assertEquals((int)1, (int)this.getCountIn(1));
        Assertions.assertEquals((int)1, (int)this.getCountOut(1));
        Assertions.assertEquals((int)2, (int)this.getCountAll(2));
        Assertions.assertEquals((int)1, (int)this.getCountIn(2));
        Assertions.assertEquals((int)2, (int)this.getCountOut(2));
        Assertions.assertEquals((int)4, (int)this.getCountAll(3));
        Assertions.assertEquals((int)3, (int)this.getCountIn(3));
        Assertions.assertEquals((int)2, (int)this.getCountOut(3));
        Assertions.assertEquals((int)1, (int)this.getCountAll(4));
        Assertions.assertEquals((int)1, (int)this.getCountIn(4));
        Assertions.assertEquals((int)0, (int)this.getCountOut(4));
        Assertions.assertEquals((int)1, (int)this.getCountAll(5));
        Assertions.assertEquals((int)1, (int)this.getCountIn(5));
        Assertions.assertEquals((int)1, (int)this.getCountOut(5));
    }

    @Test
    public void testDozendEdges() {
        this.graph = this.createGHStorage();
        this.graph.edge(1, 2).setDistance(12.0).set(this.carAccessEnc, true, true);
        int nn = 1;
        Assertions.assertEquals((int)1, (int)this.getCountAll(nn));
        this.graph.edge(1, 3).setDistance(13.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)2, (int)this.getCountAll(1));
        this.graph.edge(1, 4).setDistance(14.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)3, (int)this.getCountAll(1));
        this.graph.edge(1, 5).setDistance(15.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)4, (int)this.getCountAll(1));
        this.graph.edge(1, 6).setDistance(16.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)5, (int)this.getCountAll(1));
        this.graph.edge(1, 7).setDistance(16.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)6, (int)this.getCountAll(1));
        this.graph.edge(1, 8).setDistance(16.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)7, (int)this.getCountAll(1));
        this.graph.edge(1, 9).setDistance(16.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)8, (int)this.getCountAll(1));
        Assertions.assertEquals((int)8, (int)this.getCountOut(1));
        Assertions.assertEquals((int)1, (int)this.getCountIn(1));
        Assertions.assertEquals((int)1, (int)this.getCountIn(2));
    }

    @Test
    public void testCheckFirstNode() {
        this.graph = this.createGHStorage();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getCountAll(1));
        this.graph.getNodeAccess().setNode(1, 0.0, 0.0);
        Assertions.assertEquals((int)0, (int)this.getCountAll(1));
        this.graph.edge(0, 1).setDistance(12.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)1, (int)this.getCountAll(1));
    }

    @Test
    public void testBounds() {
        this.graph = this.createGHStorage();
        BBox b = this.graph.getBounds();
        Assertions.assertEquals((double)BBox.createInverse((boolean)false).maxLat, (double)b.maxLat, (double)1.0E-6);
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 10.0, 20.0);
        Assertions.assertEquals((double)10.0, (double)b.maxLat, (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)b.maxLon, (double)1.0E-6);
        na.setNode(0, 15.0, -15.0);
        Assertions.assertEquals((double)15.0, (double)b.maxLat, (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)b.maxLon, (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)b.minLat, (double)1.0E-6);
        Assertions.assertEquals((double)-15.0, (double)b.minLon, (double)1.0E-6);
    }

    @Test
    public void testFlags() {
        this.graph = this.createGHStorage();
        this.graph.edge(0, 1).set(this.carAccessEnc, true, true).setDistance(10.0).set(this.carSpeedEnc, 100.0);
        this.graph.edge(2, 3).set(this.carAccessEnc, true, false).setDistance(10.0).set(this.carSpeedEnc, 10.0);
        EdgeIterator iter = this.carAllExplorer.setBaseNode(0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((double)100.0, (double)iter.get(this.carSpeedEnc), (double)1.0);
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
        iter = this.carAllExplorer.setBaseNode(2);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((double)10.0, (double)iter.get(this.carSpeedEnc), (double)1.0);
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)iter.getReverse(this.carAccessEnc));
        try {
            this.graph.edge(0, 1).setDistance(-1.0);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeProperties() {
        this.graph = this.createGHStorage();
        EdgeIteratorState iter1 = this.graph.edge(0, 1).setDistance(10.0).set(this.carAccessEnc, true, true);
        EdgeIteratorState iter2 = this.graph.edge(0, 2).setDistance(20.0).set(this.carAccessEnc, true, true);
        int edgeId = iter1.getEdge();
        EdgeIteratorState iter = this.graph.getEdgeIteratorState(edgeId, 0);
        Assertions.assertEquals((double)10.0, (double)iter.getDistance(), (double)1.0E-5);
        edgeId = iter2.getEdge();
        iter = this.graph.getEdgeIteratorState(edgeId, 0);
        Assertions.assertEquals((int)2, (int)iter.getBaseNode());
        Assertions.assertEquals((int)0, (int)iter.getAdjNode());
        Assertions.assertEquals((double)20.0, (double)iter.getDistance(), (double)1.0E-5);
        iter = this.graph.getEdgeIteratorState(edgeId, 2);
        Assertions.assertEquals((int)0, (int)iter.getBaseNode());
        Assertions.assertEquals((int)2, (int)iter.getAdjNode());
        Assertions.assertEquals((double)20.0, (double)iter.getDistance(), (double)1.0E-5);
        iter = this.graph.getEdgeIteratorState(edgeId, Integer.MIN_VALUE);
        Assertions.assertNotNull((Object)iter);
        Assertions.assertEquals((int)0, (int)iter.getBaseNode());
        Assertions.assertEquals((int)2, (int)iter.getAdjNode());
        iter = this.graph.getEdgeIteratorState(edgeId, 1);
        Assertions.assertNull((Object)iter);
    }

    @Test
    public void testCreateDuplicateEdges() {
        this.graph = this.createGHStorage();
        this.graph.edge(2, 1).setDistance(12.0).set(this.carAccessEnc, true, true);
        this.graph.edge(2, 3).setDistance(12.0).set(this.carAccessEnc, true, true);
        this.graph.edge(2, 3).setDistance(13.0).set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)3, (int)this.getCountOut(2));
        this.graph.getEdgeIteratorState(1, 3);
        try {
            this.graph.getEdgeIteratorState(4, 3);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.graph.getEdgeIteratorState(-1, 3);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        EdgeIterator iter = this.carOutExplorer.setBaseNode(2);
        Assertions.assertTrue((boolean)iter.next());
        EdgeIteratorState oneIter = this.graph.getEdgeIteratorState(iter.getEdge(), 3);
        Assertions.assertEquals((double)13.0, (double)oneIter.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((int)2, (int)oneIter.getBaseNode());
        Assertions.assertTrue((boolean)oneIter.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)oneIter.getReverse(this.carAccessEnc));
        oneIter = this.graph.getEdgeIteratorState(iter.getEdge(), 2);
        Assertions.assertEquals((double)13.0, (double)oneIter.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((int)3, (int)oneIter.getBaseNode());
        Assertions.assertFalse((boolean)oneIter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)oneIter.getReverse(this.carAccessEnc));
        this.graph.edge(3, 2).setDistance(14.0).set(this.carAccessEnc, true, true);
        Assertions.assertEquals((int)4, (int)this.getCountOut(2));
    }

    @Test
    public void testEdgeReturn() {
        this.graph = this.createGHStorage();
        EdgeIteratorState iter = this.graph.edge(4, 10).setDistance(100.0);
        iter.set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)4, (int)iter.getBaseNode());
        Assertions.assertEquals((int)10, (int)iter.getAdjNode());
        iter = this.graph.edge(14, 10).setDistance(100.0);
        iter.set(this.carAccessEnc, true, false);
        Assertions.assertEquals((int)14, (int)iter.getBaseNode());
        Assertions.assertEquals((int)10, (int)iter.getAdjNode());
    }

    @Test
    public void testPillarNodes() {
        this.graph = this.createGHStorage();
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 0.01, 0.01);
        na.setNode(4, 0.4, 0.4);
        na.setNode(14, 0.14, 0.14);
        na.setNode(10, 0.99, 0.99);
        PointList pointList = Helper.createPointList((double[])new double[]{1.0, 1.0, 1.0, 2.0, 1.0, 3.0});
        EdgeIteratorState edge = this.graph.edge(0, 4).setDistance(100.0).setWayGeometry(pointList);
        edge.set(this.carAccessEnc, true, false);
        pointList = Helper.createPointList((double[])new double[]{1.0, 5.0, 1.0, 6.0, 1.0, 7.0, 1.0, 8.0, 1.0, 9.0});
        edge = this.graph.edge(4, 10).setDistance(100.0).setWayGeometry(pointList);
        edge.set(this.carAccessEnc, true, false);
        pointList = Helper.createPointList((double[])new double[]{1.0, 13.0, 1.0, 12.0, 1.0, 11.0});
        edge = this.graph.edge(14, 0).setDistance(100.0).setWayGeometry(pointList);
        edge.set(this.carAccessEnc, true, false);
        EdgeIterator iter = this.carAllExplorer.setBaseNode(0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)14, (int)iter.getAdjNode());
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 11.0, 1.0, 12.0, 1.0, 13.0}), iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.01, 0.01, 1.0, 11.0, 1.0, 12.0, 1.0, 13.0}), iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 11.0, 1.0, 12.0, 1.0, 13.0, 0.14, 0.14}), iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.01, 0.01, 1.0, 11.0, 1.0, 12.0, 1.0, 13.0, 0.14, 0.14}), iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)4, (int)iter.getAdjNode());
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 1.0, 1.0, 2.0, 1.0, 3.0}), iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.01, 0.01, 1.0, 1.0, 1.0, 2.0, 1.0, 3.0}), iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 1.0, 1.0, 2.0, 1.0, 3.0, 0.4, 0.4}), iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.01, 0.01, 1.0, 1.0, 1.0, 2.0, 1.0, 3.0, 0.4, 0.4}), iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertFalse((boolean)iter.next());
        iter = this.carOutExplorer.setBaseNode(0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)4, (int)iter.getAdjNode());
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 1.0, 1.0, 2.0, 1.0, 3.0}), iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertFalse((boolean)iter.next());
        iter = this.carInExplorer.setBaseNode(10);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)4, (int)iter.getAdjNode());
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 9.0, 1.0, 8.0, 1.0, 7.0, 1.0, 6.0, 1.0, 5.0}), iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.99, 0.99, 1.0, 9.0, 1.0, 8.0, 1.0, 7.0, 1.0, 6.0, 1.0, 5.0}), iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{1.0, 9.0, 1.0, 8.0, 1.0, 7.0, 1.0, 6.0, 1.0, 5.0, 0.4, 0.4}), iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ));
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.99, 0.99, 1.0, 9.0, 1.0, 8.0, 1.0, 7.0, 1.0, 6.0, 1.0, 5.0, 0.4, 0.4}), iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void testFootMix() {
        this.graph = this.createGHStorage();
        this.graph.edge(0, 1).setDistance(10.0).set(this.footAccessEnc, true, true);
        this.graph.edge(0, 2).setDistance(10.0).set(this.carAccessEnc, true, true);
        EdgeIteratorState edge = this.graph.edge(0, 3).setDistance(10.0);
        edge.set(this.footAccessEnc, true, true);
        edge.set(this.carAccessEnc, true, true);
        EdgeExplorer footOutExplorer = this.graph.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)this.footAccessEnc));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{3, 1}), (Object)GHUtility.getNeighbors((EdgeIterator)footOutExplorer.setBaseNode(0)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{3, 2}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(0)));
    }

    @Test
    public void testGetAllEdges() {
        this.graph = this.createGHStorage();
        this.graph.edge(0, 1).setDistance(2.0).set(this.carAccessEnc, true, true);
        this.graph.edge(3, 1).setDistance(1.0).set(this.carAccessEnc, true, false);
        this.graph.edge(3, 2).setDistance(1.0).set(this.carAccessEnc, true, false);
        AllEdgesIterator iter = this.graph.getAllEdges();
        Assertions.assertTrue((boolean)iter.next());
        int edgeId = iter.getEdge();
        Assertions.assertEquals((int)0, (int)iter.getBaseNode());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((double)2.0, (double)iter.getDistance(), (double)1.0E-6);
        Assertions.assertTrue((boolean)iter.next());
        int edgeId2 = iter.getEdge();
        Assertions.assertEquals((int)1, (int)(edgeId2 - edgeId));
        Assertions.assertEquals((int)3, (int)iter.getBaseNode());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)3, (int)iter.getBaseNode());
        Assertions.assertEquals((int)2, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void testKVStorage() {
        this.graph = this.createGHStorage();
        EdgeIteratorState iter1 = this.graph.edge(0, 1).setDistance(10.0).set(this.carAccessEnc, true, true);
        iter1.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street1")));
        EdgeIteratorState iter2 = this.graph.edge(0, 1).setDistance(10.0).set(this.carAccessEnc, true, true);
        iter2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street2")));
        Assertions.assertEquals((Object)this.graph.getEdgeIteratorState(iter1.getEdge(), iter1.getAdjNode()).getName(), (Object)"named street1");
        Assertions.assertEquals((Object)this.graph.getEdgeIteratorState(iter2.getEdge(), iter2.getAdjNode()).getName(), (Object)"named street2");
    }

    @Test
    public void test8AndMoreBytesForEdgeFlags() {
        SimpleBooleanEncodedValue access0Enc = new SimpleBooleanEncodedValue("car0_access", true);
        DecimalEncodedValueImpl speed0Enc = new DecimalEncodedValueImpl("car0_speed", 29, 0.001, false);
        SimpleBooleanEncodedValue access1Enc = new SimpleBooleanEncodedValue("car1_access", true);
        DecimalEncodedValueImpl speed1Enc = new DecimalEncodedValueImpl("car1_speed", 29, 0.001, false);
        EncodingManager manager = EncodingManager.start().add((EncodedValue)access0Enc).add((EncodedValue)speed0Enc).add((EncodedValue)access1Enc).add((EncodedValue)speed1Enc).build();
        this.graph = new BaseGraph.Builder(manager).create();
        EdgeIteratorState edge = this.graph.edge(0, 1);
        IntsRef intsRef = manager.createEdgeFlags();
        intsRef.ints[0] = 0x2AAAAAAA;
        edge.setFlags(intsRef);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)intsRef.ints[0]);
        this.graph.close();
        this.graph = new BaseGraph.Builder(manager).create();
        edge = this.graph.edge(0, 1);
        GHUtility.setSpeed((double)99.123, (boolean)true, (boolean)true, (BooleanEncodedValue)access0Enc, (DecimalEncodedValue)speed0Enc, (EdgeIteratorState)edge);
        Assertions.assertEquals((double)99.123, (double)edge.get((DecimalEncodedValue)speed0Enc), (double)0.001);
        EdgeIteratorState edgeIter = GHUtility.getEdge((Graph)this.graph, (int)1, (int)0);
        Assertions.assertEquals((double)99.123, (double)edgeIter.get((DecimalEncodedValue)speed0Enc), (double)0.001);
        Assertions.assertTrue((boolean)edgeIter.get((BooleanEncodedValue)access0Enc));
        Assertions.assertTrue((boolean)edgeIter.getReverse((BooleanEncodedValue)access0Enc));
        edge = this.graph.edge(2, 3);
        GHUtility.setSpeed((double)44.123, (boolean)true, (boolean)false, (BooleanEncodedValue)access1Enc, (DecimalEncodedValue)speed1Enc, (EdgeIteratorState)edge);
        Assertions.assertEquals((double)44.123, (double)edge.get((DecimalEncodedValue)speed1Enc), (double)0.001);
        edgeIter = GHUtility.getEdge((Graph)this.graph, (int)3, (int)2);
        Assertions.assertEquals((double)44.123, (double)edgeIter.get((DecimalEncodedValue)speed1Enc), (double)0.001);
        Assertions.assertEquals((double)44.123, (double)edgeIter.getReverse((DecimalEncodedValue)speed1Enc), (double)0.001);
        Assertions.assertFalse((boolean)edgeIter.get((BooleanEncodedValue)access1Enc));
        Assertions.assertTrue((boolean)edgeIter.getReverse((BooleanEncodedValue)access1Enc));
        manager = EncodingManager.start().add((EncodedValue)new SimpleBooleanEncodedValue("car0_access", true)).add((EncodedValue)new DecimalEncodedValueImpl("car0_speed", 29, 0.001, false)).add((EncodedValue)new SimpleBooleanEncodedValue("car1_access", true)).add((EncodedValue)new DecimalEncodedValueImpl("car1_speed", 29, 0.001, false)).add((EncodedValue)new SimpleBooleanEncodedValue("car2_access", true)).add((EncodedValue)new DecimalEncodedValueImpl("car2_speed", 30, 0.001, false)).build();
        this.graph = new BaseGraph.Builder(manager).create();
        edgeIter = this.graph.edge(0, 1).set((BooleanEncodedValue)access0Enc, true, false);
        Assertions.assertTrue((boolean)edgeIter.get((BooleanEncodedValue)access0Enc));
        Assertions.assertFalse((boolean)edgeIter.getReverse((BooleanEncodedValue)access0Enc));
    }

    @Test
    public void testEnabledElevation() {
        this.graph = this.createGHStorage(this.defaultGraphLoc, true);
        NodeAccess na = this.graph.getNodeAccess();
        Assertions.assertTrue((boolean)na.is3D());
        na.setNode(0, 10.0, 20.0, -10.0);
        na.setNode(1, 11.0, 2.0, 100.0);
        Assertions.assertEquals((double)-10.0, (double)na.getEle(0), (double)0.1);
        Assertions.assertEquals((double)100.0, (double)na.getEle(1), (double)0.1);
        this.graph.edge(0, 1).setWayGeometry(Helper.createPointList3D((double[])new double[]{10.0, 27.0, 72.0, 11.0, 20.0, 1.0}));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{10.0, 27.0, 72.0, 11.0, 20.0, 1.0}), (Object)GHUtility.getEdge((Graph)this.graph, (int)0, (int)1).fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{10.0, 20.0, -10.0, 10.0, 27.0, 72.0, 11.0, 20.0, 1.0, 11.0, 2.0, 100.0}), (Object)GHUtility.getEdge((Graph)this.graph, (int)0, (int)1).fetchWayGeometry(FetchMode.ALL));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{11.0, 2.0, 100.0, 11.0, 20.0, 1.0, 10.0, 27.0, 72.0, 10.0, 20.0, -10.0}), (Object)GHUtility.getEdge((Graph)this.graph, (int)1, (int)0).fetchWayGeometry(FetchMode.ALL));
    }

    @Test
    public void testDontGrowOnUpdate() {
        this.graph = this.createGHStorage(this.defaultGraphLoc, true);
        NodeAccess na = this.graph.getNodeAccess();
        Assertions.assertTrue((boolean)na.is3D());
        na.setNode(0, 10.0, 10.0, 0.0);
        na.setNode(1, 11.0, 20.0, 1.0);
        na.setNode(2, 12.0, 12.0, 0.4);
        EdgeIteratorState iter2 = this.graph.edge(0, 1).setDistance(100.0).set(this.carAccessEnc, true, true);
        BaseGraph baseGraph = this.graph.getBaseGraph();
        Assertions.assertEquals((long)1L, (long)baseGraph.getMaxGeoRef());
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0}));
        Assertions.assertEquals((long)48L, (long)baseGraph.getMaxGeoRef());
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0}));
        Assertions.assertEquals((long)48L, (long)baseGraph.getMaxGeoRef());
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.0, 2.0, 3.0, 3.0, 4.0, 5.0}));
        Assertions.assertEquals((long)48L, (long)baseGraph.getMaxGeoRef());
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.0, 2.0, 3.0}));
        Assertions.assertEquals((long)48L, (long)baseGraph.getMaxGeoRef());
        Assertions.assertThrows(IllegalStateException.class, () -> iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0})));
        Assertions.assertEquals((long)48L, (long)baseGraph.getMaxGeoRef());
        EdgeIteratorState iter1 = this.graph.edge(0, 2).setDistance(200.0).set(this.carAccessEnc, true, true);
        iter1.setWayGeometry(Helper.createPointList3D((double[])new double[]{3.5, 4.5, 0.0, 5.0, 6.0, 0.0}));
        Assertions.assertEquals((long)73L, (long)baseGraph.getMaxGeoRef());
    }

    @Test
    public void testDetachEdge() {
        this.graph = this.createGHStorage();
        this.graph.edge(0, 1).setDistance(2.0).set(this.carAccessEnc, true, true);
        this.graph.edge(0, 2).setDistance(2.0).set(this.carAccessEnc, true, true).setWayGeometry(Helper.createPointList((double[])new double[]{1.0, 2.0, 3.0, 4.0})).set(this.carAccessEnc, true, false);
        this.graph.edge(1, 2).setDistance(2.0).set(this.carAccessEnc, true, true);
        EdgeIterator iter = this.graph.createEdgeExplorer().setBaseNode(0);
        try {
            iter.detach(false);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        iter.next();
        EdgeIteratorState edgeState02 = iter.detach(false);
        Assertions.assertEquals((int)2, (int)iter.getAdjNode());
        Assertions.assertEquals((double)1.0, (double)edgeState02.fetchWayGeometry(FetchMode.PILLAR_ONLY).getLat(0), (double)0.1);
        Assertions.assertEquals((int)2, (int)edgeState02.getAdjNode());
        Assertions.assertTrue((boolean)edgeState02.get(this.carAccessEnc));
        EdgeIteratorState edgeState20 = iter.detach(true);
        Assertions.assertEquals((int)0, (int)edgeState20.getAdjNode());
        Assertions.assertEquals((int)2, (int)edgeState20.getBaseNode());
        Assertions.assertEquals((double)3.0, (double)edgeState20.fetchWayGeometry(FetchMode.PILLAR_ONLY).getLat(0), (double)0.1);
        Assertions.assertFalse((boolean)edgeState20.get(this.carAccessEnc));
        Assertions.assertEquals((Object)GHUtility.getEdge((Graph)this.graph, (int)0, (int)2).getFlags(), (Object)edgeState02.getFlags());
        Assertions.assertEquals((Object)GHUtility.getEdge((Graph)this.graph, (int)2, (int)0).getFlags(), (Object)edgeState20.getFlags());
        iter.next();
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((int)2, (int)edgeState02.getAdjNode());
        Assertions.assertEquals((int)2, (int)edgeState20.getBaseNode());
        Assertions.assertEquals((int)0, (int)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size());
        Assertions.assertEquals((double)1.0, (double)edgeState02.fetchWayGeometry(FetchMode.PILLAR_ONLY).getLat(0), (double)0.1);
        Assertions.assertEquals((double)3.0, (double)edgeState20.fetchWayGeometry(FetchMode.PILLAR_ONLY).getLat(0), (double)0.1);
    }

    private int getCountOut(int node) {
        return GHUtility.count((EdgeIterator)this.carOutExplorer.setBaseNode(node));
    }

    private int getCountIn(int node) {
        return GHUtility.count((EdgeIterator)this.carInExplorer.setBaseNode(node));
    }

    private int getCountAll(int node) {
        return GHUtility.count((EdgeIterator)this.carAllExplorer.setBaseNode(node));
    }
}

