/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import java.io.File;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractLockFactoryTester {
    protected final File lockDir = new File("./target/lockingtest/");

    protected abstract LockFactory createLockFactory();

    @BeforeEach
    public void setUp() {
        this.lockDir.mkdirs();
    }

    @AfterEach
    public void tearDown() {
        Helper.removeDir((File)this.lockDir);
    }

    @Test
    public void testObtain() {
        LockFactory instance = this.createLockFactory();
        instance.setLockDir(this.lockDir);
        GHLock lock = instance.create("test", true);
        Assertions.assertTrue((boolean)lock.tryLock());
        Assertions.assertTrue((boolean)lock.isLocked());
        Assertions.assertFalse((boolean)lock.tryLock());
        Assertions.assertTrue((boolean)lock.isLocked());
        GHLock lock2 = instance.create("test", true);
        Assertions.assertFalse((boolean)lock2.tryLock());
        Assertions.assertTrue((boolean)lock2.isLocked());
        lock.release();
        Assertions.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testForceDelete() {
        LockFactory instance = this.createLockFactory();
        instance.setLockDir(this.lockDir);
        GHLock lock = instance.create("testlock", true);
        Assertions.assertTrue((boolean)lock.tryLock());
        Assertions.assertTrue((boolean)lock.isLocked());
        if (Constants.WINDOWS) {
            lock.release();
        }
        instance.forceRemove(lock.getName(), true);
        Assertions.assertFalse((boolean)lock.isLocked());
    }
}

