/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.AbstractGraphStorageTester;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.BaseGraphNodesAndEdges;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class BaseGraphTest
extends AbstractGraphStorageTester {
    @Override
    public BaseGraph createGHStorage(String location, boolean enabled3D) {
        BaseGraph gs = this.newGHStorage((Directory)new RAMDirectory(location), enabled3D, this.defaultSize / 2);
        gs.create((long)this.defaultSize);
        return gs;
    }

    protected BaseGraph newGHStorage(Directory dir, boolean enabled3D) {
        return this.newGHStorage(dir, enabled3D, -1);
    }

    protected BaseGraph newGHStorage(Directory dir, boolean enabled3D, int segmentSize) {
        return new BaseGraph.Builder(this.encodingManager).setDir(dir).set3D(enabled3D).setSegmentSize(segmentSize).build();
    }

    @Test
    public void testSave_and_fileFormat() {
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, true), true).create((long)this.defaultSize);
        NodeAccess na = this.graph.getNodeAccess();
        Assertions.assertTrue((boolean)na.is3D());
        na.setNode(0, 10.0, 10.0, 0.0);
        na.setNode(1, 11.0, 20.0, 1.0);
        na.setNode(2, 12.0, 12.0, 0.4);
        EdgeIteratorState iter2 = this.graph.edge(0, 1).setDistance(100.0).set(this.carAccessEnc, true, true);
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0}));
        EdgeIteratorState iter1 = this.graph.edge(0, 2).setDistance(200.0).set(this.carAccessEnc, true, true);
        EdgeIteratorState iter3 = this.graph.edge(3, 4);
        iter1.setWayGeometry(Helper.createPointList3D((double[])new double[]{3.5, 4.5, 0.0, 5.0, 6.0, 0.0}));
        this.graph.edge(9, 10).setDistance(200.0).set(this.carAccessEnc, true, true);
        this.graph.edge(9, 11).setDistance(200.0).set(this.carAccessEnc, true, true);
        this.graph.edge(1, 2).setDistance(120.0).set(this.carAccessEnc, true, false);
        iter1.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street1")));
        iter2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street2")));
        LinkedHashMap<String, KVStorage.KValue> map = new LinkedHashMap<String, KVStorage.KValue>();
        map.put("keyA", new KVStorage.KValue((Object)"FORWARD", null));
        map.put("keyB", new KVStorage.KValue(null, (Object)"BACKWARD"));
        map.put("keyC", new KVStorage.KValue((Object)"BOTH"));
        map.put("keyD", new KVStorage.KValue((Object)"BOTH2", (Object)"BOTH2"));
        iter3.setKeyValues(map);
        this.checkGraph((Graph)this.graph);
        this.graph.flush();
        this.graph.close();
        this.graph = this.newGHStorage((Directory)new MMapDirectory(this.defaultGraphLoc), true);
        this.graph.loadExisting();
        Assertions.assertEquals((int)12, (int)this.graph.getNodes());
        this.checkGraph((Graph)this.graph);
        Assertions.assertEquals((Object)"named street1", (Object)this.graph.getEdgeIteratorState(iter1.getEdge(), iter1.getAdjNode()).getName());
        Assertions.assertEquals((Object)"named street2", (Object)this.graph.getEdgeIteratorState(iter2.getEdge(), iter2.getAdjNode()).getName());
        iter3 = this.graph.getEdgeIteratorState(iter3.getEdge(), iter3.getAdjNode());
        Assertions.assertEquals(map, (Object)iter3.getKeyValues());
        Assertions.assertEquals(map, (Object)iter3.detach(true).getKeyValues());
        Assertions.assertEquals((Object)"FORWARD", (Object)iter3.getValue("keyA"));
        Assertions.assertNull((Object)iter3.getValue("keyB"));
        Assertions.assertEquals((Object)"BOTH", (Object)iter3.getValue("keyC"));
        Assertions.assertNull((Object)iter3.detach(true).getValue("keyA"));
        Assertions.assertEquals((Object)"BACKWARD", (Object)iter3.detach(true).getValue("keyB"));
        Assertions.assertEquals((Object)"BOTH", (Object)iter3.detach(true).getValue("keyC"));
        Assertions.assertEquals((Object)"BOTH2", (Object)iter3.getValue("keyD"));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.carAccessEnc, (DecimalEncodedValue)this.carSpeedEnc, (EdgeIteratorState)this.graph.edge(3, 4).setDistance(123.0)).setWayGeometry(Helper.createPointList3D((double[])new double[]{4.4, 5.5, 0.0, 6.6, 7.7, 0.0}));
        this.checkGraph((Graph)this.graph);
    }

    @Test
    public void testSave_and_Freeze() {
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, true), true).create((long)this.defaultSize);
        this.graph.edge(1, 0);
        this.graph.freeze();
        this.graph.flush();
        this.graph.close();
        this.graph = this.newGHStorage((Directory)new MMapDirectory(this.defaultGraphLoc), true);
        this.graph.loadExisting();
        Assertions.assertEquals((int)2, (int)this.graph.getNodes());
        Assertions.assertTrue((boolean)this.graph.isFrozen());
    }

    protected void checkGraph(Graph g) {
        NodeAccess na = g.getNodeAccess();
        Assertions.assertTrue((boolean)na.is3D());
        Assertions.assertTrue((boolean)g.getBounds().isValid());
        Assertions.assertEquals((Object)new BBox(10.0, 20.0, 10.0, 12.0, 0.0, 1.0), (Object)g.getBounds());
        Assertions.assertEquals((double)10.0, (double)na.getLat(0), (double)0.01);
        Assertions.assertEquals((double)10.0, (double)na.getLon(0), (double)0.01);
        EdgeExplorer explorer = g.createEdgeExplorer(this.carOutFilter);
        Assertions.assertEquals((int)2, (int)GHUtility.count((EdgeIterator)explorer.setBaseNode(0)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{2, 1}), (Object)GHUtility.getNeighbors((EdgeIterator)explorer.setBaseNode(0)));
        EdgeIterator iter = explorer.setBaseNode(0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{3.5, 4.5, 0.0, 5.0, 6.0, 0.0}), (Object)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0}), (Object)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{10.0, 10.0, 0.0, 1.5, 1.0, 0.0, 2.0, 3.0, 0.0}), (Object)iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0, 11.0, 20.0, 1.0}), (Object)iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{10.0, 10.0, 0.0, 11.0, 20.0, 1.0}), (Object)iter.fetchWayGeometry(FetchMode.TOWER_ONLY));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{11.0, 20.0, 1.0, 10.0, 10.0, 0.0}), (Object)iter.detach(true).fetchWayGeometry(FetchMode.TOWER_ONLY));
        Assertions.assertEquals((double)11.0, (double)na.getLat(1), (double)0.01);
        Assertions.assertEquals((double)20.0, (double)na.getLon(1), (double)0.01);
        Assertions.assertEquals((int)2, (int)GHUtility.count((EdgeIterator)explorer.setBaseNode(1)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{2, 0}), (Object)GHUtility.getNeighbors((EdgeIterator)explorer.setBaseNode(1)));
        Assertions.assertEquals((double)12.0, (double)na.getLat(2), (double)0.01);
        Assertions.assertEquals((double)12.0, (double)na.getLon(2), (double)0.01);
        Assertions.assertEquals((int)1, (int)GHUtility.count((EdgeIterator)explorer.setBaseNode(2)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0}), (Object)GHUtility.getNeighbors((EdgeIterator)explorer.setBaseNode(2)));
        EdgeIteratorState eib = GHUtility.getEdge((Graph)g, (int)1, (int)2);
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[0]), (Object)eib.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{11.0, 20.0, 1.0}), (Object)eib.fetchWayGeometry(FetchMode.BASE_AND_PILLAR));
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{12.0, 12.0, 0.4}), (Object)eib.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0}), (Object)GHUtility.getNeighbors((EdgeIterator)explorer.setBaseNode(2)));
    }

    @Test
    public void testDoThrowExceptionIfDimDoesNotMatch() {
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, true), false);
        this.graph.create(1000L);
        this.graph.flush();
        this.graph.close();
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, true), true);
        Assertions.assertThrows(Exception.class, () -> this.graph.loadExisting());
    }

    @Test
    public void testIdentical() {
        BaseGraph store = new BaseGraph.Builder(this.encodingManager).set3D(true).build();
        Assertions.assertEquals((int)store.getNodes(), (int)store.getBaseGraph().getNodes());
        Assertions.assertEquals((int)store.getEdges(), (int)store.getBaseGraph().getEdges());
    }

    @Test
    public void testMultipleDecoupledEdges() {
        BaseGraph graph = this.createGHStorage();
        graph.edge(0, 1).setDistance(10.0).set(this.carAccessEnc, true, true);
        graph.edge(1, 2).setDistance(10.0).set(this.carAccessEnc, true, true);
        EdgeIteratorState edge0 = graph.getEdgeIteratorState(0, Integer.MIN_VALUE);
        EdgeIteratorState edge1 = graph.getEdgeIteratorState(1, Integer.MIN_VALUE);
        edge0.set(this.carAccessEnc, true, false);
        edge1.set(this.carAccessEnc, false, true);
        Assertions.assertFalse((boolean)edge1.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)edge1.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)edge0.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)edge0.getReverse(this.carAccessEnc));
    }

    @Test
    public void testInternalReverse() {
        BaseGraph storage = this.createGHStorage();
        EdgeIteratorState edge = storage.edge(1, 2);
        Assertions.assertFalse((boolean)edge.get(EdgeIteratorState.REVERSE_STATE));
        Assertions.assertTrue((boolean)edge.getReverse(EdgeIteratorState.REVERSE_STATE));
        edge = storage.getEdgeIteratorState(edge.getEdge(), Integer.MIN_VALUE);
        Assertions.assertFalse((boolean)edge.get(EdgeIteratorState.REVERSE_STATE));
        edge = storage.getEdgeIteratorState(edge.getEdge(), 1);
        Assertions.assertTrue((boolean)edge.get(EdgeIteratorState.REVERSE_STATE));
        Assertions.assertFalse((boolean)edge.getReverse(EdgeIteratorState.REVERSE_STATE));
    }

    @Test
    public void testDecoupledEdgeIteratorStates() {
        BaseGraph storage = this.createGHStorage();
        BaseGraph graph = storage.getBaseGraph();
        IntsRef ref = this.encodingManager.createEdgeFlags();
        ref.ints[0] = 12;
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.carAccessEnc, (DecimalEncodedValue)this.carSpeedEnc, (EdgeIteratorState)graph.edge(1, 2).setDistance(10.0)).setFlags(ref);
        ref.ints[0] = 13;
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.carAccessEnc, (DecimalEncodedValue)this.carSpeedEnc, (EdgeIteratorState)graph.edge(1, 3).setDistance(10.0)).setFlags(ref);
        EdgeIterator iter = graph.createEdgeExplorer().setBaseNode(1);
        Assertions.assertTrue((boolean)iter.next());
        EdgeIteratorState edge1 = iter.detach(false);
        Assertions.assertTrue((boolean)iter.next());
        ref.ints[0] = 44;
        iter.setFlags(ref);
        Assertions.assertEquals((int)44, (int)iter.getFlags().ints[0]);
        Assertions.assertEquals((int)13, (int)edge1.getFlags().ints[0]);
    }

    @Test
    public void testEdgeKey() {
        BaseGraph g = new BaseGraph.Builder(this.encodingManager).create();
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.carAccessEnc, (DecimalEncodedValue)this.carSpeedEnc, (EdgeIteratorState)g.edge(0, 1).setDistance(10.0));
        this.assertEdge(g.getEdgeIteratorState(0, Integer.MIN_VALUE), 0, 1, false, 0, 0);
        this.assertEdge(g.getEdgeIteratorState(0, 0), 1, 0, true, 0, 1);
        this.assertEdge(g.getEdgeIteratorStateForKey(0), 0, 1, false, 0, 0);
        this.assertEdge(g.getEdgeIteratorStateForKey(1), 1, 0, true, 0, 1);
    }

    private void assertEdge(EdgeIteratorState edge, int base, int adj, boolean reverse, int edgeId, int key) {
        Assertions.assertEquals((int)base, (int)edge.getBaseNode());
        Assertions.assertEquals((int)adj, (int)edge.getAdjNode());
        Assertions.assertEquals((Object)reverse, (Object)edge.get(EdgeIteratorState.REVERSE_STATE));
        Assertions.assertEquals((int)edgeId, (int)edge.getEdge());
        Assertions.assertEquals((int)key, (int)edge.getEdgeKey());
    }

    @Test
    public void outOfBounds() {
        BaseGraph graph = this.createGHStorage();
        Assertions.assertThrows(IllegalArgumentException.class, () -> graph.getEdgeIteratorState(0, Integer.MIN_VALUE));
    }

    @Test
    public void setGetFlagsRaw() {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        EdgeIteratorState edge = graph.edge(0, 1);
        IntsRef flags = this.encodingManager.createEdgeFlags();
        flags.ints[0] = 10;
        edge.setFlags(flags);
        Assertions.assertEquals((int)10, (int)edge.getFlags().ints[0]);
        flags.ints[0] = 9;
        edge.setFlags(flags);
        Assertions.assertEquals((int)9, (int)edge.getFlags().ints[0]);
    }

    @Test
    public void setGetFlags() {
        BaseGraph graph = this.createGHStorage();
        EnumEncodedValue rcEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        EdgeIteratorState edge = graph.edge(0, 1).set(rcEnc, (Enum)RoadClass.BRIDLEWAY);
        Assertions.assertEquals((Object)RoadClass.BRIDLEWAY, (Object)edge.get(rcEnc));
        edge.set(rcEnc, (Enum)RoadClass.CORRIDOR);
        Assertions.assertEquals((Object)RoadClass.CORRIDOR, (Object)edge.get(rcEnc));
    }

    @Test
    public void copyEdge() {
        BaseGraph graph = this.createGHStorage();
        EnumEncodedValue rcEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        EdgeIteratorState edge1 = graph.edge(3, 5).set(rcEnc, (Enum)RoadClass.LIVING_STREET);
        EdgeIteratorState edge2 = graph.edge(3, 5).set(rcEnc, (Enum)RoadClass.MOTORWAY);
        EdgeIteratorState edge3 = graph.copyEdge(edge1.getEdge(), true);
        EdgeIteratorState edge4 = graph.copyEdge(edge1.getEdge(), false);
        Assertions.assertEquals((Object)RoadClass.LIVING_STREET, (Object)edge1.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.MOTORWAY, (Object)edge2.get(rcEnc));
        Assertions.assertEquals((Object)edge1.get(rcEnc), (Object)edge3.get(rcEnc));
        Assertions.assertEquals((Object)edge1.get(rcEnc), (Object)edge4.get(rcEnc));
        graph.forEdgeAndCopiesOfEdge(graph.createEdgeExplorer(), edge1, e -> e.set(rcEnc, (Enum)RoadClass.FOOTWAY));
        Assertions.assertEquals((Object)RoadClass.FOOTWAY, (Object)edge1.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.FOOTWAY, (Object)edge3.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.LIVING_STREET, (Object)edge4.get(rcEnc));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void copyEdge_multiple(boolean withGeometries) {
        BaseGraph graph = this.createGHStorage();
        EnumEncodedValue rcEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        EdgeIteratorState edge1 = graph.edge(1, 2).set(rcEnc, (Enum)RoadClass.FOOTWAY);
        EdgeIteratorState edge2 = graph.edge(1, 3).set(rcEnc, (Enum)RoadClass.MOTORWAY);
        EdgeIteratorState edge3 = graph.edge(1, 4).set(rcEnc, (Enum)RoadClass.CYCLEWAY);
        if (withGeometries) {
            edge1.setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0}));
            edge2.setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 1.0, 2.0, 3.0, 5.0}));
            edge3.setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 2.0, 2.0, 3.0, 6.0}));
        }
        EdgeIteratorState edge4 = graph.copyEdge(edge1.getEdge(), true);
        EdgeIteratorState edge5 = graph.copyEdge(edge3.getEdge(), true);
        EdgeIteratorState edge6 = graph.copyEdge(edge3.getEdge(), true);
        EdgeExplorer explorer = graph.createEdgeExplorer();
        graph.forEdgeAndCopiesOfEdge(explorer, edge1, e -> e.set(rcEnc, (Enum)RoadClass.PATH));
        Assertions.assertEquals((Object)RoadClass.PATH, (Object)edge1.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.CYCLEWAY, (Object)edge3.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.PATH, (Object)edge4.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.CYCLEWAY, (Object)edge5.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.CYCLEWAY, (Object)edge6.get(rcEnc));
        graph.forEdgeAndCopiesOfEdge(explorer, edge6, e -> e.set(rcEnc, (Enum)RoadClass.OTHER));
        Assertions.assertEquals((Object)RoadClass.PATH, (Object)edge1.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)edge3.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.PATH, (Object)edge4.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)edge5.get(rcEnc));
        Assertions.assertEquals((Object)RoadClass.OTHER, (Object)edge6.get(rcEnc));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void forEdgeAndCopiesOfEdge_noCopyNoGeo(boolean withGeometries) {
        BaseGraph graph = this.createGHStorage();
        EdgeIteratorState edge1 = graph.edge(0, 1);
        EdgeIteratorState edge2 = graph.edge(1, 2);
        if (withGeometries) {
            edge1.setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0}));
            edge2.setWayGeometry(Helper.createPointList((double[])new double[]{3.0, 0.0, 4.0, 5.0, 4.5, 5.5}));
        }
        IntArrayList edges = new IntArrayList();
        graph.forEdgeAndCopiesOfEdge(graph.createEdgeExplorer(), edge2, e -> edges.add(e.getEdge()));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{edge2.getEdge()}), (Object)edges);
        edges.clear();
        EdgeIteratorState edge3 = graph.copyEdge(edge2.getEdge(), true);
        graph.forEdgeAndCopiesOfEdge(graph.createEdgeExplorer(), edge2, e -> edges.add(e.getEdge()));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{edge3.getEdge(), edge2.getEdge()}), (Object)edges);
    }

    @Test
    public void copyEdge_changeGeometry() {
        BaseGraph graph = this.createGHStorage();
        EnumEncodedValue rcEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        EdgeIteratorState edge1 = graph.edge(1, 2).set(rcEnc, (Enum)RoadClass.FOOTWAY);
        EdgeIteratorState edge2 = graph.edge(1, 3).set(rcEnc, (Enum)RoadClass.FOOTWAY).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 1.0, 2.0, 3.0}));
        EdgeIteratorState edge3 = graph.edge(1, 4).set(rcEnc, (Enum)RoadClass.FOOTWAY).setWayGeometry(Helper.createPointList((double[])new double[]{4.0, 5.0, 6.0, 7.0}));
        EdgeIteratorState edge4 = graph.copyEdge(edge1.getEdge(), true);
        EdgeIteratorState edge5 = graph.copyEdge(edge3.getEdge(), true);
        Assertions.assertThrows(IllegalStateException.class, () -> graph.getEdgeIteratorState(edge1.getEdge(), Integer.MIN_VALUE).setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 5.0, 4.0})));
        graph.getEdgeIteratorState(edge2.getEdge(), Integer.MIN_VALUE).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 3.0, 4.0, 5.0}));
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> graph.getEdgeIteratorState(edge2.getEdge(), Integer.MIN_VALUE).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0})));
        Assertions.assertTrue((boolean)e.getMessage().contains("This edge already has a way geometry so it cannot be changed to a bigger geometry"), (String)e.getMessage());
        graph.getEdgeIteratorState(edge3.getEdge(), Integer.MIN_VALUE).setWayGeometry(Helper.createPointList((double[])new double[]{6.0, 7.0, 8.0, 9.0}));
        e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> graph.getEdgeIteratorState(edge3.getEdge(), Integer.MIN_VALUE).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 1.0, 6.0, 7.0, 8.0, 9.0})));
        Assertions.assertTrue((boolean)e.getMessage().contains("This edge already has a way geometry so it cannot be changed to a bigger geometry"), (String)e.getMessage());
    }

    @Test
    public void testGeoRef() {
        BaseGraph graph = this.createGHStorage();
        BaseGraphNodesAndEdges ne = graph.getStore();
        ne.setGeoRef(0L, 123L);
        Assertions.assertEquals((long)123L, (long)ne.getGeoRef(0L));
        ne.setGeoRef(0L, -123L);
        Assertions.assertEquals((long)-123L, (long)ne.getGeoRef(0L));
        ne.setGeoRef(0L, 0x4000000000L);
        Assertions.assertEquals((long)0x4000000000L, (long)ne.getGeoRef(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ne.setGeoRef(0L, 0x8000000000L));
        graph.close();
    }
}

