/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.BaseGraphTest;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.Map;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BaseGraphWithTurnCostsTest
extends BaseGraphTest {
    private DecimalEncodedValue turnCostEnc;

    @Override
    protected EncodingManager createEncodingManager() {
        this.turnCostEnc = TurnCost.create((String)"car", (int)1400);
        return EncodingManager.start().add((EncodedValue)this.carAccessEnc).add((EncodedValue)this.carSpeedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).add((EncodedValue)this.footAccessEnc).add((EncodedValue)this.footSpeedEnc).add((EncodedValue)RoadClass.create()).build();
    }

    @Override
    protected BaseGraph newGHStorage(Directory dir, boolean is3D) {
        return this.newGHStorage(dir, is3D, -1);
    }

    @Override
    protected BaseGraph newGHStorage(Directory dir, boolean enabled3D, int segmentSize) {
        return new BaseGraph.Builder(this.encodingManager).setDir(dir).set3D(enabled3D).withTurnCosts(true).setSegmentSize(segmentSize).build();
    }

    @Override
    @Test
    public void testSave_and_fileFormat() {
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, true), true).create((long)this.defaultSize);
        NodeAccess na = this.graph.getNodeAccess();
        Assertions.assertTrue((boolean)na.is3D());
        na.setNode(0, 10.0, 10.0, 0.0);
        na.setNode(1, 11.0, 20.0, 1.0);
        na.setNode(2, 12.0, 12.0, 0.4);
        EdgeIteratorState iter2 = this.graph.edge(0, 1).setDistance(100.0).set(this.carAccessEnc, true, true);
        iter2.setWayGeometry(Helper.createPointList3D((double[])new double[]{1.5, 1.0, 0.0, 2.0, 3.0, 0.0}));
        EdgeIteratorState iter1 = this.graph.edge(0, 2).setDistance(200.0).set(this.carAccessEnc, true, true);
        iter1.setWayGeometry(Helper.createPointList3D((double[])new double[]{3.5, 4.5, 0.0, 5.0, 6.0, 0.0}));
        this.graph.edge(9, 10).setDistance(200.0).set(this.carAccessEnc, true, true);
        this.graph.edge(9, 11).setDistance(200.0).set(this.carAccessEnc, true, true);
        this.graph.edge(1, 2).setDistance(120.0).set(this.carAccessEnc, true, false);
        this.setTurnCost(iter1.getEdge(), 0, iter2.getEdge(), 1337);
        this.setTurnCost(iter2.getEdge(), 0, iter1.getEdge(), 666);
        this.setTurnCost(iter1.getEdge(), 1, iter2.getEdge(), 815);
        iter1.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street1")));
        iter2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"named street2")));
        this.checkGraph((Graph)this.graph);
        this.graph.flush();
        this.graph.close();
        this.graph = this.newGHStorage((Directory)new MMapDirectory(this.defaultGraphLoc), true);
        this.graph.loadExisting();
        Assertions.assertEquals((int)12, (int)this.graph.getNodes());
        this.checkGraph((Graph)this.graph);
        Assertions.assertEquals((Object)"named street1", (Object)this.graph.getEdgeIteratorState(iter1.getEdge(), iter1.getAdjNode()).getName());
        Assertions.assertEquals((Object)"named street2", (Object)this.graph.getEdgeIteratorState(iter2.getEdge(), iter2.getAdjNode()).getName());
        Assertions.assertEquals((double)1337.0, (double)this.getTurnCost(iter2, 0, iter1), (double)0.1);
        Assertions.assertEquals((double)666.0, (double)this.getTurnCost(iter1, 0, iter2), (double)0.1);
        Assertions.assertEquals((double)815.0, (double)this.getTurnCost(iter2, 1, iter1), (double)0.1);
        Assertions.assertEquals((double)0.0, (double)this.getTurnCost(iter2, 3, iter1), (double)0.1);
        this.graph.edge(3, 4).setDistance(123.0).set(this.carAccessEnc, true, true).setWayGeometry(Helper.createPointList3D((double[])new double[]{4.4, 5.5, 0.0, 6.6, 7.7, 0.0}));
        this.checkGraph((Graph)this.graph);
    }

    @Test
    public void testEnsureCapacity() {
        int nodeId;
        this.graph = this.newGHStorage((Directory)new MMapDirectory(this.defaultGraphLoc), false, 128);
        this.graph.create(100L);
        TurnCostStorage turnCostStorage = this.graph.getTurnCostStorage();
        Assertions.assertEquals((long)128L, (long)turnCostStorage.getCapacity());
        Random r = new Random();
        NodeAccess na = this.graph.getNodeAccess();
        for (int i = 0; i < 100; ++i) {
            double randomLat = 90.0 * r.nextDouble();
            double randomLon = 180.0 * r.nextDouble();
            na.setNode(i, randomLat, randomLon);
        }
        for (nodeId = 51; nodeId < 100; ++nodeId) {
            this.graph.edge(50, nodeId).setDistance(r.nextDouble()).set(this.carAccessEnc, true, true);
        }
        for (nodeId = 0; nodeId < 50; ++nodeId) {
            this.graph.edge(nodeId, 50).setDistance(r.nextDouble()).set(this.carAccessEnc, true, true);
        }
        for (int edgeId = 0; edgeId < 52; ++edgeId) {
            this.setTurnCost(edgeId, 50, edgeId + 50, 1337);
            this.setTurnCost(edgeId + 50, 50, edgeId, 1337);
        }
        Assertions.assertEquals((long)104L, (long)(turnCostStorage.getCapacity() / 16L));
        this.setTurnCost(0, 50, 2, 1337);
        Assertions.assertEquals((long)112L, (long)(turnCostStorage.getCapacity() / 16L));
    }

    @Test
    public void testInitializeTurnCost() {
        this.graph = this.newGHStorage((Directory)new RAMDirectory(this.defaultGraphLoc, false), true).create((long)this.defaultSize);
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(4001, 10.0, 11.0, 10.0);
        Assertions.assertEquals((int)-1, (int)na.getTurnCostIndex(4001));
        na.setNode(4000, 10.0, 11.0, 10.0);
        na.setTurnCostIndex(4000, 12);
        na.setNode(4000, 10.0, 11.0, 11.0);
        Assertions.assertEquals((int)12, (int)na.getTurnCostIndex(4000));
    }

    private double getTurnCost(EdgeIteratorState fromEdge, int viaNode, EdgeIteratorState toEdge) {
        return this.graph.getTurnCostStorage().get(this.turnCostEnc, toEdge.getEdge(), viaNode, fromEdge.getEdge());
    }

    private void setTurnCost(int fromEdge, int viaNode, int toEdge, int cost) {
        this.graph.getTurnCostStorage().set(this.turnCostEnc, fromEdge, viaNode, toEdge, (double)cost);
    }
}

