/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.RAMIntDataAccess;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class CHStorageTest {
    CHStorageTest() {
    }

    @Test
    void setAndGetLevels() {
        RAMDirectory dir = new RAMDirectory();
        CHStorage store = new CHStorage((Directory)dir, "ch1", -1, false);
        store.create(30, 5);
        Assertions.assertEquals((int)0, (int)store.getLevel(store.toNodePointer(10)));
        store.setLevel(store.toNodePointer(10), 100);
        Assertions.assertEquals((int)100, (int)store.getLevel(store.toNodePointer(10)));
        store.setLevel(store.toNodePointer(29), 300);
        Assertions.assertEquals((int)300, (int)store.getLevel(store.toNodePointer(29)));
    }

    @Test
    void createAndLoad(@TempDir Path path) {
        GHDirectory dir = new GHDirectory(path.toAbsolutePath().toString(), DAType.RAM_INT_STORE);
        CHStorage chStorage = new CHStorage((Directory)dir, "car", -1, false);
        chStorage.create(5, 3);
        Assertions.assertEquals((int)0, (int)chStorage.shortcutNodeBased(0, 1, PrepareEncoder.getScFwdDir(), 10.0, 3, 5));
        Assertions.assertEquals((int)1, (int)chStorage.shortcutNodeBased(1, 2, PrepareEncoder.getScFwdDir(), 11.0, 4, 6));
        Assertions.assertEquals((int)2, (int)chStorage.shortcutNodeBased(2, 3, PrepareEncoder.getScFwdDir(), 12.0, 5, 7));
        Assertions.assertEquals((int)3, (int)chStorage.shortcutNodeBased(3, 4, PrepareEncoder.getScFwdDir(), 13.0, 6, 8));
        Assertions.assertEquals((int)5, (int)chStorage.getNodes());
        Assertions.assertEquals((int)4, (int)chStorage.getShortcuts());
        chStorage.flush();
        chStorage.close();
        dir = new GHDirectory(path.toAbsolutePath().toString(), DAType.RAM_INT_STORE);
        chStorage = new CHStorage((Directory)dir, "car", -1, false);
        chStorage.loadExisting();
        Assertions.assertEquals((int)4, (int)chStorage.getShortcuts());
        Assertions.assertEquals((int)5, (int)chStorage.getNodes());
        long ptr = chStorage.toShortcutPointer(0);
        Assertions.assertEquals((int)0, (int)chStorage.getNodeA(ptr));
        Assertions.assertEquals((int)1, (int)chStorage.getNodeB(ptr));
        Assertions.assertEquals((double)10.0, (double)chStorage.getWeight(ptr));
        Assertions.assertEquals((int)3, (int)chStorage.getSkippedEdge1(ptr));
        Assertions.assertEquals((int)5, (int)chStorage.getSkippedEdge2(ptr));
    }

    @Test
    public void testBigWeight() {
        CHStorage g = new CHStorage((Directory)new RAMDirectory(), "abc", 1024, false);
        g.shortcutNodeBased(0, 0, 0, 10.0, 0, 1);
        g.setWeight(0L, 2148483.647);
        Assertions.assertEquals((double)2148483.647, (double)g.getWeight(0L));
        g.setWeight(0L, 4294967.293);
        Assertions.assertEquals((double)4294967.293, (double)g.getWeight(0L), (double)0.001);
        g.setWeight(0L, 4294967.294);
        Assertions.assertTrue((boolean)Double.isInfinite(g.getWeight(0L)));
        g.setWeight(0L, 4294968.294);
        Assertions.assertTrue((boolean)Double.isInfinite(g.getWeight(0L)));
        g.setWeight(0L, 4295067.294);
        Assertions.assertTrue((boolean)Double.isInfinite(g.getWeight(0L)));
    }

    @Test
    public void testLargeNodeA() {
        int nodeA = Integer.MAX_VALUE;
        RAMIntDataAccess access = new RAMIntDataAccess("", "", false, -1);
        access.create(1000L);
        access.setInt(0L, nodeA << 1 | 1 & PrepareEncoder.getScFwdDir());
        Assertions.assertTrue((access.getInt(0L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)(access.getInt(0L) >>> 1));
    }
}

