/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.RAMIntDataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.Helper;
import java.io.File;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DataAccessTest {
    private final File folder = new File("./target/tmp/da");
    protected String directory;
    protected String name = "dataacess";

    public DataAccess createDataAccess(String location) {
        return this.createDataAccess(location, 128);
    }

    public abstract DataAccess createDataAccess(String var1, int var2);

    @BeforeEach
    public void setUp() {
        if (!Helper.removeDir((File)this.folder)) {
            throw new IllegalStateException("cannot delete folder " + String.valueOf(this.folder));
        }
        this.folder.mkdirs();
        this.directory = this.folder.getAbsolutePath() + "/";
    }

    @AfterEach
    public void tearDown() {
        Helper.removeDir((File)this.folder);
    }

    @Test
    public void testLoadFlush() {
        DataAccess da = this.createDataAccess(this.name);
        Assertions.assertFalse((boolean)da.loadExisting());
        da.create(300L);
        da.setInt(28L, 123);
        Assertions.assertEquals((int)123, (int)da.getInt(28L));
        da.setInt(40L, 0x2AAAAAAA);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)da.getInt(40L));
        da.flush();
        Assertions.assertEquals((int)0, (int)da.getInt(8L));
        Assertions.assertEquals((int)0, (int)da.getInt(12L));
        Assertions.assertEquals((int)123, (int)da.getInt(28L));
        Assertions.assertEquals((int)0x2AAAAAAA, (int)da.getInt(40L));
        da.close();
        try {
            da.loadExisting();
            Assertions.assertTrue((boolean)false);
        }
        catch (Exception ex) {
            Assertions.assertEquals((Object)"already closed", (Object)ex.getMessage());
        }
        da = this.createDataAccess(this.name);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)123, (int)da.getInt(28L));
        da.close();
    }

    @Test
    public void testExceptionIfNoEnsureCapacityWasCalled() {
        DataAccess da = this.createDataAccess(this.name);
        Assertions.assertFalse((boolean)da.loadExisting());
        try {
            da.setInt(8L, 321);
            Assertions.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testLoadClose() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(300L);
        da.setInt(8L, 321);
        da.flush();
        da.close();
        da = this.createDataAccess(this.name);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)321, (int)da.getInt(8L));
        da.close();
    }

    @Test
    public void testHeader() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(300L);
        da.setHeader(28, 123);
        Assertions.assertEquals((int)123, (int)da.getHeader(28));
        da.setHeader(40, 0x2AAAAAAA);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)da.getHeader(40));
        da.setHeader(44, Helper.degreeToInt((double)123.321));
        Assertions.assertEquals((double)123.321, (double)Helper.intToDegree((int)da.getHeader(44)), (double)1.0E-4);
        da.flush();
        da.close();
        da = this.createDataAccess(this.name);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)123, (int)da.getHeader(28));
        da.close();
    }

    @Test
    public void testEnsureCapacity() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(128L);
        da.setInt(124L, 200);
        Assertions.assertEquals((int)200, (int)da.getInt(124L));
        da.ensureCapacity(256L);
        Assertions.assertEquals((int)200, (int)da.getInt(124L));
        da.setInt(128L, 220);
        Assertions.assertEquals((int)220, (int)da.getInt(128L));
        da.close();
        da = this.createDataAccess(this.name);
        da.create(800L);
        da.ensureCapacity(2400L);
        da.close();
    }

    @Test
    public void testSegments() {
        DataAccess da = this.createDataAccess(this.name, 128);
        da.create(10L);
        Assertions.assertEquals((int)1, (int)da.getSegments());
        da.ensureCapacity(500L);
        int olds = da.getSegments();
        Assertions.assertTrue((olds > 3 ? 1 : 0) != 0);
        da.setInt(400L, 321);
        da.flush();
        da.close();
        da = this.createDataAccess(this.name);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)olds, (int)da.getSegments());
        Assertions.assertEquals((int)321, (int)da.getInt(400L));
        da.close();
    }

    @Test
    public void testSegmentSize() {
        DataAccess da = this.createDataAccess(this.name, 20);
        da.create(10L);
        Assertions.assertEquals((int)128, (int)da.getSegmentSize());
        da.flush();
        da.close();
        da = this.createDataAccess(this.name, 256);
        da.loadExisting();
        Assertions.assertEquals((int)128, (int)da.getSegmentSize());
        da.close();
    }

    @Test
    public void testSet_GetBytes() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(300L);
        Assertions.assertEquals((int)128, (int)da.getSegmentSize());
        byte[] bytes = BitUtil.LITTLE.fromInt(0x2AAAAAAA);
        da.setBytes(8L, bytes, bytes.length);
        bytes = new byte[4];
        da.getBytes(8L, bytes, bytes.length);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)BitUtil.LITTLE.toInt(bytes));
        da.setBytes(127L, bytes, bytes.length);
        da.getBytes(127L, bytes, bytes.length);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)BitUtil.LITTLE.toInt(bytes));
        da.close();
        long bytePos = 4294978407L;
        int segmentSizePower = 24;
        int segmentSizeInBytes = 1 << segmentSizePower;
        int indexDivisor = segmentSizeInBytes - 1;
        int bufferIndex = (int)(bytePos >>> segmentSizePower);
        int index = (int)(bytePos & (long)indexDivisor);
        Assertions.assertEquals((int)256, (int)bufferIndex);
        Assertions.assertEquals((int)11111, (int)index);
    }

    @Test
    public void testSet_GetByte() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(300L);
        da.setByte(8L, (byte)120);
        Assertions.assertEquals((int)120, (int)da.getByte(8L));
        da.close();
    }

    @Test
    public void testSet_Get_Short_Long() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(300L);
        da.setShort(6L, (short)6553);
        da.setShort(8L, (short)4681);
        da.setShort(10L, (short)3640);
        da.setShort(14L, (short)3276);
        int unsignedShort = 32772;
        da.setShort(12L, (short)unsignedShort);
        Assertions.assertEquals((int)6553, (int)da.getShort(6L));
        Assertions.assertEquals((int)4681, (int)da.getShort(8L));
        Assertions.assertEquals((int)3640, (int)da.getShort(10L));
        Assertions.assertEquals((int)3276, (int)da.getShort(14L));
        Assertions.assertEquals((int)unsignedShort, (int)(da.getShort(12L) & 0xFFFF));
        if (!(da instanceof RAMIntDataAccess)) {
            da.setShort(7L, (short)10922);
            Assertions.assertEquals((int)10922, (int)da.getShort(7L));
            Assertions.assertNotEquals((int)10922, (int)da.getShort(8L));
            long pointer = da.getSegmentSize() - 1;
            da.setShort(pointer, (short)10922);
            Assertions.assertEquals((int)10922, (int)da.getShort(pointer));
        }
        da.close();
    }

    @Test
    public void testPadding() {
        DataAccess da = this.createDataAccess(this.name);
        da.create(10L);
        da.ensureCapacity(12800L);
        Assertions.assertEquals((int)100, (int)da.getSegments());
        int val = 0x3FFFFFFF;
        for (int i = 0; i < 10000; ++i) {
            da.setInt((long)i, val * i);
            Assertions.assertEquals((int)(val * i), (int)da.getInt((long)i), (String)("idx " + i));
            da.setInt((long)i, -val * i);
            Assertions.assertEquals((int)(-val * i), (int)da.getInt((long)i), (String)("idx " + i));
        }
        Random rand = new Random(0L);
        for (int i = 0; i < 10000; ++i) {
            val = 1 << rand.nextInt(32) + rand.nextInt();
            da.setInt((long)i, val);
            Assertions.assertEquals((int)val, (int)da.getInt((long)i), (String)("idx " + i));
            da.setInt((long)i, -val);
            Assertions.assertEquals((int)(-val), (int)da.getInt((long)i), (String)("idx " + i));
        }
        da.close();
    }
}

