/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.GHDirectory;
import java.util.LinkedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GHDirectoryTest {
    GHDirectoryTest() {
    }

    @Test
    public void testConfigure() {
        GHDirectory dir = new GHDirectory("", DAType.RAM_STORE);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nodes", "MMAP");
        dir.configure(map);
        Assertions.assertEquals((Object)DAType.MMAP, (Object)dir.getDefaultType("nodes", true));
        map.put("preload.nodes", "10");
        map.put("preload.nodes.*", "100");
        dir.configure(map);
        Assertions.assertEquals((int)10, (int)dir.getPreload("nodes"));
    }

    @Test
    public void testPatternMatching() {
        GHDirectory dir = new GHDirectory("", DAType.RAM_STORE);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nodes_ch.*", "MMAP");
        dir.configure(map);
        Assertions.assertEquals((Object)DAType.RAM_STORE, (Object)dir.getDefaultType("nodes", false));
        Assertions.assertEquals((Object)DAType.MMAP, (Object)dir.getDefaultType("nodes_ch_car", false));
    }
}

