/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.DataAccessTest;
import com.graphhopper.storage.MMapDataAccess;
import com.graphhopper.storage.RAMDataAccess;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MMapDataAccessTest
extends DataAccessTest {
    @Override
    public DataAccess createDataAccess(String name, int segmentSize) {
        return new MMapDataAccess(name, this.directory, true, segmentSize);
    }

    @Test
    public void textMixRAM2MMAP() {
        RAMDataAccess da = new RAMDataAccess(this.name, this.directory, true, -1);
        Assertions.assertFalse((boolean)da.loadExisting());
        da.create(100L);
        da.setInt(28L, 123);
        da.flush();
        da.close();
        da = this.createDataAccess(this.name);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)123, (int)da.getInt(28L));
        da.close();
    }

    @Test
    public void textMixMMAP2RAM() {
        DataAccess da = this.createDataAccess(this.name);
        Assertions.assertFalse((boolean)da.loadExisting());
        da.create(100L);
        da.setInt(28L, 123);
        da.flush();
        da.close();
        da = new RAMDataAccess(this.name, this.directory, true, -1);
        Assertions.assertTrue((boolean)da.loadExisting());
        Assertions.assertEquals((int)123, (int)da.getInt(28L));
        da.close();
    }
}

