/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractLockFactoryTester;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import java.nio.channels.OverlappingFileLockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NativeFSLockFactoryTest
extends AbstractLockFactoryTester {
    @Override
    protected LockFactory createLockFactory() {
        return new NativeFSLockFactory(this.lockDir);
    }

    @Test
    public void testMultiReadObtain() {
        LockFactory instance = this.createLockFactory();
        instance.setLockDir(this.lockDir);
        GHLock writeLock1 = instance.create("test", true);
        Assertions.assertTrue((boolean)writeLock1.tryLock());
        GHLock lock2 = instance.create("test", false);
        Assertions.assertFalse((boolean)lock2.tryLock());
        writeLock1.release();
        Assertions.assertTrue((boolean)lock2.tryLock());
        Assertions.assertTrue((boolean)lock2.isLocked());
        GHLock writeLock4 = instance.create("test", true);
        Assertions.assertFalse((boolean)writeLock4.tryLock());
        Assertions.assertEquals(OverlappingFileLockException.class, writeLock4.getObtainFailedReason().getClass());
        writeLock4.release();
        Assertions.assertTrue((boolean)lock2.isLocked());
        lock2.release();
    }
}

