/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ShortcutUnpackerTest {
    private static final int PREV_EDGE = 12;
    private static final int NEXT_EDGE = 13;

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testUnpacking(Fixture f) {
        f.graph.edge(0, 1).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(1, 2).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(2, 3).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(3, 4).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(4, 5).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(5, 6).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.freeze();
        f.setCHLevels(1, 3, 5, 4, 2, 0, 6);
        f.shortcut(4, 2, 2, 3, 4, 6, true);
        f.shortcut(4, 6, 4, 5, 8, 10, false);
        f.shortcut(2, 0, 0, 1, 0, 2, true);
        f.shortcut(2, 6, 6, 7, 4, 10, false);
        f.shortcut(0, 6, 8, 9, 0, 10, false);
        TestVisitor visitor = new TestVisitor(f.routingCHGraph);
        f.visitFwd(10, 6, false, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 6}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        if (f.edgeBased) {
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{12, 0, 1, 2, 3, 4}), (Object)visitor.prevOrNextEdgeIds);
        }
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitFwd(10, 6, true, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 5, 4, 3, 2, 1}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        if (f.edgeBased) {
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1, 0, 12}), (Object)visitor.prevOrNextEdgeIds);
        }
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, false, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 5, 4, 3, 2, 1}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        if (f.edgeBased) {
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{13, 5, 4, 3, 2, 1}), (Object)visitor.prevOrNextEdgeIds);
        }
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, true, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 6}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        if (f.edgeBased) {
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 13}), (Object)visitor.prevOrNextEdgeIds);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void loopShortcut(Fixture f) {
        Assumptions.assumeTrue((boolean)f.edgeBased, (String)"loop shortcuts only exist for edge-based CH");
        f.graph.edge(0, 1).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(1, 2).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(2, 3).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(3, 4).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(4, 1).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.graph.edge(1, 5).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.freeze();
        f.setCHLevels(2, 4, 3, 1, 5, 0);
        f.shortcut(3, 1, 1, 2, 2, 4, true);
        f.shortcut(3, 1, 3, 4, 6, 8, false);
        f.shortcut(1, 1, 6, 7, 2, 8, false);
        f.shortcut(1, 0, 0, 8, 0, 8, true);
        f.shortcut(5, 0, 9, 5, 0, 10, true);
        TestVisitor visitor = new TestVisitor(f.routingCHGraph);
        f.visitFwd(10, 5, false, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 1}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 1, 5}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{12, 0, 1, 2, 3, 4}), (Object)visitor.prevOrNextEdgeIds);
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitFwd(10, 5, true, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 4, 3, 2, 1, 0}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 1, 4, 3, 2, 1}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1, 0, 12}), (Object)visitor.prevOrNextEdgeIds);
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, false, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 1, 4, 3, 2, 1}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 4, 3, 2, 1, 0}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{13, 5, 4, 3, 2, 1}), (Object)visitor.prevOrNextEdgeIds);
        visitor = new TestVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, true, visitor);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5}), (Object)visitor.edgeIds);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 1, 5}), (Object)visitor.baseNodes);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 1}), (Object)visitor.adjNodes);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05}), (Object)visitor.weights);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), (Object)visitor.distances);
        Assertions.assertEquals((Object)DoubleArrayList.from((double[])new double[]{50.0, 50.0, 50.0, 50.0, 50.0, 50.0}), (Object)visitor.times);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 13}), (Object)visitor.prevOrNextEdgeIds);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void withCalcTurnWeight(Fixture f) {
        Assumptions.assumeTrue((boolean)f.edgeBased);
        EdgeIteratorState edge0 = f.graph.edge(0, 1).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        EdgeIteratorState edge1 = f.graph.edge(1, 2).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        EdgeIteratorState edge2 = f.graph.edge(2, 3).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        EdgeIteratorState edge3 = f.graph.edge(3, 4).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        EdgeIteratorState edge4 = f.graph.edge(4, 5).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        EdgeIteratorState edge5 = f.graph.edge(5, 6).setDistance(1.0).set(f.speedEnc, 20.0, 10.0);
        f.freeze();
        f.setTurnCost(12, 0, edge0.getEdge(), 2.0);
        f.setTurnCost(edge0.getEdge(), 1, edge1.getEdge(), 5.0);
        f.setTurnCost(edge1.getEdge(), 2, edge2.getEdge(), 3.0);
        f.setTurnCost(edge2.getEdge(), 3, edge3.getEdge(), 2.0);
        f.setTurnCost(edge3.getEdge(), 4, edge4.getEdge(), 1.0);
        f.setTurnCost(edge4.getEdge(), 5, edge5.getEdge(), 4.0);
        f.setTurnCost(edge5.getEdge(), 6, 13, 6.0);
        f.setTurnCost(13, 6, edge5.getEdge(), 2.0);
        f.setTurnCost(edge5.getEdge(), 5, edge4.getEdge(), 3.0);
        f.setTurnCost(edge4.getEdge(), 4, edge3.getEdge(), 2.0);
        f.setTurnCost(edge3.getEdge(), 3, edge2.getEdge(), 4.0);
        f.setTurnCost(edge2.getEdge(), 2, edge1.getEdge(), 1.0);
        f.setTurnCost(edge1.getEdge(), 1, edge0.getEdge(), 0.0);
        f.setTurnCost(edge0.getEdge(), 0, 12, 1.0);
        f.setCHLevels(1, 3, 5, 4, 2, 0, 6);
        f.shortcut(4, 2, 2, 3, 4, 6, true);
        f.shortcut(4, 6, 4, 5, 8, 10, false);
        f.shortcut(2, 0, 0, 1, 0, 2, true);
        f.shortcut(2, 6, 6, 7, 4, 10, false);
        f.shortcut(0, 6, 8, 9, 0, 10, false);
        TurnWeightingVisitor visitor = new TurnWeightingVisitor(f.routingCHGraph);
        f.visitFwd(10, 6, false, visitor);
        Assertions.assertEquals((double)17.3, (double)visitor.weight, (double)0.001, (String)"wrong weight");
        Assertions.assertEquals((long)17300L, (long)visitor.time, (String)"wrong time");
        visitor = new TurnWeightingVisitor(f.routingCHGraph);
        f.visitFwd(10, 6, true, visitor);
        Assertions.assertEquals((double)17.3, (double)visitor.weight, (double)0.001, (String)"wrong weight");
        Assertions.assertEquals((long)17300L, (long)visitor.time, (String)"wrong time");
        visitor = new TurnWeightingVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, false, visitor);
        Assertions.assertEquals((double)21.3, (double)visitor.weight, (double)0.001, (String)"wrong weight");
        Assertions.assertEquals((long)21300L, (long)visitor.time, (String)"wrong time");
        visitor = new TurnWeightingVisitor(f.routingCHGraph);
        f.visitBwd(10, 0, true, visitor);
        Assertions.assertEquals((double)21.3, (double)visitor.weight, (double)0.001, (String)"wrong weight");
        Assertions.assertEquals((long)21300L, (long)visitor.time, (String)"wrong time");
    }

    private static final class Fixture {
        private final boolean edgeBased;
        private final DecimalEncodedValue speedEnc;
        private final DecimalEncodedValue turnCostEnc;
        private final BaseGraph graph;
        private CHStorageBuilder chBuilder;
        private RoutingCHGraph routingCHGraph;

        Fixture(boolean edgeBased) {
            this.edgeBased = edgeBased;
            this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
            this.turnCostEnc = TurnCost.create((String)"car", (int)10);
            EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
            this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        }

        public String toString() {
            return "edge_based=" + this.edgeBased;
        }

        private void freeze() {
            this.graph.freeze();
            CHConfig chConfig = new CHConfig("profile", (Weighting)(this.edgeBased ? new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY) : new SpeedWeighting(this.speedEnc)), this.edgeBased);
            CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
            this.chBuilder = new CHStorageBuilder(chStore);
            this.routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        }

        private void setCHLevels(int ... order) {
            for (int i = 0; i < order.length; ++i) {
                this.chBuilder.setLevel(order[i], i);
            }
        }

        private void visitFwd(int edge, int adj, boolean reverseOrder, ShortcutUnpacker.Visitor visitor) {
            this.createShortcutUnpacker(visitor).visitOriginalEdgesFwd(edge, adj, reverseOrder, 12);
        }

        private void visitBwd(int edge, int adjNode, boolean reverseOrder, ShortcutUnpacker.Visitor visitor) {
            this.createShortcutUnpacker(visitor).visitOriginalEdgesBwd(edge, adjNode, reverseOrder, 13);
        }

        private ShortcutUnpacker createShortcutUnpacker(ShortcutUnpacker.Visitor visitor) {
            return new ShortcutUnpacker(this.routingCHGraph, visitor, this.edgeBased);
        }

        private void setTurnCost(int fromEdge, int viaNode, int toEdge, double cost) {
            this.graph.getTurnCostStorage().set(this.turnCostEnc, fromEdge, viaNode, toEdge, cost);
        }

        private void shortcut(int baseNode, int adjNode, int skip1, int skip2, int origKeyFirst, int origKeyLast, boolean reverse) {
            int flags;
            double weight = 1.0;
            int n = flags = reverse ? PrepareEncoder.getScFwdDir() : PrepareEncoder.getScBwdDir();
            if (this.edgeBased) {
                this.chBuilder.addShortcutEdgeBased(baseNode, adjNode, flags, weight, skip1, skip2, origKeyFirst, origKeyLast);
            } else {
                this.chBuilder.addShortcutNodeBased(baseNode, adjNode, flags, weight, skip1, skip2);
            }
        }
    }

    private static class TestVisitor
    implements ShortcutUnpacker.Visitor {
        private final RoutingCHGraph routingCHGraph;
        private final IntArrayList edgeIds = new IntArrayList();
        private final IntArrayList adjNodes = new IntArrayList();
        private final IntArrayList baseNodes = new IntArrayList();
        private final IntArrayList prevOrNextEdgeIds = new IntArrayList();
        private final DoubleArrayList weights = new DoubleArrayList();
        private final DoubleArrayList distances = new DoubleArrayList();
        private final DoubleArrayList times = new DoubleArrayList();

        TestVisitor(RoutingCHGraph routingCHGraph) {
            this.routingCHGraph = routingCHGraph;
        }

        public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
            this.edgeIds.add(edge.getEdge());
            this.baseNodes.add(edge.getBaseNode());
            this.adjNodes.add(edge.getAdjNode());
            this.weights.add(GHUtility.calcWeightWithTurnWeight((Weighting)this.routingCHGraph.getWeighting(), (EdgeIteratorState)edge, (boolean)reverse, (int)prevOrNextEdgeId));
            this.distances.add(edge.getDistance());
            this.times.add((double)GHUtility.calcMillisWithTurnMillis((Weighting)this.routingCHGraph.getWeighting(), (EdgeIteratorState)edge, (boolean)reverse, (int)prevOrNextEdgeId));
            this.prevOrNextEdgeIds.add(prevOrNextEdgeId);
        }
    }

    private static class TurnWeightingVisitor
    implements ShortcutUnpacker.Visitor {
        private final RoutingCHGraph routingCHGraph;
        private long time = 0L;
        private double weight = 0.0;

        TurnWeightingVisitor(RoutingCHGraph routingCHGraph) {
            this.routingCHGraph = routingCHGraph;
        }

        public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
            this.time += GHUtility.calcMillisWithTurnMillis((Weighting)this.routingCHGraph.getWeighting(), (EdgeIteratorState)edge, (boolean)reverse, (int)prevOrNextEdgeId);
            this.weight += GHUtility.calcWeightWithTurnWeight((Weighting)this.routingCHGraph.getWeighting(), (EdgeIteratorState)edge, (boolean)reverse, (int)prevOrNextEdgeId);
        }
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(new Fixture(false), new Fixture(true)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

