/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.Directory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StorablePropertiesTest {
    Directory createDir(String location, boolean store) {
        return new RAMDirectory(location, store).create();
    }

    @Test
    public void testLoad() {
        StorableProperties instance = new StorableProperties(this.createDir("", false));
        Assertions.assertFalse((boolean)instance.loadExisting());
        instance = new StorableProperties(this.createDir("", true));
        Assertions.assertFalse((boolean)instance.loadExisting());
        instance.close();
    }

    @Test
    public void testStore() {
        String dir = "./target/test";
        Helper.removeDir((File)new File(dir));
        StorableProperties instance = new StorableProperties(this.createDir(dir, true));
        instance.create(1000L);
        instance.put("test.min", (Object)123);
        instance.put("test.max", (Object)321);
        instance.flush();
        instance.close();
        instance = new StorableProperties(this.createDir(dir, true));
        Assertions.assertTrue((boolean)instance.loadExisting());
        Assertions.assertEquals((Object)"123", (Object)instance.get("test.min"));
        Assertions.assertEquals((Object)"321", (Object)instance.get("test.max"));
        instance.close();
        Helper.removeDir((File)new File(dir));
    }

    @Test
    public void testStoreLarge() {
        String dir = "./target/test";
        Helper.removeDir((File)new File(dir));
        StorableProperties instance = new StorableProperties(this.createDir(dir, true));
        instance.create(1000L);
        for (int i = 0; i <= 100000; ++i) {
            instance.put(Integer.toString(i), "test." + i);
        }
        instance.flush();
        long bytesWritten = instance.getCapacity();
        instance.close();
        instance = new StorableProperties(this.createDir(dir, true));
        Assertions.assertTrue((boolean)instance.loadExisting());
        Assertions.assertEquals((long)bytesWritten, (long)instance.getCapacity());
        Assertions.assertEquals((Object)"test.0", (Object)instance.get("0"));
        Assertions.assertEquals((Object)"test.100000", (Object)instance.get("100000"));
        instance.close();
        Helper.removeDir((File)new File(dir));
    }

    @Test
    public void testLoadProperties() throws IOException {
        HashMap map = new HashMap();
        StorableProperties.loadProperties(map, (Reader)new StringReader("blup=test\n blup2 = xy"));
        Assertions.assertEquals((Object)"test", map.get("blup"));
        Assertions.assertEquals((Object)"xy", map.get("blup2"));
    }
}

