/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TurnCostStorageTest {
    private EncodingManager manager;
    private DecimalEncodedValue carTurnCostEnc;
    private DecimalEncodedValue bikeTurnCostEnc;
    private BooleanEncodedValue accessEnc;
    private DecimalEncodedValue speedEnc;

    @BeforeEach
    public void setup() {
        this.accessEnc = new SimpleBooleanEncodedValue("car_access", true);
        this.speedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        this.carTurnCostEnc = TurnCost.create((String)"car", (int)3);
        this.bikeTurnCostEnc = TurnCost.create((String)"bike", (int)3);
        this.manager = EncodingManager.start().add((EncodedValue)this.accessEnc).add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.carTurnCostEnc).addTurnCostEncodedValue((EncodedValue)this.bikeTurnCostEnc).build();
    }

    public static void initGraph(BaseGraph g, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc) {
        GHUtility.setSpeed((double)60.0, (double)60.0, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{g.edge(0, 1).setDistance(3.0), g.edge(0, 2).setDistance(1.0), g.edge(1, 3).setDistance(1.0), g.edge(2, 3).setDistance(1.0), g.edge(2, 4).setDistance(1.0)});
    }

    @Test
    public void testMultipleTurnCosts() {
        BaseGraph g = new BaseGraph.Builder(this.manager).withTurnCosts(true).create();
        TurnCostStorageTest.initGraph(g, this.accessEnc, this.speedEnc);
        TurnCostStorage turnCostStorage = g.getTurnCostStorage();
        DecimalEncodedValue carEnc = this.carTurnCostEnc;
        DecimalEncodedValue bikeEnc = this.bikeTurnCostEnc;
        int edge42 = GHUtility.getEdge((Graph)g, (int)4, (int)2).getEdge();
        int edge23 = GHUtility.getEdge((Graph)g, (int)2, (int)3).getEdge();
        int edge31 = GHUtility.getEdge((Graph)g, (int)3, (int)1).getEdge();
        int edge10 = GHUtility.getEdge((Graph)g, (int)1, (int)0).getEdge();
        int edge02 = GHUtility.getEdge((Graph)g, (int)0, (int)2).getEdge();
        int edge24 = GHUtility.getEdge((Graph)g, (int)2, (int)4).getEdge();
        turnCostStorage.set(carEnc, edge42, 2, edge23, Double.POSITIVE_INFINITY);
        turnCostStorage.set(bikeEnc, edge42, 2, edge23, Double.POSITIVE_INFINITY);
        turnCostStorage.set(carEnc, edge23, 3, edge31, Double.POSITIVE_INFINITY);
        turnCostStorage.set(bikeEnc, edge23, 3, edge31, 2.0);
        turnCostStorage.set(carEnc, edge31, 1, edge10, 2.0);
        turnCostStorage.set(bikeEnc, edge31, 1, edge10, Double.POSITIVE_INFINITY);
        turnCostStorage.set(bikeEnc, edge02, 2, edge24, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((int)turnCostStorage.getTurnCostsCount(), (int)IntStream.range(0, g.getNodes()).map(arg_0 -> ((TurnCostStorage)turnCostStorage).getTurnCostsCount(arg_0)).sum());
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(carEnc, edge42, 2, edge23), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(bikeEnc, edge42, 2, edge23), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(carEnc, edge23, 3, edge31), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)turnCostStorage.get(bikeEnc, edge23, 3, edge31), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)turnCostStorage.get(carEnc, edge31, 1, edge10), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(bikeEnc, edge31, 1, edge10), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)turnCostStorage.get(carEnc, edge02, 2, edge24), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(bikeEnc, edge02, 2, edge24), (double)0.0);
        turnCostStorage.set(carEnc, edge02, 2, edge23, Double.POSITIVE_INFINITY);
        turnCostStorage.set(bikeEnc, edge02, 2, edge23, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(carEnc, edge02, 2, edge23), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(bikeEnc, edge02, 2, edge23), (double)0.0);
        HashSet<List<Integer>> turnCosts = new HashSet<List<Integer>>();
        TurnCostStorage.Iterator iterator = turnCostStorage.getAllTurnCosts();
        while (iterator.next()) {
            turnCosts.add(Arrays.asList(iterator.getFromEdge(), iterator.getViaNode(), iterator.getToEdge(), (int)iterator.getCost(carEnc), (int)iterator.getCost(bikeEnc)));
        }
        HashSet<List<Integer>> expectedTurnCosts = new HashSet<List<Integer>>();
        expectedTurnCosts.add(Arrays.asList(edge31, 1, edge10, 2, Integer.MAX_VALUE));
        expectedTurnCosts.add(Arrays.asList(edge42, 2, edge23, Integer.MAX_VALUE, Integer.MAX_VALUE));
        expectedTurnCosts.add(Arrays.asList(edge02, 2, edge24, 0, Integer.MAX_VALUE));
        expectedTurnCosts.add(Arrays.asList(edge02, 2, edge23, Integer.MAX_VALUE, Integer.MAX_VALUE));
        expectedTurnCosts.add(Arrays.asList(edge23, 3, edge31, Integer.MAX_VALUE, 2));
        Assertions.assertEquals(expectedTurnCosts, turnCosts);
    }

    @Test
    public void testMergeFlagsBeforeAdding() {
        BaseGraph g = new BaseGraph.Builder(this.manager).withTurnCosts(true).create();
        TurnCostStorageTest.initGraph(g, this.accessEnc, this.speedEnc);
        TurnCostStorage turnCostStorage = g.getTurnCostStorage();
        DecimalEncodedValue carEnc = this.carTurnCostEnc;
        DecimalEncodedValue bikeEnc = this.bikeTurnCostEnc;
        int edge23 = GHUtility.getEdge((Graph)g, (int)2, (int)3).getEdge();
        int edge02 = GHUtility.getEdge((Graph)g, (int)0, (int)2).getEdge();
        turnCostStorage.set(carEnc, edge02, 2, edge23, Double.POSITIVE_INFINITY);
        turnCostStorage.set(bikeEnc, edge02, 2, edge23, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(carEnc, edge02, 2, edge23), (double)0.0);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(bikeEnc, edge02, 2, edge23), (double)0.0);
        HashSet<List<Integer>> turnCosts = new HashSet<List<Integer>>();
        TurnCostStorage.Iterator iterator = turnCostStorage.getAllTurnCosts();
        while (iterator.next()) {
            turnCosts.add(Arrays.asList(iterator.getFromEdge(), iterator.getViaNode(), iterator.getToEdge(), (int)iterator.getCost(carEnc), (int)iterator.getCost(bikeEnc)));
        }
        HashSet<List<Integer>> expectedTurnCosts = new HashSet<List<Integer>>();
        expectedTurnCosts.add(Arrays.asList(edge02, 2, edge23, Integer.MAX_VALUE, Integer.MAX_VALUE));
        Assertions.assertEquals(expectedTurnCosts, turnCosts);
    }

    @Test
    public void setMultipleTimes() {
        BaseGraph g = new BaseGraph.Builder(this.manager).withTurnCosts(true).create();
        TurnCostStorageTest.initGraph(g, this.accessEnc, this.speedEnc);
        TurnCostStorage turnCostStorage = g.getTurnCostStorage();
        DecimalEncodedValue carEnc = this.carTurnCostEnc;
        int edge32 = GHUtility.getEdge((Graph)g, (int)3, (int)2).getEdge();
        int edge20 = GHUtility.getEdge((Graph)g, (int)2, (int)0).getEdge();
        Assertions.assertEquals((double)0.0, (double)turnCostStorage.get(carEnc, edge32, 2, edge20));
        turnCostStorage.set(carEnc, edge32, 2, edge20, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)turnCostStorage.get(carEnc, edge32, 2, edge20));
        turnCostStorage.set(carEnc, edge32, 2, edge20, 0.0);
        turnCostStorage.set(carEnc, edge32, 2, edge20, Double.POSITIVE_INFINITY);
        turnCostStorage.set(carEnc, edge32, 2, edge20, 0.0);
        Assertions.assertEquals((double)0.0, (double)turnCostStorage.get(carEnc, edge32, 2, edge20));
    }

    @Test
    public void testIterateEmptyStore() {
        BaseGraph g = new BaseGraph.Builder(this.manager).withTurnCosts(true).create();
        TurnCostStorageTest.initGraph(g, this.accessEnc, this.speedEnc);
        TurnCostStorage turnCostStorage = g.getTurnCostStorage();
        TurnCostStorage.Iterator iterator = turnCostStorage.getAllTurnCosts();
        Assertions.assertFalse((boolean)iterator.next());
    }
}

