/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class LocationIndexTreeTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    protected final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).build();

    public static void initSimpleGraph(Graph g) {
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, -1.0, -2.0);
        na.setNode(1, 2.0, -1.0);
        na.setNode(2, 0.0, 1.0);
        na.setNode(3, 1.0, 2.0);
        na.setNode(4, 6.0, 1.0);
        na.setNode(5, 4.0, 4.0);
        na.setNode(6, 4.5, -0.5);
        List<EdgeIteratorState> list = Arrays.asList(g.edge(0, 1), g.edge(0, 2), g.edge(2, 3), g.edge(3, 4), g.edge(1, 4), g.edge(3, 5), g.edge(6, 4));
    }

    private LocationIndexTree createIndexNoPrepare(Graph g, int resolution) {
        RAMDirectory dir = new RAMDirectory();
        LocationIndexTree tmpIDX = new LocationIndexTree(g, (Directory)dir);
        tmpIDX.setResolution(resolution);
        return tmpIDX;
    }

    Graph createTestGraph(EncodingManager em, DecimalEncodedValue speedEnc) {
        BaseGraph graph = new BaseGraph.Builder(em).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 0.5, -0.5);
        na.setNode(1, -0.5, -0.5);
        na.setNode(2, -1.0, -1.0);
        na.setNode(3, -0.4, 0.9);
        na.setNode(4, -0.6, 1.6);
        graph.edge(0, 1).set(speedEnc, 60.0, 60.0);
        graph.edge(0, 2).set(speedEnc, 60.0, 60.0);
        graph.edge(0, 4).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 3).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 4).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 4).set(speedEnc, 60.0, 60.0);
        return graph;
    }

    @Test
    public void testSnappedPointAndGeometry() {
        Graph graph = this.createTestGraph(this.encodingManager, this.speedEnc);
        LocationIndex index = this.createIndexNoPrepare(graph, 500000).prepareIndex();
        Snap res = index.findClosest(-0.4, 0.9, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)res.isValid());
        Assertions.assertEquals((Object)new GHPoint(-0.4, 0.9), (Object)res.getSnappedPoint());
        res = index.findClosest(-0.6, 1.6, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)res.isValid());
        Assertions.assertEquals((Object)new GHPoint(-0.6, 1.6), (Object)res.getSnappedPoint());
        res = index.findClosest(-0.2, 0.3, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)res.isValid());
        Assertions.assertEquals((double)26936.0, (double)res.getQueryDistance(), (double)1.0);
        Assertions.assertEquals((Object)new GHPoint(-0.441624, 0.317259), (Object)res.getSnappedPoint());
    }

    @Test
    public void testBoundingBoxQuery2() {
        Graph graph = this.createTestGraph2();
        LocationIndexTree index = (LocationIndexTree)this.createIndexNoPrepare(graph, 500).prepareIndex();
        HashSet edges = new HashSet();
        index.query(graph.getBounds(), edges::add);
        Assertions.assertEquals((int)edges.size(), (int)graph.getEdges());
    }

    @Test
    public void testBoundingBoxQuery1() {
        Graph graph = this.createTestGraph2();
        LocationIndexTree index = (LocationIndexTree)this.createIndexNoPrepare(graph, 500).prepareIndex();
        IntArrayList edges = new IntArrayList();
        BBox bbox = new BBox(11.57114, 11.57814, 49.94553, 49.94853);
        index.query(bbox, arg_0 -> ((IntArrayList)edges).add(arg_0));
        Assertions.assertEquals((int)edges.size(), (int)graph.getEdges());
    }

    @Test
    public void testMoreReal() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 51.2492152, 9.4317166);
        na.setNode(0, 52.0, 9.0);
        na.setNode(2, 51.2, 9.4);
        na.setNode(3, 49.0, 10.0);
        graph.edge(1, 0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 2).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 3).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{51.21, 9.43}));
        LocationIndex index = this.createIndexNoPrepare((Graph)graph, 500000).prepareIndex();
        Assertions.assertEquals((int)1, (int)this.findClosestEdge(index, 51.2, 9.4));
    }

    private Graph createTestGraphWithWayGeometry() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 0.5, -0.5);
        na.setNode(1, -0.5, -0.5);
        na.setNode(2, -1.0, -1.0);
        na.setNode(3, -0.4, 0.9);
        na.setNode(4, -0.6, 1.6);
        graph.edge(0, 1).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 2).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 4).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.0, 1.0}));
        graph.edge(1, 3).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 0.0}));
        graph.edge(2, 3).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 4).set(this.speedEnc, 60.0, 60.0);
        graph.edge(3, 4).set(this.speedEnc, 60.0, 60.0);
        return graph;
    }

    @Test
    public void testWayGeometry() {
        Graph g = this.createTestGraphWithWayGeometry();
        LocationIndex index = this.createIndexNoPrepare(g, 500000).prepareIndex();
        Assertions.assertEquals((int)3, (int)this.findClosestEdge(index, 0.0, 0.0));
        Assertions.assertEquals((int)3, (int)this.findClosestEdge(index, 0.0, 0.1));
        Assertions.assertEquals((int)3, (int)this.findClosestEdge(index, 0.1, 0.1));
        Assertions.assertEquals((int)1, (int)this.findClosestNode(index, -0.5, -0.5));
    }

    @Test
    public void testFindingWayGeometry() {
        BaseGraph g = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(10, 51.2492152, 9.4317166);
        na.setNode(20, 52.0, 9.0);
        na.setNode(30, 51.2, 9.4);
        na.setNode(50, 49.0, 10.0);
        g.edge(20, 50).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{51.25, 9.43}));
        g.edge(10, 20).set(this.speedEnc, 60.0, 60.0);
        g.edge(20, 30).set(this.speedEnc, 60.0, 60.0);
        LocationIndex index = this.createIndexNoPrepare((Graph)g, 2000).prepareIndex();
        Assertions.assertEquals((int)0, (int)this.findClosestEdge(index, 51.25, 9.43));
    }

    @Test
    public void testEdgeFilter() {
        Graph graph = this.createTestGraph(this.encodingManager, this.speedEnc);
        LocationIndexTree index = (LocationIndexTree)this.createIndexNoPrepare(graph, 500000).prepareIndex();
        Assertions.assertEquals((int)1, (int)index.findClosest(-0.6, -0.6, EdgeFilter.ALL_EDGES).getClosestNode());
        Assertions.assertEquals((int)2, (int)index.findClosest(-0.6, -0.6, iter -> iter.getBaseNode() == 2 || iter.getAdjNode() == 2).getClosestNode());
    }

    Graph createTestGraph2() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 49.94653, 11.57114);
        na.setNode(1, 49.94653, 11.57214);
        na.setNode(2, 49.94653, 11.57314);
        na.setNode(3, 49.94653, 11.57414);
        na.setNode(4, 49.94653, 11.57514);
        na.setNode(5, 49.94653, 11.57614);
        na.setNode(6, 49.94653, 11.57714);
        na.setNode(7, 49.94653, 11.57814);
        na.setNode(8, 49.94553, 11.57214);
        na.setNode(9, 49.94553, 11.57314);
        na.setNode(10, 49.94553, 11.57414);
        na.setNode(11, 49.94553, 11.57514);
        na.setNode(12, 49.94553, 11.57614);
        na.setNode(13, 49.94553, 11.57714);
        na.setNode(14, 49.94753, 11.57214);
        na.setNode(15, 49.94753, 11.57314);
        na.setNode(16, 49.94753, 11.57614);
        na.setNode(17, 49.94753, 11.57814);
        na.setNode(18, 49.94853, 11.57114);
        na.setNode(19, 49.94853, 11.57214);
        na.setNode(20, 49.94853, 11.57814);
        na.setNode(21, 49.94953, 11.57214);
        na.setNode(22, 49.94953, 11.57614);
        na.setNode(23, 49.95053, 11.57114);
        na.setNode(24, 49.95053, 11.57214);
        na.setNode(25, 49.95053, 11.57314);
        na.setNode(26, 49.95053, 11.57514);
        na.setNode(27, 49.95053, 11.57614);
        na.setNode(28, 49.95053, 11.57714);
        na.setNode(29, 49.95053, 11.57814);
        na.setNode(30, 49.95153, 11.57214);
        na.setNode(31, 49.95153, 11.57314);
        na.setNode(32, 49.95153, 11.57514);
        na.setNode(33, 49.95153, 11.57614);
        na.setNode(34, 49.95153, 11.57714);
        na.setNode(100, 49.941, 11.56614);
        na.setNode(101, 49.96053, 11.58814);
        graph.edge(0, 1).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 2).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 3).set(this.speedEnc, 60.0, 60.0);
        graph.edge(3, 4).set(this.speedEnc, 60.0, 60.0);
        graph.edge(4, 5).set(this.speedEnc, 60.0, 60.0);
        graph.edge(6, 7).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 8).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 9).set(this.speedEnc, 60.0, 60.0);
        graph.edge(3, 10).set(this.speedEnc, 60.0, 60.0);
        graph.edge(4, 11).set(this.speedEnc, 60.0, 60.0);
        graph.edge(5, 12).set(this.speedEnc, 60.0, 60.0);
        graph.edge(6, 13).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 14).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 15).set(this.speedEnc, 60.0, 60.0);
        graph.edge(5, 16).set(this.speedEnc, 60.0, 60.0);
        graph.edge(14, 15).set(this.speedEnc, 60.0, 60.0);
        graph.edge(16, 17).set(this.speedEnc, 60.0, 60.0);
        graph.edge(16, 20).set(this.speedEnc, 60.0, 60.0);
        graph.edge(16, 25).set(this.speedEnc, 60.0, 60.0);
        graph.edge(18, 14).set(this.speedEnc, 60.0, 60.0);
        graph.edge(18, 19).set(this.speedEnc, 60.0, 60.0);
        graph.edge(18, 21).set(this.speedEnc, 60.0, 60.0);
        graph.edge(19, 21).set(this.speedEnc, 60.0, 60.0);
        graph.edge(21, 24).set(this.speedEnc, 60.0, 60.0);
        graph.edge(23, 24).set(this.speedEnc, 60.0, 60.0);
        graph.edge(24, 25).set(this.speedEnc, 60.0, 60.0);
        graph.edge(26, 27).set(this.speedEnc, 60.0, 60.0);
        graph.edge(27, 28).set(this.speedEnc, 60.0, 60.0);
        graph.edge(28, 29).set(this.speedEnc, 60.0, 60.0);
        graph.edge(24, 30).set(this.speedEnc, 60.0, 60.0);
        graph.edge(24, 31).set(this.speedEnc, 60.0, 60.0);
        graph.edge(26, 32).set(this.speedEnc, 60.0, 60.0);
        graph.edge(26, 22).set(this.speedEnc, 60.0, 60.0);
        graph.edge(27, 33).set(this.speedEnc, 60.0, 60.0);
        graph.edge(28, 34).set(this.speedEnc, 60.0, 60.0);
        return graph;
    }

    @Test
    public void testRMin() {
        double check2;
        Graph graph = this.createTestGraph(this.encodingManager, this.speedEnc);
        LocationIndexTree index = (LocationIndexTree)this.createIndexNoPrepare(graph, 50000).prepareIndex();
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        double rmin2 = index.calculateRMin(0.05, -0.3, 1);
        Assertions.assertTrue((rmin2 - (check2 = distCalc.calcDist(0.05, Math.abs(graph.getNodeAccess().getLat(0)), -0.3, -0.3)) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testSearchWithFilter_issue318() {
        SimpleBooleanEncodedValue carAccessEnc = new SimpleBooleanEncodedValue("car_access", true);
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        SimpleBooleanEncodedValue bikeAccessEnc = new SimpleBooleanEncodedValue("bike_access", true);
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, false);
        EncodingManager tmpEM = EncodingManager.start().add((EncodedValue)carAccessEnc).add((EncodedValue)carSpeedEnc).add((EncodedValue)bikeAccessEnc).add((EncodedValue)bikeSpeedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = graph.getNodeAccess();
        int MAX = 5;
        for (int latIdx = 0; latIdx < MAX; ++latIdx) {
            for (int lonIdx = 0; lonIdx < MAX; ++lonIdx) {
                int index = lonIdx * 10 + latIdx;
                na.setNode(index, 0.01 * (double)latIdx, 0.01 * (double)lonIdx);
                if (latIdx < MAX - 1) {
                    GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)carAccessEnc, (DecimalEncodedValue)carSpeedEnc, (EdgeIteratorState)graph.edge(index, index + 1));
                }
                if (lonIdx >= MAX - 1) continue;
                GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)carAccessEnc, (DecimalEncodedValue)carSpeedEnc, (EdgeIteratorState)graph.edge(index, index + 10));
            }
        }
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            iter.set((BooleanEncodedValue)bikeAccessEnc, false, false);
        }
        for (EdgeIteratorState edge : Arrays.asList(GHUtility.getEdge((Graph)graph, (int)0, (int)1), GHUtility.getEdge((Graph)graph, (int)1, (int)2))) {
            edge.set((BooleanEncodedValue)bikeAccessEnc, true, true);
        }
        LocationIndexTree index = this.createIndexNoPrepare((Graph)graph, 500);
        index.prepareIndex();
        index.setMaxRegionSearch(8);
        AccessFilter carFilter = AccessFilter.allEdges((BooleanEncodedValue)carAccessEnc);
        Snap snap = index.findClosest(0.03, 0.03, (EdgeFilter)carFilter);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((int)33, (int)snap.getClosestNode());
        AccessFilter bikeFilter = AccessFilter.allEdges((BooleanEncodedValue)bikeAccessEnc);
        snap = index.findClosest(0.03, 0.03, (EdgeFilter)bikeFilter);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((int)2, (int)snap.getClosestNode());
    }

    @Test
    public void testCrossBoundaryNetwork_issue667() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 0.1, 179.5);
        na.setNode(1, 0.1, 179.9);
        na.setNode(2, 0.1, -179.8);
        na.setNode(3, 0.1, -179.5);
        na.setNode(4, 0.0, 179.5);
        na.setNode(5, 0.0, 179.9);
        na.setNode(6, 0.0, -179.8);
        na.setNode(7, 0.0, -179.5);
        graph.edge(0, 1).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 4).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 5).set(this.speedEnc, 60.0, 60.0);
        graph.edge(4, 5).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 3).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 6).set(this.speedEnc, 60.0, 60.0);
        graph.edge(3, 7).set(this.speedEnc, 60.0, 60.0);
        graph.edge(6, 7).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 2).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 180.0, 0.0, -180.0}));
        graph.edge(5, 6).set(this.speedEnc, 60.0, 60.0);
        LocationIndexTree index = this.createIndexNoPrepare((Graph)graph, 500);
        index.prepareIndex();
        Assertions.assertTrue((graph.getNodes() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < graph.getNodes(); ++i) {
            Snap snap = index.findClosest(na.getLat(i), na.getLon(i), EdgeFilter.ALL_EDGES);
            Assertions.assertEquals((int)i, (int)snap.getClosestNode());
        }
    }

    private int findClosestNode(LocationIndex index, double lat, double lon) {
        Snap closest = index.findClosest(lat, lon, EdgeFilter.ALL_EDGES);
        assert (closest.getSnappedPosition() == Snap.Position.TOWER);
        return closest.getClosestNode();
    }

    private int findClosestEdge(LocationIndex index, double lat, double lon) {
        return index.findClosest(lat, lon, EdgeFilter.ALL_EDGES).getClosestEdge().getEdge();
    }

    @Test
    public void testSimpleGraph() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        LocationIndexTreeTest.initSimpleGraph((Graph)g);
        AllEdgesIterator edge = g.getAllEdges();
        while (edge.next()) {
            GHUtility.setSpeed((double)60.0, (double)60.0, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{edge});
        }
        LocationIndexTree idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 5.0, 2.0));
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 1.5, 2.0));
        Assertions.assertEquals((int)1, (int)this.findClosestEdge((LocationIndex)idx, -1.0, -1.0));
        Assertions.assertEquals((int)4, (int)this.findClosestEdge((LocationIndex)idx, 4.0, 0.0));
        g.close();
    }

    @Test
    public void testSimpleGraph2() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        LocationIndexTreeTest.initSimpleGraph((Graph)g);
        AllEdgesIterator edge = g.getAllEdges();
        while (edge.next()) {
            GHUtility.setSpeed((double)60.0, (double)60.0, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{edge});
        }
        LocationIndexTree idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 5.0, 2.0));
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 1.5, 2.0));
        Assertions.assertEquals((int)1, (int)this.findClosestEdge((LocationIndex)idx, -1.0, -1.0));
        Assertions.assertEquals((int)6, (int)this.findClosestNode((LocationIndex)idx, 4.5, -0.5));
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 4.0, 1.0));
        Assertions.assertEquals((int)4, (int)this.findClosestEdge((LocationIndex)idx, 4.0, 0.0));
        Assertions.assertEquals((int)6, (int)this.findClosestNode((LocationIndex)idx, 4.0, -2.0));
        Assertions.assertEquals((int)5, (int)this.findClosestEdge((LocationIndex)idx, 3.0, 3.0));
        g.close();
    }

    @Test
    public void testSinglePoints120() {
        BaseGraph g = this.createSampleGraph(this.encodingManager, this.speedEnc);
        LocationIndexTree idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)3, (int)this.findClosestEdge((LocationIndex)idx, 1.637, 2.23));
        Assertions.assertEquals((int)10, (int)this.findClosestEdge((LocationIndex)idx, 3.649, 1.375));
        Assertions.assertEquals((int)9, (int)this.findClosestNode((LocationIndex)idx, 3.3, 2.2));
        Assertions.assertEquals((int)6, (int)this.findClosestNode((LocationIndex)idx, 3.0, 1.5));
        Assertions.assertEquals((int)15, (int)this.findClosestEdge((LocationIndex)idx, 3.8, 0.0));
        Assertions.assertEquals((int)15, (int)this.findClosestEdge((LocationIndex)idx, 3.8466, 0.021));
        g.close();
    }

    @Test
    public void testSinglePoints32() {
        BaseGraph g = this.createSampleGraph(this.encodingManager, this.speedEnc);
        LocationIndexTree idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)10, (int)this.findClosestEdge((LocationIndex)idx, 3.649, 1.375));
        Assertions.assertEquals((int)15, (int)this.findClosestEdge((LocationIndex)idx, 3.8465748, 0.021762699));
        Assertions.assertEquals((int)4, (int)this.findClosestEdge((LocationIndex)idx, 2.485, 1.373));
        Assertions.assertEquals((int)0, (int)this.findClosestEdge((LocationIndex)idx, 0.64628404, 0.53006625));
        g.close();
    }

    @Test
    public void testNoErrorOnEdgeCase_lastIndex() {
        EncodingManager encodingManager = new EncodingManager.Builder().build();
        int locs = 10000;
        BaseGraph g = new BaseGraph.Builder(encodingManager).create();
        NodeAccess na = g.getNodeAccess();
        Random rand = new Random(12L);
        for (int i = 0; i < locs; ++i) {
            na.setNode(i, (double)((float)rand.nextDouble() * 10.0f + 10.0f), (double)((float)rand.nextDouble() * 10.0f + 10.0f));
        }
        this.createIndexNoPrepare((Graph)g, 200).prepareIndex();
        g.close();
    }

    public BaseGraph createSampleGraph(EncodingManager encodingManager, DecimalEncodedValue speedEnc) {
        BaseGraph graph = new BaseGraph.Builder(encodingManager).create();
        int a0 = 0;
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 0.0, (double)1.0001f);
        int b1 = 1;
        na.setNode(1, 1.0, 2.0);
        int c2 = 2;
        na.setNode(2, 0.5, 4.5);
        int d3 = 3;
        na.setNode(3, 1.5, (double)3.8f);
        int e4 = 4;
        na.setNode(4, (double)2.01f, 0.5);
        int f5 = 5;
        na.setNode(5, 2.0, 3.0);
        int g6 = 6;
        na.setNode(6, 3.0, 1.5);
        int h7 = 7;
        na.setNode(7, (double)2.99f, (double)3.01f);
        int i8 = 8;
        na.setNode(8, 3.0, 4.0);
        int j9 = 9;
        na.setNode(9, (double)3.3f, (double)2.2f);
        int k10 = 10;
        na.setNode(10, 4.0, 1.0);
        int l11 = 11;
        na.setNode(11, (double)4.1f, 3.0);
        int m12 = 12;
        na.setNode(12, 4.0, 4.5);
        int n13 = 13;
        na.setNode(13, 4.5, (double)4.1f);
        int o14 = 14;
        na.setNode(14, 5.0, 0.0);
        int p15 = 15;
        na.setNode(15, (double)4.9f, 2.5);
        int q16 = 16;
        na.setNode(16, 5.0, 5.0);
        graph.edge(a0, b1).set(speedEnc, 60.0, 60.0);
        graph.edge(c2, b1).set(speedEnc, 60.0, 60.0);
        graph.edge(c2, d3).set(speedEnc, 60.0, 60.0);
        graph.edge(f5, b1).set(speedEnc, 60.0, 60.0);
        graph.edge(e4, f5).set(speedEnc, 60.0, 60.0);
        graph.edge(m12, d3).set(speedEnc, 60.0, 60.0);
        graph.edge(e4, k10).set(speedEnc, 60.0, 60.0);
        graph.edge(f5, d3).set(speedEnc, 60.0, 60.0);
        graph.edge(f5, i8).set(speedEnc, 60.0, 60.0);
        graph.edge(f5, j9).set(speedEnc, 60.0, 60.0);
        graph.edge(k10, g6).set(speedEnc, 60.0, 60.0);
        graph.edge(j9, l11).set(speedEnc, 60.0, 60.0);
        graph.edge(i8, l11).set(speedEnc, 60.0, 60.0);
        graph.edge(i8, h7).set(speedEnc, 60.0, 60.0);
        graph.edge(k10, n13).set(speedEnc, 60.0, 60.0);
        graph.edge(k10, o14).set(speedEnc, 60.0, 60.0);
        graph.edge(l11, p15).set(speedEnc, 60.0, 60.0);
        graph.edge(m12, p15).set(speedEnc, 60.0, 60.0);
        graph.edge(q16, p15).set(speedEnc, 60.0, 60.0);
        graph.edge(q16, m12).set(speedEnc, 60.0, 60.0);
        return graph;
    }

    @Test
    public void testDifferentVehicles() {
        SimpleBooleanEncodedValue carAccessEnc = new SimpleBooleanEncodedValue("car_access", true);
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        SimpleBooleanEncodedValue footAccessEnc = new SimpleBooleanEncodedValue("foot_access", true);
        DecimalEncodedValueImpl footSpeedEnc = new DecimalEncodedValueImpl("foot_speed", 4, 1.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)carAccessEnc).add((EncodedValue)carSpeedEnc).add((EncodedValue)footAccessEnc).add((EncodedValue)footSpeedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        LocationIndexTreeTest.initSimpleGraph((Graph)g);
        AllEdgesIterator edge = g.getAllEdges();
        while (edge.next()) {
            GHUtility.setSpeed((double)60.0, (double)60.0, (BooleanEncodedValue)carAccessEnc, (DecimalEncodedValue)carSpeedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{edge});
            GHUtility.setSpeed((double)10.0, (double)10.0, (BooleanEncodedValue)footAccessEnc, (DecimalEncodedValue)footSpeedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{edge});
        }
        LocationIndexTree idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)0, (int)this.findClosestEdge((LocationIndex)idx, 1.0, -1.0));
        EdgeIterator iter = g.createEdgeExplorer().setBaseNode(1);
        while (iter.next()) {
            iter.set((BooleanEncodedValue)footAccessEnc, false, false);
        }
        idx = (LocationIndexTree)this.createIndexNoPrepare((Graph)g, 500000).prepareIndex();
        Assertions.assertEquals((int)2, (int)idx.findClosest(1.0, -1.0, (EdgeFilter)AccessFilter.allEdges((BooleanEncodedValue)footAccessEnc)).getClosestNode());
        g.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void closeToTowerNode(boolean snapAtBase) {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 51.9855, 19.254);
        na.setNode(1, 51.986, 19.255);
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        boolean snapNode = false;
        int base = snapAtBase ? 0 : 1;
        int adj = snapAtBase ? 1 : 0;
        graph.edge(base, adj).setDistance(distCalc.calcDist(na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1)));
        LocationIndexTree index = new LocationIndexTree((Graph)graph, graph.getDirectory());
        index.prepareIndex();
        GHPoint queryPoint = new GHPoint(51.9855003, 19.2540003);
        double distFromTower = distCalc.calcDist(queryPoint.lat, queryPoint.lon, na.getLat(0), na.getLon(0));
        Assertions.assertTrue((distFromTower < 0.1 ? 1 : 0) != 0);
        Snap snap = index.findClosest(queryPoint.lat, queryPoint.lon, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((Object)Snap.Position.TOWER, (Object)snap.getSnappedPosition());
    }

    @Test
    public void queryBehindBeforeOrBehindLastTowerNode() {
        BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 51.985, 19.254);
        na.setNode(1, 51.986, 19.255);
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(distCalc.calcDist(na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1)));
        edge.setWayGeometry(Helper.createPointList((double[])new double[]{51.9855, 19.2545}));
        LocationIndexTree index = new LocationIndexTree((Graph)graph, graph.getDirectory());
        index.prepareIndex();
        ArrayList output = new ArrayList();
        index.traverseEdge(51.9857, 19.2547, edge, (node, normedDist, wayIndex, pos) -> output.add(node + ", " + Math.round(distCalc.calcDenormalizedDist(normedDist)) + ", " + wayIndex + ", " + String.valueOf(pos)));
        Assertions.assertEquals(Arrays.asList("1, 39, 2, TOWER", "1, 26, 1, PILLAR", "1, 0, 1, EDGE"), output);
        output = new ArrayList();
        index.traverseEdge(51.9861, 19.2551, edge, (node, normedDist, wayIndex, pos) -> output.add(node + ", " + Math.round(distCalc.calcDenormalizedDist(normedDist)) + ", " + wayIndex + ", " + String.valueOf(pos)));
        Assertions.assertEquals(Arrays.asList("1, 13, 2, TOWER", "1, 78, 1, PILLAR"), output);
    }
}

