/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.storage.index.PixelGridTraversal;
import com.graphhopper.util.shapes.BBox;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.locationtech.jts.algorithm.RectangleLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class PixelGridTraversalTest {
    @ParameterizedTest
    @CsvSource(value={"5.5, 2.5, 0.5, 0.5", "3.5, 1.5, 0.5, 3.5", "2.5, 2.5, 3.5, 0.5", "0.5, 0.5, 2.5, 3.5", "2.5, 2.9, 3.1, 0.9"})
    public void testAgainstNaiveGridCellIntersection(double x1, double y1, double x2, double y2) {
        BBox bounds = new BBox(0.0, 10.0, 0.0, 10.0);
        int parts = 10;
        Coordinate a = new Coordinate(x1, y1);
        Coordinate b = new Coordinate(x2, y2);
        HashSet actual = new HashSet();
        PixelGridTraversal pixelGridTraversal = new PixelGridTraversal(parts, bounds);
        pixelGridTraversal.traverse(a, b, actual::add);
        HashSet<Coordinate> expected = new HashSet<Coordinate>();
        double deltaLat = (bounds.maxLat - bounds.minLat) / (double)parts;
        double deltaLon = (bounds.maxLon - bounds.minLon) / (double)parts;
        for (int y = 0; y < parts; ++y) {
            for (int x = 0; x < parts; ++x) {
                RectangleLineIntersector rectangleLineIntersector = new RectangleLineIntersector(new Envelope(bounds.minLon + (double)x * deltaLon, bounds.minLon + (double)(x + 1) * deltaLon, bounds.minLat + (double)y * deltaLat, bounds.minLat + (double)(y + 1) * deltaLat));
                if (!rectangleLineIntersector.intersects(a, b)) continue;
                expected.add(new Coordinate((double)x, (double)y));
            }
        }
        Assertions.assertEquals(expected, actual);
    }
}

